/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.rest;

import io.lucenia.ml.common.rest.MLRestHandler;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.ml.common.settings.MLFeatureEnabledSetting;
import io.skylite.ml.common.transport.controller.MLControllerDeleteAction;
import io.skylite.ml.common.transport.controller.MLControllerDeleteRequest;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestToXContentListener;

public class RestMLDeleteControllerAction
extends MLRestHandler {
    private static final String ML_DELETE_CONTROLLER_ACTION = "ml_delete_controller_action";
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;

    public RestMLDeleteControllerAction(MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    public String getName() {
        return ML_DELETE_CONTROLLER_ACTION;
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.DELETE, String.format(Locale.ROOT, "%s/controllers/{%s}", "/_plugins/_ml", "model_id")));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        if (!this.mlFeatureEnabledSetting.isControllerEnabled().booleanValue()) {
            throw new IllegalStateException("Controller is currently disabled. To enable it, update the setting \"plugins.ml_commons.controller_enabled\" to true.");
        }
        String modelId = request.param("model_id");
        MLControllerDeleteRequest mlControllerDeleteRequest = new MLControllerDeleteRequest(modelId);
        return channel -> client.execute((ActionType)MLControllerDeleteAction.INSTANCE, (ActionRequest)mlControllerDeleteRequest, (ActionListener)new RestToXContentListener(channel));
    }
}

