/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.rest;

import io.lucenia.ml.common.rest.MLRestHandler;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.ml.common.cluster.TenantAwareHelper;
import io.skylite.ml.common.settings.MLFeatureEnabledSetting;
import io.skylite.ml.common.transport.task.MLTaskDeleteAction;
import io.skylite.ml.common.transport.task.MLTaskDeleteRequest;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestToXContentListener;

public class RestMLDeleteTaskAction
extends MLRestHandler {
    private static final String ML_DELETE_TASK_ACTION = "ml_delete_task_action";
    private MLFeatureEnabledSetting mlFeatureEnabledSetting;

    public RestMLDeleteTaskAction(MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    public String getName() {
        return ML_DELETE_TASK_ACTION;
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.DELETE, String.format(Locale.ROOT, "%s/tasks/{%s}", "/_plugins/_ml", "task_id")));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient nodeClient) throws IOException {
        String taskId = restRequest.param("task_id");
        String tenantId = TenantAwareHelper.getTenantID((Boolean)this.mlFeatureEnabledSetting.isMultiTenancyEnabled(), (RestRequest)restRequest);
        MLTaskDeleteRequest mlModelDeleteRequest = new MLTaskDeleteRequest(taskId, tenantId);
        return channel -> nodeClient.execute((ActionType)MLTaskDeleteAction.INSTANCE, (ActionRequest)mlModelDeleteRequest, (ActionListener)new RestToXContentListener(channel));
    }
}

