/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.rest;

import io.lucenia.ml.common.rest.MLRestHandler;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import io.skylite.ml.common.cluster.TenantAwareHelper;
import io.skylite.ml.common.settings.MLFeatureEnabledSetting;
import io.skylite.ml.common.transport.deploy.MLDeployModelAction;
import io.skylite.ml.common.transport.deploy.MLDeployModelRequest;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestToXContentListener;

public class RestMLDeployModelAction
extends MLRestHandler {
    private static final String ML_DEPLOY_MODEL_ACTION = "ml_deploy_model_action";
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;

    public RestMLDeployModelAction(MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    public String getName() {
        return ML_DEPLOY_MODEL_ACTION;
    }

    public List<RestHandler.ReplacedRoute> replacedRoutes() {
        return List.of(new RestHandler.ReplacedRoute(RestRequest.Method.POST, String.format(Locale.ROOT, "%s/models/{%s}/_deploy", "/_plugins/_ml", "model_id"), RestRequest.Method.POST, String.format(Locale.ROOT, "%s/models/{%s}/_load", "/_plugins/_ml", "model_id")));
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        MLDeployModelRequest MLDeployModelRequest2 = this.getRequest(request);
        return channel -> client.execute((ActionType)MLDeployModelAction.INSTANCE, (ActionRequest)MLDeployModelRequest2, (ActionListener)new RestToXContentListener(channel));
    }

    MLDeployModelRequest getRequest(RestRequest request) throws IOException {
        String modelId = request.param("model_id");
        String tenantId = TenantAwareHelper.getTenantID((Boolean)this.mlFeatureEnabledSetting.isMultiTenancyEnabled(), (RestRequest)request);
        if (!request.hasContent()) {
            return new MLDeployModelRequest(modelId, tenantId, false);
        }
        XContentParser parser = request.contentParser();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        return MLDeployModelRequest.parse((XContentParser)parser, (String)modelId, (String)tenantId);
    }
}

