/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.rest;

import io.lucenia.ml.common.input.TransportMLInput;
import io.lucenia.ml.common.rest.MLRestHandler;
import io.lucenia.ml.common.rest.RestActionUtils;
import io.lucenia.ml.common.rest.error.ErrorMessage;
import io.lucenia.ml.common.rest.error.ErrorMessageFactory;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.rest.RestChannel;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.rest.RestResponse;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import io.skylite.ml.common.FunctionName;
import io.skylite.ml.common.cluster.TenantAwareHelper;
import io.skylite.ml.common.input.Input;
import io.skylite.ml.common.input.execute.agent.AgentMLInput;
import io.skylite.ml.common.settings.MLFeatureEnabledSetting;
import io.skylite.ml.common.transport.execute.MLExecuteTaskAction;
import io.skylite.ml.common.transport.execute.MLExecuteTaskRequest;
import io.skylite.ml.common.transport.execute.MLExecuteTaskResponse;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.action.RestToXContentListener;

public class RestMLExecuteAction
extends MLRestHandler {
    private static final Logger log = LogManager.getLogger(RestMLExecuteAction.class);
    private static final String ML_EXECUTE_ACTION = "ml_execute_action";
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;

    public RestMLExecuteAction(MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    public String getName() {
        return ML_EXECUTE_ACTION;
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.POST, String.format(Locale.ROOT, "%s/_execute/{%s}", "/_plugins/_ml", "algorithm")), new RestHandler.Route(RestRequest.Method.POST, String.format(Locale.ROOT, "%s/agents/{%s}/_execute", "/_plugins/_ml", "agent_id")));
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        MLExecuteTaskRequest mlExecuteTaskRequest = this.getRequest(request);
        return channel -> client.execute((ActionType)MLExecuteTaskAction.INSTANCE, (ActionRequest)mlExecuteTaskRequest, (ActionListener)new ActionListener<MLExecuteTaskResponse>(){

            public void onResponse(MLExecuteTaskResponse response) {
                try {
                    RestMLExecuteAction.this.sendResponse(channel, response);
                }
                catch (Exception e) {
                    RestMLExecuteAction.this.reportError(channel, e, RestStatus.INTERNAL_SERVER_ERROR);
                }
            }

            public void onFailure(Exception e) {
                RestStatus status = RestMLExecuteAction.this.isClientError(e) ? RestStatus.BAD_REQUEST : RestStatus.INTERNAL_SERVER_ERROR;
                RestMLExecuteAction.this.reportError(channel, e, status);
            }
        });
    }

    MLExecuteTaskRequest getRequest(RestRequest request) throws IOException {
        XContentParser parser = request.contentParser();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        String uri = request.getHttpRequest().uri();
        FunctionName functionName = null;
        Input input = null;
        if (uri.startsWith("/_plugins/_ml/agents/")) {
            if (!this.mlFeatureEnabledSetting.isAgentFrameworkEnabled()) {
                throw new IllegalStateException("Agent Framework is currently disabled. To enable it, update the setting \"plugins.ml_commons.agent_framework_enabled\" to true.");
            }
            String tenantId = TenantAwareHelper.getTenantID((Boolean)this.mlFeatureEnabledSetting.isMultiTenancyEnabled(), (RestRequest)request);
            String agentId = request.param("agent_id");
            functionName = FunctionName.AGENT;
            input = TransportMLInput.parse(parser, functionName.name());
            ((AgentMLInput)input).setAgentId(agentId);
            ((AgentMLInput)input).setTenantId(tenantId);
        } else {
            String algorithm = RestActionUtils.getAlgorithm(request).toUpperCase(Locale.ROOT);
            functionName = FunctionName.from((String)algorithm);
            input = (Input)parser.namedObject(Input.class, functionName.name(), null);
        }
        return new MLExecuteTaskRequest(functionName, input);
    }

    private void sendResponse(RestChannel channel, MLExecuteTaskResponse response) throws Exception {
        channel.sendResponse(new RestToXContentListener(channel).buildResponse((ToXContentObject)response));
    }

    private void reportError(RestChannel channel, Exception e, RestStatus status) {
        ErrorMessage errorMessage = ErrorMessageFactory.createErrorMessage(e, status.getStatus());
        try {
            XContentBuilder builder = channel.newBuilder();
            builder.startObject();
            builder.field("status", errorMessage.getStatus());
            builder.startObject("error");
            builder.field("type", errorMessage.getType());
            builder.field("reason", errorMessage.getReason());
            builder.field("details", errorMessage.getDetails());
            builder.endObject();
            builder.endObject();
            channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.fromCode((int)errorMessage.getStatus()), builder));
        }
        catch (Exception exception) {
            log.error("Failed to build xContent for an error response, so reply with a plain string.", (Throwable)exception);
            channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.fromCode((int)errorMessage.getStatus()), errorMessage.toString()));
        }
    }

    private boolean isClientError(Exception e) {
        return e instanceof IllegalArgumentException || e instanceof IllegalAccessException;
    }
}

