/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.rest;

import io.lucenia.ml.common.rest.MLRestHandler;
import io.lucenia.ml.common.rest.RestActionUtils;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.ml.common.cluster.TenantAwareHelper;
import io.skylite.ml.common.settings.MLFeatureEnabledSetting;
import io.skylite.ml.common.transport.config.MLConfigGetAction;
import io.skylite.ml.common.transport.config.MLConfigGetRequest;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestToXContentListener;

public class RestMLGetConfigAction
extends MLRestHandler {
    private static final String ML_GET_CONFIG_ACTION = "ml_get_config_action";
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;

    public RestMLGetConfigAction(MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    public String getName() {
        return ML_GET_CONFIG_ACTION;
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, String.format(Locale.ROOT, "%s/config/{%s}", "/_plugins/_ml", "config_id")));
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        MLConfigGetRequest mlConfigGetRequest = this.getRequest(request);
        return channel -> client.execute((ActionType)MLConfigGetAction.INSTANCE, (ActionRequest)mlConfigGetRequest, (ActionListener)new RestToXContentListener(channel));
    }

    MLConfigGetRequest getRequest(RestRequest request) throws IOException {
        String configID = RestActionUtils.getParameterId(request, "config_id");
        String tenantId = TenantAwareHelper.getTenantID((Boolean)this.mlFeatureEnabledSetting.isMultiTenancyEnabled(), (RestRequest)request);
        if (configID.equals("master_key")) {
            throw new IllegalArgumentException("You are not allowed to access this config doc");
        }
        return new MLConfigGetRequest(configID, tenantId);
    }
}

