/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.rest;

import io.lucenia.ml.common.rest.MLRestHandler;
import io.lucenia.ml.common.rest.RestActionUtils;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.ml.common.settings.MLFeatureEnabledSetting;
import io.skylite.ml.common.transport.controller.MLControllerGetAction;
import io.skylite.ml.common.transport.controller.MLControllerGetRequest;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestToXContentListener;

public class RestMLGetControllerAction
extends MLRestHandler {
    private static final String ML_GET_CONTROLLER_ACTION = "ml_get_controller_action";
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;

    public RestMLGetControllerAction(MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    public String getName() {
        return ML_GET_CONTROLLER_ACTION;
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, String.format(Locale.ROOT, "%s/controllers/{%s}", "/_plugins/_ml", "model_id")));
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        MLControllerGetRequest controllerGetRequest = this.getRequest(request);
        return channel -> client.execute((ActionType)MLControllerGetAction.INSTANCE, (ActionRequest)controllerGetRequest, (ActionListener)new RestToXContentListener(channel));
    }

    MLControllerGetRequest getRequest(RestRequest request) throws IOException {
        if (!this.mlFeatureEnabledSetting.isControllerEnabled().booleanValue()) {
            throw new IllegalStateException("Controller is currently disabled. To enable it, update the setting \"plugins.ml_commons.controller_enabled\" to true.");
        }
        String modelId = RestActionUtils.getParameterId(request, "model_id");
        boolean returnContent = RestActionUtils.returnContent(request);
        return new MLControllerGetRequest(modelId, returnContent);
    }
}

