/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.rest;

import io.lucenia.ml.common.rest.MLRestHandler;
import io.lucenia.ml.common.rest.RestActionUtils;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.ml.common.cluster.TenantAwareHelper;
import io.skylite.ml.common.settings.MLFeatureEnabledSetting;
import io.skylite.ml.common.transport.model.MLModelGetAction;
import io.skylite.ml.common.transport.model.MLModelGetRequest;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestToXContentListener;

public class RestMLGetModelAction
extends MLRestHandler {
    private static final String ML_GET_MODEL_ACTION = "ml_get_model_action";
    private MLFeatureEnabledSetting mlFeatureEnabledSetting;

    public RestMLGetModelAction(MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    public String getName() {
        return ML_GET_MODEL_ACTION;
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, String.format(Locale.ROOT, "%s/models/{%s}", "/_plugins/_ml", "model_id")));
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        MLModelGetRequest mlModelGetRequest = this.getRequest(request);
        return channel -> client.execute((ActionType)MLModelGetAction.INSTANCE, (ActionRequest)mlModelGetRequest, (ActionListener)new RestToXContentListener(channel));
    }

    MLModelGetRequest getRequest(RestRequest request) throws IOException {
        String modelId = RestActionUtils.getParameterId(request, "model_id");
        boolean returnContent = RestActionUtils.returnContent(request);
        String tenantId = TenantAwareHelper.getTenantID((Boolean)this.mlFeatureEnabledSetting.isMultiTenancyEnabled(), (RestRequest)request);
        return new MLModelGetRequest(modelId, returnContent, true, tenantId);
    }
}

