/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.rest;

import io.lucenia.ml.common.rest.MLRestHandler;
import io.lucenia.ml.common.rest.RestActionUtils;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.ml.common.cluster.TenantAwareHelper;
import io.skylite.ml.common.settings.MLFeatureEnabledSetting;
import io.skylite.ml.common.transport.model_group.MLModelGroupGetAction;
import io.skylite.ml.common.transport.model_group.MLModelGroupGetRequest;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestToXContentListener;

public class RestMLGetModelGroupAction
extends MLRestHandler {
    private static final String ML_GET_MODEL_GROUP_ACTION = "ml_get_model_group_action";
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;

    public RestMLGetModelGroupAction(MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    public String getName() {
        return ML_GET_MODEL_GROUP_ACTION;
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, String.format(Locale.ROOT, "%s/model_groups/{%s}", "/_plugins/_ml", "model_group_id")));
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        MLModelGroupGetRequest mlModelGroupGetRequest = this.getRequest(request);
        return channel -> client.execute((ActionType)MLModelGroupGetAction.INSTANCE, (ActionRequest)mlModelGroupGetRequest, (ActionListener)new RestToXContentListener(channel));
    }

    MLModelGroupGetRequest getRequest(RestRequest request) throws IOException {
        String modelGroupId = RestActionUtils.getParameterId(request, "model_group_id");
        String tenantId = TenantAwareHelper.getTenantID((Boolean)this.mlFeatureEnabledSetting.isMultiTenancyEnabled(), (RestRequest)request);
        return new MLModelGroupGetRequest(modelGroupId, tenantId);
    }
}

