/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.rest;

import io.lucenia.ml.common.rest.MLRestHandler;
import io.lucenia.ml.common.rest.RestActionUtils;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.ml.common.cluster.TenantAwareHelper;
import io.skylite.ml.common.settings.MLFeatureEnabledSetting;
import io.skylite.ml.common.transport.task.MLTaskGetAction;
import io.skylite.ml.common.transport.task.MLTaskGetRequest;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestToXContentListener;

public class RestMLGetTaskAction
extends MLRestHandler {
    private static final String ML_GET_TASK_ACTION = "ml_get_task_action";
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;

    public RestMLGetTaskAction(MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    public String getName() {
        return ML_GET_TASK_ACTION;
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, String.format(Locale.ROOT, "%s/tasks/{%s}", "/_plugins/_ml", "task_id")));
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String tenantId = TenantAwareHelper.getTenantID((Boolean)this.mlFeatureEnabledSetting.isMultiTenancyEnabled(), (RestRequest)request);
        MLTaskGetRequest mlTaskGetRequest = this.getRequest(request, tenantId);
        return channel -> client.execute((ActionType)MLTaskGetAction.INSTANCE, (ActionRequest)mlTaskGetRequest, (ActionListener)new RestToXContentListener(channel));
    }

    MLTaskGetRequest getRequest(RestRequest request, String tenantId) throws IOException {
        String taskId = RestActionUtils.getParameterId(request, "task_id");
        return new MLTaskGetRequest(taskId, tenantId);
    }
}

