/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.rest;

import io.lucenia.ml.common.input.TransportMLInput;
import io.lucenia.ml.common.model.MLModelManager;
import io.lucenia.ml.common.rest.MLRestHandler;
import io.lucenia.ml.common.rest.RestActionUtils;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.rest.RestResponse;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import io.skylite.ml.common.FunctionName;
import io.skylite.ml.common.cluster.TenantAwareHelper;
import io.skylite.ml.common.connector.ConnectorAction;
import io.skylite.ml.common.input.MLInput;
import io.skylite.ml.common.model.MLModel;
import io.skylite.ml.common.settings.MLFeatureEnabledSetting;
import io.skylite.ml.common.transport.prediction.MLPredictionTaskAction;
import io.skylite.ml.common.transport.prediction.MLPredictionTaskRequest;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.action.RestToXContentListener;

public class RestMLPredictionAction
extends MLRestHandler {
    private static final Logger log = LogManager.getLogger(RestMLPredictionAction.class);
    private static final String ML_PREDICTION_ACTION = "ml_prediction_action";
    private final MLModelManager modelManager;
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;

    public RestMLPredictionAction(MLModelManager modelManager, MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        this.modelManager = modelManager;
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    public String getName() {
        return ML_PREDICTION_ACTION;
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.POST, String.format(Locale.ROOT, "%s/_predict/{%s}/{%s}", "/_plugins/_ml", "algorithm", "model_id")), new RestHandler.Route(RestRequest.Method.POST, String.format(Locale.ROOT, "%s/models/{%s}/_predict", "/_plugins/_ml", "model_id")), new RestHandler.Route(RestRequest.Method.POST, String.format(Locale.ROOT, "%s/models/{%s}/_batch_predict", "/_plugins/_ml", "model_id")));
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String algorithm = request.param("algorithm");
        String modelId = RestActionUtils.getParameterId(request, "model_id");
        Optional<FunctionName> functionName = this.modelManager.getOptionalModelFunctionName(modelId);
        if (algorithm == null && functionName.isPresent()) {
            algorithm = functionName.get().name();
        }
        if (algorithm != null) {
            MLPredictionTaskRequest mlPredictionTaskRequest = this.getRequest(modelId, algorithm, request);
            return channel -> client.execute((ActionType)MLPredictionTaskAction.INSTANCE, (ActionRequest)mlPredictionTaskRequest, (ActionListener)new RestToXContentListener(channel));
        }
        return channel -> {
            ActionListener listener = ActionListenerHelper.wrap(mlModel -> {
                String algoName = mlModel.getAlgorithm().name();
                client.execute((ActionType)MLPredictionTaskAction.INSTANCE, (ActionRequest)this.getRequest(modelId, algoName, request), (ActionListener)new RestToXContentListener(channel));
            }, e -> {
                log.error("Failed to get ML model", (Throwable)e);
                try {
                    channel.sendResponse((RestResponse)new BytesRestResponse(channel, RestStatus.NOT_FOUND, e));
                }
                catch (IOException ex) {
                    log.error("Failed to send error response", (Throwable)ex);
                }
            });
            try (ThreadContext.StoredContext context = client.threadPool().getThreadContext().stashContext();){
                this.modelManager.getModel(modelId, TenantAwareHelper.getTenantID((Boolean)this.mlFeatureEnabledSetting.isMultiTenancyEnabled(), (RestRequest)request), (ActionListener<MLModel>)ActionListenerHelper.runBefore((ActionListener)listener, () -> ((ThreadContext.StoredContext)context).restore()));
            }
        };
    }

    MLPredictionTaskRequest getRequest(String modelId, String algorithm, RestRequest request) throws IOException {
        String tenantId = TenantAwareHelper.getTenantID((Boolean)this.mlFeatureEnabledSetting.isMultiTenancyEnabled(), (RestRequest)request);
        ConnectorAction.ActionType actionType = ConnectorAction.ActionType.from((String)RestActionUtils.getActionTypeFromRestRequest(request));
        if (FunctionName.REMOTE.name().equals(algorithm) && !this.mlFeatureEnabledSetting.isRemoteInferenceEnabled()) {
            throw new IllegalStateException("Remote Inference is currently disabled. To enable it, update the setting \"plugins.ml_commons.remote_inference_enabled\" to true.");
        }
        if (FunctionName.isDLModel((FunctionName)FunctionName.from((String)algorithm.toUpperCase(Locale.ROOT))) && !this.mlFeatureEnabledSetting.isLocalModelEnabled()) {
            throw new IllegalStateException("Local Model is currently disabled. To enable it, update the setting \"plugins.ml_commons.local_model.enabled\" to true.");
        }
        if (ConnectorAction.ActionType.BATCH_PREDICT == actionType && !this.mlFeatureEnabledSetting.isOfflineBatchInferenceEnabled().booleanValue()) {
            throw new IllegalStateException("Offline Batch Inference is currently disabled. To enable it, update the setting \"plugins.ml_commons.offline_batch_inference_enabled\" to true.");
        }
        if (!ConnectorAction.ActionType.isValidActionInModelPrediction((ConnectorAction.ActionType)actionType)) {
            throw new IllegalArgumentException("Wrong action type in the rest request path!");
        }
        XContentParser parser = request.contentParser();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        MLInput mlInput = TransportMLInput.parse(parser, algorithm, actionType);
        return new MLPredictionTaskRequest(modelId, mlInput, null, tenantId);
    }
}

