/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.rest;

import io.lucenia.ml.common.rest.MLRestHandler;
import io.skylite.SkyliteParseException;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import io.skylite.ml.common.cluster.TenantAwareHelper;
import io.skylite.ml.common.settings.MLFeatureEnabledSetting;
import io.skylite.ml.common.transport.model_group.MLRegisterModelGroupAction;
import io.skylite.ml.common.transport.model_group.MLRegisterModelGroupInput;
import io.skylite.ml.common.transport.model_group.MLRegisterModelGroupRequest;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestToXContentListener;

public class RestMLRegisterModelGroupAction
extends MLRestHandler {
    private static final String ML_REGISTER_MODEL_GROUP_ACTION = "ml_register_model_group_action";
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;

    public RestMLRegisterModelGroupAction(MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    public String getName() {
        return ML_REGISTER_MODEL_GROUP_ACTION;
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.POST, String.format(Locale.ROOT, "%s/model_groups/_register", "/_plugins/_ml")));
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        MLRegisterModelGroupRequest createModelGroupRequest = this.getRequest(request);
        return channel -> client.execute((ActionType)MLRegisterModelGroupAction.INSTANCE, (ActionRequest)createModelGroupRequest, (ActionListener)new RestToXContentListener(channel));
    }

    MLRegisterModelGroupRequest getRequest(RestRequest request) throws IOException {
        boolean hasContent = request.hasContent();
        String tenantId = TenantAwareHelper.getTenantID((Boolean)this.mlFeatureEnabledSetting.isMultiTenancyEnabled(), (RestRequest)request);
        if (!hasContent) {
            throw new SkyliteParseException("Model group request has empty body", new Object[0]);
        }
        XContentParser parser = request.contentParser();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        MLRegisterModelGroupInput input = MLRegisterModelGroupInput.parse((XContentParser)parser);
        input.setTenantId(tenantId);
        return new MLRegisterModelGroupRequest(input);
    }
}

