/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.rest;

import io.lucenia.ml.common.action.memory.conversation.SearchInteractionsAction;
import io.lucenia.ml.common.action.memory.conversation.SearchInteractionsRequest;
import io.lucenia.ml.common.rest.MLRestHandler;
import io.lucenia.ml.common.rest.RestActionUtils;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.search.SearchResponse;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.rest.RestChannel;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.rest.RestResponse;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.search.SearchRequest;
import io.skylite.core.search.builder.SearchSourceBuilder;
import io.skylite.core.xcontent.ToXContent;
import java.io.IOException;
import java.util.List;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.action.RestResponseListener;

public class RestMemorySearchInteractionsAction
extends MLRestHandler {
    private static final String SEARCH_INTERACTIONS_NAME = "conversation_memory_search_interactions";

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.POST, "/_plugins/_ml/memory/{memory_id}/_search"), new RestHandler.Route(RestRequest.Method.GET, "/_plugins/_ml/memory/{memory_id}/_search"));
    }

    public String getName() {
        return SEARCH_INTERACTIONS_NAME;
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String conversationId = request.param("memory_id");
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.parseXContent(request.contentOrSourceParamParser());
        searchSourceBuilder.fetchSource(RestActionUtils.getSourceContext(request, searchSourceBuilder));
        searchSourceBuilder.seqNoAndPrimaryTerm(Boolean.valueOf(true)).version(Boolean.valueOf(true));
        SearchRequest searchRequest = new SearchRequest().source(searchSourceBuilder);
        SearchInteractionsRequest siRequest = new SearchInteractionsRequest(conversationId, searchRequest);
        return channel -> client.execute((ActionType)SearchInteractionsAction.INSTANCE, (ActionRequest)siRequest, this.search((RestChannel)channel));
    }

    protected RestResponseListener<SearchResponse> search(RestChannel channel) {
        return new RestResponseListener<SearchResponse>(this, channel){

            public RestResponse buildResponse(SearchResponse response) throws Exception {
                if (response.isTimedOut()) {
                    return new BytesRestResponse(RestStatus.REQUEST_TIMEOUT, response.toString());
                }
                return new BytesRestResponse(RestStatus.OK, response.toXContent(this.channel.newBuilder(), ToXContent.EMPTY_PARAMS));
            }
        };
    }
}

