/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.rest.error;

import io.skylite.core.common.Strings;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.transport.ActionTransportException;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;

public class ErrorMessage {
    protected Throwable exception;
    private final int status;
    private final String type;
    private final String reason;
    private final String details;

    public ErrorMessage(Throwable exception, int status) {
        this.exception = exception;
        this.status = status;
        this.type = this.fetchType();
        this.reason = this.fetchReason();
        this.details = this.fetchDetails();
    }

    private String fetchType() {
        return this.exception == null ? "Unknown Exception" : this.exception.getClass().getSimpleName();
    }

    protected String fetchReason() {
        return this.status == RestStatus.BAD_REQUEST.getStatus() ? "Invalid Request" : "System Error";
    }

    protected String fetchDetails() {
        if (this.exception == null) {
            return "No Exception Details";
        }
        String msg = this.hasInternalInformation(this.exception) != false ? this.decorateMessage(this.exception) : this.exception.getLocalizedMessage();
        return this.emptyStringIfNull(msg);
    }

    private String emptyStringIfNull(String str) {
        return str != null ? str : "";
    }

    private Boolean hasInternalInformation(Throwable t) {
        if (t instanceof ActionTransportException) {
            return true;
        }
        return false;
    }

    private String decorateMessage(Throwable t) {
        if (t instanceof ActionTransportException) {
            String regexIPv4 = "\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}(:\\d{1,5})?";
            String regexIPv6 = "\\[?((?:[\\da-fA-F]{0,4}:[\\da-fA-F]{0,4}){2,7})(?:[\\/\\\\%](\\d{1,3}))?\\]?(:\\d{1,5})?";
            return this.emptyStringIfNull(t.getLocalizedMessage()).replaceAll(regexIPv4, "x.x.x.x:x").replaceAll(regexIPv6, "x.x.x.x.x.x:x");
        }
        return "";
    }

    public String toString() {
        String err;
        HashMap<String, String> errorContent = new HashMap<String, String>();
        errorContent.put("type", this.type);
        errorContent.put("reason", this.reason);
        errorContent.put("details", this.details);
        HashMap<String, Serializable> errMessage = new HashMap<String, Serializable>();
        errMessage.put("status", Integer.valueOf(this.status));
        errMessage.put("error", errorContent);
        try {
            err = Strings.OBJECT_MAPPER.writeValueAsString(errMessage);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return err;
    }

    public int getStatus() {
        return this.status;
    }

    public String getType() {
        return this.type;
    }

    public String getReason() {
        return this.reason;
    }

    public String getDetails() {
        return this.details;
    }
}

