/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.search.pipelines.generative;

import io.skylite.common.processor.AbstractProcessor;
import io.skylite.core.ingest.ConfigurationUtils;
import io.skylite.core.search.SearchRequest;
import io.skylite.core.search.pipeline.SearchProcessor;
import io.skylite.core.search.pipeline.SearchRequestProcessor;
import io.skylite.ml.common.exception.MLException;
import io.skylite.ml.common.search.pipelines.generative.GenerativeQAProcessorConstants;
import java.util.Map;
import java.util.function.BooleanSupplier;

public class GenerativeQARequestProcessor
extends AbstractProcessor
implements SearchRequestProcessor {
    private String modelId;
    private final BooleanSupplier featureFlagSupplier;

    protected GenerativeQARequestProcessor(String tag, String description, String modelId, BooleanSupplier supplier) {
        super(tag, description);
        this.modelId = modelId;
        this.featureFlagSupplier = supplier;
    }

    public SearchRequest processRequest(SearchRequest request) throws Exception {
        if (!this.featureFlagSupplier.getAsBoolean()) {
            throw new MLException(GenerativeQAProcessorConstants.FEATURE_NOT_ENABLED_ERROR_MSG);
        }
        return request;
    }

    public String getType() {
        return "question_rewrite";
    }

    public static final class Factory
    implements SearchProcessor.Factory<GenerativeQARequestProcessor> {
        private final BooleanSupplier featureFlagSupplier;

        public Factory(BooleanSupplier supplier) {
            this.featureFlagSupplier = supplier;
        }

        public GenerativeQARequestProcessor create(Map<String, SearchProcessor.Factory<GenerativeQARequestProcessor>> processorFactories, String tag, String description, boolean ignoreFailure, Map<String, Object> config, SearchProcessor.PipelineContext pipelineContext) throws Exception {
            if (this.featureFlagSupplier.getAsBoolean()) {
                return new GenerativeQARequestProcessor(tag, description, ConfigurationUtils.readStringProperty((String)"question_rewrite", (String)tag, config, (String)"model_id"), this.featureFlagSupplier);
            }
            throw new MLException(GenerativeQAProcessorConstants.FEATURE_NOT_ENABLED_ERROR_MSG);
        }
    }
}

