/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.search.pipelines.generative.client;

import io.lucenia.ml.common.action.memory.conversation.CreateConversationAction;
import io.lucenia.ml.common.action.memory.conversation.CreateConversationRequest;
import io.lucenia.ml.common.action.memory.conversation.CreateConversationResponse;
import io.lucenia.ml.common.action.memory.conversation.CreateInteractionAction;
import io.lucenia.ml.common.action.memory.conversation.CreateInteractionRequest;
import io.lucenia.ml.common.action.memory.conversation.CreateInteractionResponse;
import io.lucenia.ml.common.action.memory.conversation.GetInteractionsAction;
import io.lucenia.ml.common.action.memory.conversation.GetInteractionsRequest;
import io.lucenia.ml.common.action.memory.conversation.GetInteractionsResponse;
import io.lucenia.ml.common.engine.memory.ConversationIndexMemory;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.core.client.Client;
import io.skylite.core.common.util.CollectionUtils;
import io.skylite.ml.common.conversation.Interaction;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConversationalMemoryClient {
    private static final Logger log = LogManager.getLogger(ConversationIndexMemory.class);
    private static final Logger logger = LogManager.getLogger();
    private static final long DEFAULT_TIMEOUT_IN_MILLIS = 10000L;
    private Client client;

    public ConversationalMemoryClient(Client client) {
        this.client = client;
    }

    public String createConversation(String name) {
        CreateConversationResponse response = (CreateConversationResponse)((Object)this.client.execute((ActionType)CreateConversationAction.INSTANCE, (ActionRequest)new CreateConversationRequest(name)).actionGet(10000L));
        log.info("createConversation: id: {}", (Object)response.getId());
        return response.getId();
    }

    public String createInteraction(String conversationId, String input, String promptTemplate, String response, String origin, Map<String, String> additionalInfo) {
        CreateInteractionResponse res = (CreateInteractionResponse)((Object)this.client.execute((ActionType)CreateInteractionAction.INSTANCE, (ActionRequest)new CreateInteractionRequest(Objects.requireNonNull(conversationId), Objects.requireNonNull(input), promptTemplate, Objects.requireNonNull(response), origin, additionalInfo)).actionGet(10000L));
        log.info("createInteraction: interactionId: {}", (Object)res.getId());
        return res.getId();
    }

    public void createInteraction(String conversationId, String input, String promptTemplate, String response, String origin, Map<String, String> additionalInfo, final ActionListener<String> listener) {
        this.client.execute((ActionType)CreateInteractionAction.INSTANCE, (ActionRequest)new CreateInteractionRequest(conversationId, input, promptTemplate, response, origin, additionalInfo), (ActionListener)new ActionListener<CreateInteractionResponse>(){

            public void onResponse(CreateInteractionResponse createInteractionResponse) {
                listener.onResponse((Object)createInteractionResponse.getId());
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        });
    }

    public List<Interaction> getInteractions(String conversationId, int lastN) {
        if (lastN <= 0) {
            throw new IllegalArgumentException("lastN must be at least 1.");
        }
        log.info("In getInteractions, conversationId {}, lastN {}", (Object)conversationId, (Object)lastN);
        ArrayList<Interaction> interactions = new ArrayList<Interaction>();
        int from = 0;
        boolean allInteractionsFetched = false;
        int maxResults = lastN;
        do {
            GetInteractionsResponse response;
            List<Interaction> list;
            if ((list = (response = (GetInteractionsResponse)((Object)this.client.execute((ActionType)GetInteractionsAction.INSTANCE, (ActionRequest)new GetInteractionsRequest(conversationId, maxResults, from)).actionGet(10000L))).getInteractions()) != null && !CollectionUtils.isEmpty(list)) {
                interactions.addAll(list);
                from += list.size();
                maxResults -= list.size();
            } else if (response.hasMorePages()) break;
            boolean bl = allInteractionsFetched = !response.hasMorePages();
        } while (from < lastN && !allInteractionsFetched);
        return interactions;
    }

    public void getInteractions(String conversationId, int lastN, final ActionListener<List<Interaction>> listener) {
        this.client.execute((ActionType)GetInteractionsAction.INSTANCE, (ActionRequest)new GetInteractionsRequest(conversationId, lastN, 0), (ActionListener)new ActionListener<GetInteractionsResponse>(){

            public void onResponse(GetInteractionsResponse getInteractionsResponse) {
                listener.onResponse(getInteractionsResponse.getInteractions());
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        });
    }
}

