/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.task;

import io.lucenia.ml.common.engine.indices.MLInputDatasetHandler;
import io.lucenia.ml.common.model.MLModelManager;
import io.lucenia.ml.common.permission.AccessController;
import io.lucenia.ml.common.task.MLTaskDispatcher;
import io.lucenia.ml.common.task.MLTaskManager;
import io.lucenia.ml.common.task.MLTaskRunner;
import io.skylite.ResourceNotFoundException;
import io.skylite.SkyliteException;
import io.skylite.SkyliteStatusException;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.ActionListenerResponseHandler;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.get.GetRequest;
import io.skylite.core.action.get.GetResponse;
import io.skylite.core.action.index.IndexResponse;
import io.skylite.core.action.support.ThreadedActionListener;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.Strings;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.security.auth.User;
import io.skylite.core.settings.Settings;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportRequest;
import io.skylite.core.transport.TransportResponseHandler;
import io.skylite.core.transport.TransportService;
import io.skylite.core.xcontent.DeprecationHandler;
import io.skylite.core.xcontent.LoggingDeprecationHandler;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import io.skylite.ml.common.FunctionName;
import io.skylite.ml.common.breaker.MLCircuitBreakerService;
import io.skylite.ml.common.cluster.DiscoveryNodeHelper;
import io.skylite.ml.common.cluster.MLNodeUtils;
import io.skylite.ml.common.connector.ConnectorAction;
import io.skylite.ml.common.dataset.MLInputDataType;
import io.skylite.ml.common.dataset.MLInputDataset;
import io.skylite.ml.common.dataset.remote.RemoteInferenceInputDataSet;
import io.skylite.ml.common.engine.MLEngine;
import io.skylite.ml.common.engine.Predictable;
import io.skylite.ml.common.exception.MLExceptionUtils;
import io.skylite.ml.common.input.Input;
import io.skylite.ml.common.input.MLInput;
import io.skylite.ml.common.model.MLModel;
import io.skylite.ml.common.output.MLOutput;
import io.skylite.ml.common.output.MLPredictionOutput;
import io.skylite.ml.common.output.model.ModelTensor;
import io.skylite.ml.common.output.model.ModelTensorOutput;
import io.skylite.ml.common.output.model.ModelTensors;
import io.skylite.ml.common.settings.MLCommonsSettings;
import io.skylite.ml.common.stats.ActionName;
import io.skylite.ml.common.stats.MLActionLevelStat;
import io.skylite.ml.common.stats.MLNodeLevelStat;
import io.skylite.ml.common.stats.MLStats;
import io.skylite.ml.common.task.MLTask;
import io.skylite.ml.common.task.MLTaskState;
import io.skylite.ml.common.task.MLTaskType;
import io.skylite.ml.common.transport.MLTaskResponse;
import io.skylite.ml.common.transport.deploy.MLDeployModelAction;
import io.skylite.ml.common.transport.deploy.MLDeployModelRequest;
import io.skylite.ml.common.transport.prediction.MLPredictionTaskRequest;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MLPredictTaskRunner
extends MLTaskRunner<MLPredictionTaskRequest, MLTaskResponse> {
    private static final Logger log = LogManager.getLogger(MLPredictTaskRunner.class);
    private final ThreadPool threadPool;
    private final ClusterService clusterService;
    private final Client client;
    private final MLInputDatasetHandler mlInputDatasetHandler;
    private final NamedXContentRegistry xContentRegistry;
    private final MLModelManager mlModelManager;
    private final DiscoveryNodeHelper nodeHelper;
    private final MLEngine mlEngine;
    private volatile boolean autoDeploymentEnabled;
    public static final String BUCKET_FIELD = "bucket";
    public static final String REGION_FIELD = "region";

    public MLPredictTaskRunner(ThreadPool threadPool, ClusterService clusterService, Client client, MLTaskManager mlTaskManager, MLStats mlStats, MLInputDatasetHandler mlInputDatasetHandler, MLTaskDispatcher mlTaskDispatcher, MLCircuitBreakerService mlCircuitBreakerService, NamedXContentRegistry xContentRegistry, MLModelManager mlModelManager, DiscoveryNodeHelper nodeHelper, MLEngine mlEngine, Settings settings) {
        super(mlTaskManager, mlStats, nodeHelper, mlTaskDispatcher, mlCircuitBreakerService, clusterService);
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.client = client;
        this.mlInputDatasetHandler = mlInputDatasetHandler;
        this.xContentRegistry = xContentRegistry;
        this.mlModelManager = mlModelManager;
        this.nodeHelper = nodeHelper;
        this.mlEngine = mlEngine;
        this.autoDeploymentEnabled = (Boolean)MLCommonsSettings.ML_COMMONS_MODEL_AUTO_DEPLOY_ENABLE.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MLCommonsSettings.ML_COMMONS_MODEL_AUTO_DEPLOY_ENABLE, it -> {
            this.autoDeploymentEnabled = it;
        });
    }

    @Override
    protected String getTransportActionName() {
        return "cluster:admin/lucenia/ml/predict";
    }

    @Override
    protected TransportResponseHandler<MLTaskResponse> getResponseHandler(ActionListener<MLTaskResponse> listener) {
        return new ActionListenerResponseHandler(listener, MLTaskResponse::new);
    }

    @Override
    public void dispatchTask(FunctionName functionName, MLPredictionTaskRequest request, TransportService transportService, ActionListener<MLTaskResponse> listener) {
        RemoteInferenceInputDataSet inputDataset;
        Map dlq;
        String modelId = request.getModelId();
        if (request.getMlInput().getInputDataset() instanceof RemoteInferenceInputDataSet && (dlq = (inputDataset = (RemoteInferenceInputDataSet)request.getMlInput().getInputDataset()).getDlq()) != null) {
            String bucketName = (String)dlq.get(BUCKET_FIELD);
            String region = (String)dlq.get(REGION_FIELD);
            if (bucketName == null || region == null) {
                throw new IllegalArgumentException("DLQ bucketName or region cannot be null");
            }
        }
        try {
            ActionListener actionListener = ActionListenerHelper.wrap(node -> {
                if (this.clusterService.localNode().getId().equals(node.getId())) {
                    log.debug("Execute ML predict request {} locally on node {}", (Object)request.getRequestID(), (Object)node.getId());
                    request.setDispatchTask(false);
                    this.checkCBAndExecute(functionName, request, listener);
                } else {
                    log.debug("Execute ML predict request {} remotely on node {}", (Object)request.getRequestID(), (Object)node.getId());
                    request.setDispatchTask(false);
                    transportService.sendRequest(node, this.getTransportActionName(), (TransportRequest)request, this.getResponseHandler(listener));
                }
            }, arg_0 -> listener.onFailure(arg_0));
            String[] workerNodes = this.mlModelManager.getWorkerNodes(modelId, functionName, true);
            if (workerNodes == null || workerNodes.length == 0) {
                if (FunctionName.isAutoDeployEnabled((boolean)this.autoDeploymentEnabled, (FunctionName)functionName)) {
                    try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
                        this.mlModelManager.getModel(modelId, request.getTenantId(), (ActionListener<MLModel>)ActionListenerHelper.runBefore((ActionListener)ActionListenerHelper.wrap(model -> {
                            MLModel modelBeingAutoDeployed;
                            Boolean isHidden = model.getIsHidden();
                            if (!this.checkModelAutoDeployEnabled((MLModel)model)) {
                                String errorMsg = Strings.getErrorMessage((String)"Auto deployment disabled for this model, please deploy model first", (String)modelId, (boolean)isHidden);
                                log.info(errorMsg);
                                listener.onFailure((Exception)new IllegalArgumentException(errorMsg));
                                return;
                            }
                            String[] planningWorkerNodes = model.getPlanningWorkerNodes();
                            boolean deployToAllNodes = model.isDeployToAllNodes();
                            if (deployToAllNodes) {
                                planningWorkerNodes = null;
                            }
                            if ((modelBeingAutoDeployed = this.mlModelManager.addModelToAutoDeployCache(modelId, (MLModel)model)) == model) {
                                log.info(Strings.getErrorMessage((String)"Automatically deploy model", (String)modelId, (boolean)isHidden));
                                MLDeployModelRequest deployModelRequest = new MLDeployModelRequest(modelId, request.getTenantId(), planningWorkerNodes, false, true, false);
                                this.client.execute((ActionType)MLDeployModelAction.INSTANCE, (ActionRequest)deployModelRequest, ActionListenerHelper.wrap(r -> log.info(Strings.getErrorMessage((String)"Auto deployment action triggered for the model", (String)modelId, (boolean)isHidden)), e -> log.info(Strings.getErrorMessage((String)"Auto deployment action failed for the given model {}", (String)modelId, (boolean)isHidden), (Throwable)e)));
                            }
                            if (planningWorkerNodes == null || planningWorkerNodes.length == 0) {
                                planningWorkerNodes = this.nodeHelper.getEligibleNodeIds(functionName);
                            }
                            this.mlTaskDispatcher.dispatchPredictTask(planningWorkerNodes, (ActionListener<DiscoveryNode>)actionListener);
                        }, e -> {
                            log.error("Failed to get model " + modelId, (Throwable)e);
                            listener.onFailure(e);
                        }), () -> ((ThreadContext.StoredContext)context).restore()));
                    }
                    return;
                }
                if (FunctionName.needDeployFirst((FunctionName)functionName)) {
                    listener.onFailure((Exception)new IllegalArgumentException("Model not ready yet. Please deploy the model first."));
                    return;
                }
                workerNodes = this.nodeHelper.getEligibleNodeIds(functionName);
            } else {
                this.mlModelManager.removeAutoDeployModel(modelId);
            }
            this.mlTaskDispatcher.dispatchPredictTask(workerNodes, (ActionListener<DiscoveryNode>)actionListener);
        }
        catch (Exception e2) {
            log.error("Failed to predict model " + modelId, (Throwable)e2);
            listener.onFailure(e2);
        }
    }

    @Override
    protected void executeTask(MLPredictionTaskRequest request, ActionListener<MLTaskResponse> listener) {
        String tenantId = request.getTenantId();
        MLInputDataType inputDataType = request.getMlInput().getInputDataset().getInputDataType();
        Instant now = Instant.now();
        String modelId = request.getModelId();
        FunctionName functionName = request.getMlInput().getFunctionName();
        MLInput mlInput = request.getMlInput();
        ConnectorAction.ActionType actionType = null;
        if (mlInput.getInputDataset() instanceof RemoteInferenceInputDataSet) {
            actionType = ((RemoteInferenceInputDataSet)mlInput.getInputDataset()).getActionType();
        }
        actionType = actionType == null ? ConnectorAction.ActionType.PREDICT : actionType;
        MLTask mlTask = MLTask.builder().taskId(UUID.randomUUID().toString()).modelId(modelId).taskType(actionType.equals((Object)ConnectorAction.ActionType.BATCH_PREDICT) ? MLTaskType.BATCH_PREDICTION : MLTaskType.PREDICTION).inputType(inputDataType).functionName(functionName).state(MLTaskState.CREATED).workerNodes(List.of(this.clusterService.localNode().getId())).createTime(now).lastUpdateTime(now).async(false).tenantId(tenantId).build();
        if (actionType.equals((Object)ConnectorAction.ActionType.BATCH_PREDICT)) {
            this.mlModelManager.checkMaxBatchJobTask(mlTask, (ActionListener<Boolean>)ActionListenerHelper.wrap(exceedLimits -> {
                if (exceedLimits.booleanValue()) {
                    String error = "Exceeded maximum limit for BATCH_PREDICTION tasks. To increase the limit, update the plugins.ml_commons.max_batch_inference_tasks setting.";
                    log.warn(error + " in task " + mlTask.getTaskId());
                    listener.onFailure((Exception)new SkyliteStatusException(error, RestStatus.TOO_MANY_REQUESTS, new Object[0]));
                } else {
                    this.executePredictionByInputDataType(inputDataType, modelId, mlInput, mlTask, functionName, tenantId, listener);
                }
            }, exception -> {
                log.error("Failed to check the maximum BATCH_PREDICTION Task limits", (Throwable)exception);
                listener.onFailure(exception);
            }));
            return;
        }
        this.executePredictionByInputDataType(inputDataType, modelId, mlInput, mlTask, functionName, tenantId, listener);
    }

    private void executePredictionByInputDataType(MLInputDataType inputDataType, String modelId, MLInput mlInput, MLTask mlTask, FunctionName functionName, String tenantId, ActionListener<MLTaskResponse> listener) {
        switch (inputDataType) {
            case SEARCH_QUERY: {
                ActionListener dataFrameActionListener = ActionListenerHelper.wrap(dataSet -> {
                    MLInput newInput = mlInput.toBuilder().inputDataset(dataSet).build();
                    this.predict(modelId, tenantId, mlTask, newInput, listener);
                }, e -> {
                    log.error("Failed to generate DataFrame from search query", (Throwable)e);
                    this.handleAsyncMLTaskFailure(mlTask, (Exception)e);
                    listener.onFailure(e);
                });
                this.mlInputDatasetHandler.parseSearchQueryInput(mlInput.getInputDataset(), (ActionListener<MLInputDataset>)this.threadedActionListener(functionName, dataFrameActionListener));
                break;
            }
            default: {
                String threadPoolName = this.getPredictThreadPool(functionName);
                this.threadPool.executor(threadPoolName).execute(() -> this.predict(modelId, tenantId, mlTask, mlInput, listener));
            }
        }
    }

    private boolean checkModelAutoDeployEnabled(MLModel mlModel) {
        if (mlModel.getDeploySetting() == null || !mlModel.getDeploySetting().getIsAutoDeployEnabled()) {
            return true;
        }
        return mlModel.getDeploySetting().getIsAutoDeployEnabled();
    }

    private String getPredictThreadPool(FunctionName functionName) {
        return functionName == FunctionName.REMOTE ? "lucenia_ml_predict_remote" : "lucenia_ml_predict";
    }

    private void predict(String modelId, String tenantId, MLTask mlTask, MLInput mlInput, ActionListener<MLTaskResponse> listener) {
        boolean modelReady;
        ActionListener<MLTaskResponse> internalListener = this.wrappedCleanupListener(listener, mlTask.getTaskId());
        ActionName actionName = this.getActionNameFromInput(mlInput);
        this.mlStats.getStat((Enum)MLNodeLevelStat.ML_EXECUTING_TASK_COUNT).increment();
        this.mlStats.getStat((Enum)MLNodeLevelStat.ML_REQUEST_COUNT).increment();
        this.mlStats.createCounterStatIfAbsent(mlTask.getFunctionName(), actionName, MLActionLevelStat.ML_ACTION_REQUEST_COUNT).increment();
        if (modelId != null) {
            this.mlStats.createModelCounterStatIfAbsent(modelId, actionName, MLActionLevelStat.ML_ACTION_REQUEST_COUNT).increment();
        }
        mlTask.setState(MLTaskState.RUNNING);
        this.mlTaskManager.add(mlTask);
        FunctionName functionName = mlInput.getFunctionName();
        Predictable predictor = this.mlModelManager.getPredictor(modelId);
        boolean bl = modelReady = predictor != null && predictor.isModelReady();
        if (!modelReady && FunctionName.isAutoDeployEnabled((boolean)this.autoDeploymentEnabled, (FunctionName)functionName)) {
            log.info("Auto deploy model {} to local node", (Object)modelId);
            Instant now = Instant.now();
            MLTask mlDeployTask = MLTask.builder().taskId(UUID.randomUUID().toString()).functionName(functionName).async(false).taskType(MLTaskType.DEPLOY_MODEL).createTime(now).lastUpdateTime(now).state(MLTaskState.RUNNING).workerNodes(Arrays.asList(this.clusterService.localNode().getId())).tenantId(tenantId).build();
            this.mlModelManager.deployModel(modelId, tenantId, null, functionName, false, true, mlDeployTask, (ActionListener<String>)ActionListenerHelper.wrap(s -> this.runPredict(modelId, tenantId, mlTask, mlInput, functionName, actionName, internalListener), e -> {
                log.error("Failed to auto deploy model {}", (Object)modelId);
                internalListener.onFailure(e);
            }));
            return;
        }
        this.runPredict(modelId, tenantId, mlTask, mlInput, functionName, actionName, internalListener);
    }

    private void runPredict(String modelId, String tenantId, MLTask mlTask, MLInput mlInput, FunctionName algorithm, ActionName actionName, ActionListener<MLTaskResponse> internalListener) {
        if (modelId != null) {
            Predictable predictor = this.mlModelManager.getPredictor(modelId);
            if (predictor != null) {
                try {
                    if (!predictor.isModelReady()) {
                        throw new IllegalArgumentException("Model not ready: " + modelId);
                    }
                    if (mlInput.getAlgorithm() == FunctionName.REMOTE) {
                        long startTime = System.nanoTime();
                        ActionListener trackPredictDurationListener = ActionListenerHelper.wrap(output -> {
                            if (output.getOutput() instanceof ModelTensorOutput) {
                                this.validateOutputSchema(modelId, (ModelTensorOutput)output.getOutput());
                            }
                            if (mlTask.getTaskType().equals((Object)MLTaskType.BATCH_PREDICTION)) {
                                HashMap<String, Map> remoteJob = new HashMap<String, Map>();
                                ModelTensorOutput tensorOutput = (ModelTensorOutput)output.getOutput();
                                if (tensorOutput != null && tensorOutput.getMlModelOutputs() != null && !tensorOutput.getMlModelOutputs().isEmpty()) {
                                    ModelTensors modelOutput = (ModelTensors)tensorOutput.getMlModelOutputs().get(0);
                                    Integer statusCode = modelOutput.getStatusCode();
                                    if (modelOutput.getMlModelTensors() != null && !modelOutput.getMlModelTensors().isEmpty()) {
                                        Map dataAsMap = ((ModelTensor)modelOutput.getMlModelTensors().get(0)).getDataAsMap();
                                        if (dataAsMap != null && statusCode != null && statusCode >= 200 && statusCode < 300) {
                                            remoteJob.putAll(dataAsMap);
                                            remoteJob.put("dlq", ((RemoteInferenceInputDataSet)mlInput.getInputDataset()).getDlq());
                                            mlTask.setRemoteJob(remoteJob);
                                            mlTask.setTaskId(null);
                                            this.mlTaskManager.createMLTask(mlTask, (ActionListener<IndexResponse>)ActionListenerHelper.wrap(response -> {
                                                String taskId = response.getId();
                                                mlTask.setTaskId(taskId);
                                                MLPredictionOutput outputBuilder = new MLPredictionOutput(taskId, MLTaskState.CREATED.name(), remoteJob);
                                                if (!this.clusterService.state().metadata().indices().containsKey(".ml_commons_task_polling_job")) {
                                                    this.mlTaskManager.startTaskPollingJob();
                                                }
                                                MLTaskResponse predictOutput = MLTaskResponse.builder().output((MLOutput)outputBuilder).build();
                                                internalListener.onResponse((Object)predictOutput);
                                            }, e -> {
                                                MLExceptionUtils.logException((String)"Failed to create task for batch predict model", (Exception)e, (Logger)log);
                                                internalListener.onFailure(e);
                                            }));
                                        } else {
                                            log.debug("Batch transform job output from remote model did not return the job ID");
                                            internalListener.onFailure((Exception)new ResourceNotFoundException("Unable to create batch transform job", new Object[0]));
                                        }
                                    } else {
                                        log.debug("ML Model Tensors are null or empty.");
                                        internalListener.onFailure((Exception)new ResourceNotFoundException("Unable to create batch transform job", new Object[0]));
                                    }
                                } else {
                                    log.debug("ML Model Outputs are null or empty.");
                                    internalListener.onFailure((Exception)new ResourceNotFoundException("Unable to create batch transform job", new Object[0]));
                                }
                            } else {
                                this.handleAsyncMLTaskComplete(mlTask);
                                this.mlModelManager.trackPredictDuration(modelId, startTime);
                                internalListener.onResponse(output);
                            }
                        }, e -> this.handlePredictFailure(mlTask, internalListener, (Exception)e, false, modelId, actionName));
                        predictor.asyncPredict(mlInput, trackPredictDurationListener);
                    } else {
                        MLOutput output2 = this.mlModelManager.trackPredictDuration(modelId, () -> predictor.predict(mlInput));
                        if (output2 instanceof MLPredictionOutput) {
                            ((MLPredictionOutput)output2).setStatus(MLTaskState.COMPLETED.name());
                        }
                        if (output2 instanceof ModelTensorOutput) {
                            this.validateOutputSchema(modelId, (ModelTensorOutput)output2);
                        }
                        this.handleAsyncMLTaskComplete(mlTask);
                        internalListener.onResponse((Object)new MLTaskResponse(output2));
                    }
                    return;
                }
                catch (Exception e2) {
                    log.error("Failed to predict model " + modelId, (Throwable)e2);
                    this.handlePredictFailure(mlTask, internalListener, e2, false, modelId, actionName);
                    return;
                }
            }
            if (FunctionName.needDeployFirst((FunctionName)algorithm)) {
                throw new IllegalArgumentException("Model not ready to be used: " + modelId);
            }
            try (ThreadContext.StoredContext context = this.threadPool.getThreadContext().stashContext();){
                ActionListener getModelListener = ActionListenerHelper.wrap(r -> {
                    if (r == null || !r.isExists()) {
                        internalListener.onFailure((Exception)new ResourceNotFoundException("No model found, please check the modelId.", new Object[0]));
                        return;
                    }
                    try (XContentParser xContentParser = MediaTypeRegistry.JSON.xContent().createParser(this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, r.getSourceAsString());){
                        MLOutput output;
                        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xContentParser.nextToken(), (XContentParser)xContentParser);
                        GetResponse getResponse = r;
                        String algorithmName = getResponse.getSource().get("algorithm").toString();
                        MLModel mlModel = MLModel.parse((XContentParser)xContentParser, (String)algorithmName);
                        mlModel.setModelId(modelId);
                        User resourceUser = mlModel.getUser();
                        User requestUser = AccessController.getUserContext(this.client);
                        if (!AccessController.checkUserPermissions(requestUser, resourceUser, modelId)) {
                            SkyliteException e = new SkyliteException("User: " + requestUser.getName() + " does not have permissions to run predict by model: " + modelId, new Object[0]);
                            this.handlePredictFailure(mlTask, internalListener, (Exception)e, false, modelId, actionName);
                            return;
                        }
                        if (this.mlTaskManager.contains(mlTask.getTaskId())) {
                            this.mlTaskManager.updateTaskStateAsRunning(mlTask.getTaskId(), tenantId, mlTask.isAsync());
                        }
                        if ((output = this.mlEngine.predict((Input)mlInput, mlModel)) instanceof MLPredictionOutput) {
                            ((MLPredictionOutput)output).setStatus(MLTaskState.COMPLETED.name());
                        }
                        if (output instanceof ModelTensorOutput) {
                            this.validateOutputSchema(modelId, (ModelTensorOutput)output);
                        }
                        this.handleAsyncMLTaskComplete(mlTask);
                        MLTaskResponse response = MLTaskResponse.builder().output(output).build();
                        internalListener.onResponse((Object)response);
                    }
                    catch (Exception e) {
                        log.error("Failed to predict model " + modelId, (Throwable)e);
                        internalListener.onFailure(e);
                    }
                }, e -> {
                    log.error("Failed to predict " + String.valueOf(mlInput.getAlgorithm()) + ", modelId: " + mlTask.getModelId(), (Throwable)e);
                    this.handlePredictFailure(mlTask, internalListener, (Exception)e, true, modelId, actionName);
                });
                GetRequest getRequest = new GetRequest(".plugins-ml-model", mlTask.getModelId());
                this.client.get(getRequest, this.threadedActionListener(mlTask.getFunctionName(), ActionListenerHelper.runBefore((ActionListener)getModelListener, () -> context.restore())));
            }
            catch (Exception e3) {
                log.error("Failed to get model " + mlTask.getModelId(), (Throwable)e3);
                this.handlePredictFailure(mlTask, internalListener, e3, true, modelId, actionName);
            }
        } else {
            IllegalArgumentException e4 = new IllegalArgumentException("ModelId is invalid");
            log.error("ModelId is invalid", (Throwable)e4);
            this.handlePredictFailure(mlTask, internalListener, e4, false, modelId, actionName);
        }
    }

    private <T> ThreadedActionListener<T> threadedActionListener(FunctionName functionName, ActionListener<T> listener) {
        String threadPoolName = this.getPredictThreadPool(functionName);
        return new ThreadedActionListener(log, this.threadPool, threadPoolName, listener, false);
    }

    private void handlePredictFailure(MLTask mlTask, ActionListener<MLTaskResponse> listener, Exception e, boolean trackFailure, String modelId, ActionName actionName) {
        if (trackFailure) {
            this.mlStats.createCounterStatIfAbsent(mlTask.getFunctionName(), actionName, MLActionLevelStat.ML_ACTION_FAILURE_COUNT).increment();
            this.mlStats.createModelCounterStatIfAbsent(modelId, actionName, MLActionLevelStat.ML_ACTION_FAILURE_COUNT);
            this.mlStats.getStat((Enum)MLNodeLevelStat.ML_FAILURE_COUNT).increment();
        }
        this.handleAsyncMLTaskFailure(mlTask, e);
        listener.onFailure(e);
    }

    private ActionName getActionNameFromInput(MLInput mlInput) {
        ConnectorAction.ActionType actionType = null;
        if (mlInput.getInputDataset() instanceof RemoteInferenceInputDataSet) {
            actionType = ((RemoteInferenceInputDataSet)mlInput.getInputDataset()).getActionType();
        }
        return actionType == null ? ActionName.PREDICT : ActionName.from((String)actionType.toString());
    }

    public void validateOutputSchema(String modelId, ModelTensorOutput output) {
        if (this.mlModelManager.getModelInterface(modelId) != null && this.mlModelManager.getModelInterface(modelId).get("output") != null) {
            String outputSchemaString = this.mlModelManager.getModelInterface(modelId).get("output");
            try {
                MLNodeUtils.validateSchema((String)outputSchemaString, (String)output.toXContent(MediaTypeRegistry.JSON.contentBuilder(), ToXContent.EMPTY_PARAMS).toString());
            }
            catch (Exception e) {
                throw new SkyliteStatusException("Error validating output schema: " + e.getMessage(), RestStatus.BAD_REQUEST, new Object[0]);
            }
        }
    }
}

