/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.task;

import io.lucenia.ml.common.task.MLTaskDispatcher;
import io.lucenia.ml.common.task.MLTaskManager;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.transport.TransportRequest;
import io.skylite.core.transport.TransportResponse;
import io.skylite.core.transport.TransportResponseHandler;
import io.skylite.core.transport.TransportService;
import io.skylite.ml.common.FunctionName;
import io.skylite.ml.common.breaker.MLCircuitBreakerService;
import io.skylite.ml.common.cluster.DiscoveryNodeHelper;
import io.skylite.ml.common.cluster.MLNodeUtils;
import io.skylite.ml.common.stats.MLNodeLevelStat;
import io.skylite.ml.common.stats.MLStats;
import io.skylite.ml.common.task.MLTask;
import io.skylite.ml.common.task.MLTaskState;
import io.skylite.ml.common.transport.MLTaskRequest;
import io.skylite.ml.common.transport.MLTaskResponse;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class MLTaskRunner<Request extends MLTaskRequest, Response extends TransportResponse> {
    private static final Logger log = LogManager.getLogger(MLTaskRunner.class);
    public static final int TIMEOUT_IN_MILLIS = 2000;
    protected final MLTaskManager mlTaskManager;
    protected final MLStats mlStats;
    protected final DiscoveryNodeHelper nodeHelper;
    protected final MLTaskDispatcher mlTaskDispatcher;
    protected final MLCircuitBreakerService mlCircuitBreakerService;
    private final ClusterService clusterService;

    public MLTaskRunner(MLTaskManager mlTaskManager, MLStats mlStats, DiscoveryNodeHelper nodeHelper, MLTaskDispatcher mlTaskDispatcher, MLCircuitBreakerService mlCircuitBreakerService, ClusterService clusterService) {
        this.mlTaskManager = mlTaskManager;
        this.mlStats = mlStats;
        this.nodeHelper = nodeHelper;
        this.mlTaskDispatcher = mlTaskDispatcher;
        this.mlCircuitBreakerService = mlCircuitBreakerService;
        this.clusterService = clusterService;
    }

    protected void handleAsyncMLTaskFailure(MLTask mlTask, Exception e) {
        if (mlTask.isAsync()) {
            Map<String, Object> updatedFields = Map.of("state", MLTaskState.FAILED.name(), "error", e.getMessage());
            this.mlTaskManager.updateMLTask(mlTask.getTaskId(), null, updatedFields, 2000L, true);
        }
    }

    protected void handleAsyncMLTaskComplete(MLTask mlTask) {
        if (mlTask.isAsync()) {
            HashMap<String, Object> updatedFields = new HashMap<String, Object>();
            updatedFields.put("state", MLTaskState.COMPLETED);
            if (mlTask.getModelId() != null) {
                updatedFields.put("model_id", mlTask.getModelId());
            }
            this.mlTaskManager.updateMLTask(mlTask.getTaskId(), null, updatedFields, 2000L, true);
        }
    }

    public void run(FunctionName functionName, Request request, TransportService transportService, ActionListener<Response> listener) {
        if (!request.isDispatchTask()) {
            log.debug("Run ML request {} locally", (Object)request.getRequestID());
            MLNodeUtils.checkOpenCircuitBreaker((MLCircuitBreakerService)this.mlCircuitBreakerService, (MLStats)this.mlStats);
            this.checkCBAndExecute(functionName, request, listener);
            return;
        }
        this.dispatchTask(functionName, request, transportService, listener);
    }

    protected ActionListener<MLTaskResponse> wrappedCleanupListener(ActionListener<MLTaskResponse> listener, String taskId) {
        ActionListener internalListener = ActionListenerHelper.runAfter(listener, () -> {
            this.mlStats.getStat((Enum)MLNodeLevelStat.ML_EXECUTING_TASK_COUNT).decrement();
            this.mlTaskManager.remove(taskId);
        });
        return internalListener;
    }

    public void dispatchTask(FunctionName functionName, Request request, TransportService transportService, ActionListener<Response> listener) {
        this.mlTaskDispatcher.dispatch(functionName, (ActionListener<DiscoveryNode>)ActionListenerHelper.wrap(node -> {
            String nodeId = node.getId();
            if (this.clusterService.localNode().getId().equals(nodeId)) {
                log.debug("Execute ML request {} locally on node {}", (Object)request.getRequestID(), (Object)nodeId);
                MLNodeUtils.checkOpenCircuitBreaker((MLCircuitBreakerService)this.mlCircuitBreakerService, (MLStats)this.mlStats);
                this.executeTask(request, listener);
            } else {
                log.debug("Execute ML request {} remotely on node {}", (Object)request.getRequestID(), (Object)nodeId);
                request.setDispatchTask(false);
                transportService.sendRequest(node, this.getTransportActionName(), (TransportRequest)request, this.getResponseHandler(listener));
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    protected abstract String getTransportActionName();

    protected abstract TransportResponseHandler<Response> getResponseHandler(ActionListener<Response> var1);

    protected abstract void executeTask(Request var1, ActionListener<Response> var2);

    protected void checkCBAndExecute(FunctionName functionName, Request request, ActionListener<Response> listener) {
        if (functionName != FunctionName.REMOTE) {
            MLNodeUtils.checkOpenCircuitBreaker((MLCircuitBreakerService)this.mlCircuitBreakerService, (MLStats)this.mlStats);
        }
        this.executeTask(request, listener);
    }
}

