/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.tools;

import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.tasks.Task;
import io.skylite.core.transport.TransportService;
import io.skylite.ml.common.transport.tools.MLToolsListRequest;
import io.skylite.ml.common.transport.tools.MLToolsListResponse;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ListToolsTransportAction
extends HandledTransportAction<ActionRequest, MLToolsListResponse> {
    private static final Logger log = LogManager.getLogger(ListToolsTransportAction.class);

    @Inject
    public ListToolsTransportAction(TransportService transportService, ActionFilters actionFilters) {
        super("cluster:admin/lucenia/ml/tools/list", transportService, actionFilters, MLToolsListRequest::new);
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<MLToolsListResponse> listener) {
        MLToolsListRequest mlToolsGetRequest = MLToolsListRequest.fromActionRequest((ActionRequest)request);
        List toolsList = mlToolsGetRequest.getToolMetadataList();
        try {
            listener.onResponse((Object)MLToolsListResponse.builder().toolMetadata(toolsList).build());
        }
        catch (Exception e) {
            log.error("Failed to get tools list", (Throwable)e);
            listener.onFailure(e);
        }
    }
}

