/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.utils;

import io.skylite.SkyliteStatusException;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.admin.indices.stats.IndicesStatsRequest;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.health.ClusterIndexHealth;
import io.skylite.core.cluster.metadata.IndexAbstraction;
import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.index.query.BoolQueryBuilder;
import io.skylite.core.index.query.QueryBuilder;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.search.SearchRequest;
import io.skylite.core.search.builder.SearchSourceBuilder;
import io.skylite.core.xcontent.DeprecationHandler;
import io.skylite.core.xcontent.LoggingDeprecationHandler;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.XContentParser;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import org.opensearch.index.query.QueryBuilders;

public class IndexUtils {
    public static final String NONEXISTENT_INDEX_STATUS = "non-existent";
    public static final String ALIAS_EXISTS_NO_INDICES_STATUS = "alias exists, but does not point to any indices";
    private Client client;
    private ClusterService clusterService;

    @Inject
    public IndexUtils(Client client, ClusterService clusterService) {
        this.client = client;
        this.clusterService = clusterService;
    }

    public String getIndexHealthStatus(String indexOrAliasName) throws IllegalArgumentException {
        if (!this.clusterService.state().getRoutingTable().hasIndex(indexOrAliasName)) {
            if (this.clusterService.state().metadata().hasAlias(indexOrAliasName)) {
                List indexMetaDataList = ((IndexAbstraction)this.clusterService.state().metadata().getIndicesLookup().get(indexOrAliasName)).getIndices();
                if (indexMetaDataList.size() == 0) {
                    return ALIAS_EXISTS_NO_INDICES_STATUS;
                }
                if (indexMetaDataList.size() > 1) {
                    throw new IllegalArgumentException("Cannot get health for alias that points to multiple indices");
                }
                indexOrAliasName = ((IndexMetadata)indexMetaDataList.get(0)).getIndex().getName();
            } else {
                return NONEXISTENT_INDEX_STATUS;
            }
        }
        ClusterIndexHealth indexHealth = new ClusterIndexHealth(this.clusterService.state().metadata().index(indexOrAliasName), this.clusterService.state().getRoutingTable().index(indexOrAliasName));
        return indexHealth.getStatus().name().toLowerCase(Locale.ROOT);
    }

    public void getNumberOfDocumentsInIndex(String indexName, ActionListener<Long> listener) {
        if (this.clusterService.state().getRoutingTable().hasIndex(indexName)) {
            IndicesStatsRequest indicesStatsRequest = new IndicesStatsRequest();
            indicesStatsRequest.indices(new String[]{indexName});
            this.client.admin().indices().stats(indicesStatsRequest, ActionListenerHelper.wrap(r -> {
                long count = r.getIndex((String)indexName).getPrimaries().docs.getCount();
                listener.onResponse((Object)count);
            }, e -> listener.onFailure(e)));
        } else {
            listener.onResponse((Object)0L);
        }
    }

    public void getNumberOfDocumentsInIndex(String indexName, String searchQuery, NamedXContentRegistry xContentRegistry, ActionListener<Long> listener) {
        block9: {
            if (this.clusterService.state().getRoutingTable().hasIndex(indexName)) {
                try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
                    SearchRequest searchRequest = new SearchRequest();
                    XContentParser parser = MediaTypeRegistry.JSON.xContent().createParser(xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, searchQuery);
                    SearchSourceBuilder builder = SearchSourceBuilder.fromXContent((XContentParser)parser);
                    builder.fetchSource(false);
                    searchRequest.source(builder).indices(new String[]{indexName});
                    this.client.search(searchRequest, ActionListenerHelper.runBefore((ActionListener)ActionListenerHelper.wrap(r -> {
                        long count = r.getHits().getTotalHits().value();
                        listener.onResponse((Object)count);
                    }, e -> listener.onFailure(e)), () -> context.restore()));
                    break block9;
                }
                catch (Exception e2) {
                    throw new SkyliteStatusException("Failed to search index " + indexName, RestStatus.BAD_REQUEST, new Object[0]);
                }
            }
            listener.onResponse((Object)0L);
        }
    }

    public static SearchRequest buildHiddenModelSearchRequest() {
        SearchRequest searchRequest = new SearchRequest(new String[]{".plugins-ml-model"});
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.filter((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"is_hidden", (boolean)true)).mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"chunk_number")));
        searchRequest.source().query((QueryBuilder)boolQueryBuilder);
        searchRequest.source().fetchSource(new String[]{"_id"}, new String[0]);
        return searchRequest;
    }

    public static class IndexStatusSupplier
    implements Supplier<String> {
        private IndexUtils indexUtils;
        private String indexName;
        public static final String UNABLE_TO_RETRIEVE_HEALTH_MESSAGE = "unable to retrieve health";

        public IndexStatusSupplier(IndexUtils indexUtils, String indexName) {
            this.indexUtils = indexUtils;
            this.indexName = indexName;
        }

        @Override
        public String get() {
            try {
                return this.indexUtils.getIndexHealthStatus(this.indexName);
            }
            catch (Exception e) {
                return UNABLE_TO_RETRIEVE_HEALTH_MESSAGE;
            }
        }
    }
}

