/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.utils;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import io.skylite.common.xcontent.json.JsonXContent;
import io.skylite.core.common.Strings;
import io.skylite.ml.common.agent.MLToolSpec;
import io.skylite.ml.common.output.model.ModelTensor;
import io.skylite.ml.common.output.model.ModelTensorOutput;
import io.skylite.ml.common.output.model.ModelTensors;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.text.StringSubstitutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToolUtils {
    public static Logger log = LoggerFactory.getLogger(ToolUtils.class);
    public static final String TOOL_OUTPUT_FILTERS_FIELD = "output_filter";
    public static final String TOOL_REQUIRED_PARAMS = "required_parameters";

    public static Map<String, String> extractRequiredParameters(Map<String, String> parameters, Map<String, ?> attributes) {
        HashMap<String, String> extractedParameters = new HashMap<String, String>();
        if (parameters == null) {
            return extractedParameters;
        }
        if (attributes != null && attributes.containsKey(TOOL_REQUIRED_PARAMS)) {
            List requiredParameters = Strings.parseStringArrayToList((String)((String)attributes.get(TOOL_REQUIRED_PARAMS)));
            if (requiredParameters != null) {
                for (String requiredParameter : requiredParameters) {
                    extractedParameters.put(requiredParameter, parameters.get(requiredParameter));
                }
            }
        } else {
            extractedParameters.putAll(parameters);
        }
        return extractedParameters;
    }

    public static Map<String, String> extractInputParameters(Map<String, String> parameters, Map<String, ?> attributes) {
        Map<String, String> extractedParameters = ToolUtils.extractRequiredParameters(parameters, attributes);
        if (extractedParameters.containsKey("input")) {
            try {
                StringSubstitutor stringSubstitutor = new StringSubstitutor(parameters, "${parameters.", "}");
                String input = stringSubstitutor.replace(parameters.get("input"));
                extractedParameters.put("input", input);
                Map inputParameters = (Map)new ObjectMapper().readValue(input, (TypeReference)new TypeReference<Map<String, String>>(){});
                extractedParameters.putAll(inputParameters);
                extractedParameters.putAll(inputParameters);
            }
            catch (Exception exception) {
                log.info("fail extract parameters from key 'input' due to" + exception.getMessage());
            }
        }
        return extractedParameters;
    }

    public static Map<String, String> buildToolParameters(Map<String, String> parameters, MLToolSpec toolSpec, String tenantId) {
        HashMap<String, String> executeParams = new HashMap<String, String>();
        if (toolSpec.getParameters() != null) {
            executeParams.putAll(toolSpec.getParameters());
        }
        executeParams.putAll(parameters);
        for (String key : parameters.keySet()) {
            String toolName = ToolUtils.getToolName(toolSpec);
            String toolNamePrefix = toolName + ".";
            String toolDescription = toolName + ".description";
            String toolTypePrefix = toolSpec.getType() + ".";
            if (key.startsWith(toolNamePrefix) && !toolDescription.equals(key)) {
                executeParams.put(key.replace(toolNamePrefix, ""), parameters.get(key));
                executeParams.remove(key);
                continue;
            }
            if (!key.startsWith(toolTypePrefix)) continue;
            executeParams.remove(key);
        }
        if (toolSpec.getConfigMap() != null && !toolSpec.getConfigMap().isEmpty()) {
            executeParams.putAll(toolSpec.getConfigMap());
        }
        executeParams.put("tenant_id", tenantId);
        return executeParams;
    }

    public static Object filterToolOutput(Map<String, String> toolParams, Object response) {
        if (toolParams != null && toolParams.containsKey(TOOL_OUTPUT_FILTERS_FIELD)) {
            try {
                String output = ToolUtils.parseResponse(response);
                Object filteredOutput = JsonPath.read((String)output, (String)toolParams.get(TOOL_OUTPUT_FILTERS_FIELD), (Predicate[])new Predicate[0]);
                return Strings.toJson((Object)filteredOutput);
            }
            catch (PathNotFoundException e) {
                log.error("JSONPath not found: [{}]", (Object)toolParams.get(TOOL_OUTPUT_FILTERS_FIELD), (Object)e);
            }
            catch (Exception e) {
                log.error("Failed to read tool response from path [{}]", (Object)toolParams.get(TOOL_OUTPUT_FILTERS_FIELD), (Object)e);
            }
        }
        return response;
    }

    public static String parseResponse(Object output) {
        try {
            if (output instanceof List && !((List)output).isEmpty() && ((List)output).get(0) instanceof ModelTensors) {
                ModelTensors tensors = (ModelTensors)((List)output).get(0);
                return tensors.toXContent(JsonXContent.contentBuilder(), null).toString();
            }
            if (output instanceof ModelTensor) {
                return ((ModelTensor)output).toXContent(JsonXContent.contentBuilder(), null).toString();
            }
            if (output instanceof ModelTensorOutput) {
                return ((ModelTensorOutput)output).toXContent(JsonXContent.contentBuilder(), null).toString();
            }
            return Strings.toJson((Object)output);
        }
        catch (Exception e) {
            return Strings.toJson((Object)output);
        }
    }

    public static String getToolName(MLToolSpec toolSpec) {
        return toolSpec.getName() != null ? toolSpec.getName() : toolSpec.getType();
    }
}

