/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.script.expression;

import io.lucenia.script.expression.DateObjectValueSource;
import io.skylite.core.common.time.DateFormatters;
import io.skylite.core.index.fielddata.IndexFieldData;
import io.skylite.core.search.MultiValueMode;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import org.apache.lucene.search.DoubleValuesSource;

final class DateObject {
    static final String CENTURY_OF_ERA_VARIABLE = "centuryOfEra";
    static final String DAY_OF_MONTH_VARIABLE = "dayOfMonth";
    static final String DAY_OF_WEEK_VARIABLE = "dayOfWeek";
    static final String DAY_OF_YEAR_VARIABLE = "dayOfYear";
    static final String ERA_VARIABLE = "era";
    static final String HOUR_OF_DAY_VARIABLE = "hourOfDay";
    static final String MILLIS_OF_DAY_VARIABLE = "millisOfDay";
    static final String MILLIS_OF_SECOND_VARIABLE = "millisOfSecond";
    static final String MINUTE_OF_DAY_VARIABLE = "minuteOfDay";
    static final String MINUTE_OF_HOUR_VARIABLE = "minuteOfHour";
    static final String MONTH_OF_YEAR_VARIABLE = "monthOfYear";
    static final String SECOND_OF_DAY_VARIABLE = "secondOfDay";
    static final String SECOND_OF_MINUTE_VARIABLE = "secondOfMinute";
    static final String WEEK_OF_WEEK_YEAR_VARIABLE = "weekOfWeekyear";
    static final String WEEK_YEAR_VARIABLE = "weekyear";
    static final String YEAR_VARIABLE = "year";
    static final String YEAR_OF_CENTURY_VARIABLE = "yearOfCentury";
    static final String YEAR_OF_ERA_VARIABLE = "yearOfEra";
    static final String GETCENTURY_OF_ERA_METHOD = "getCenturyOfEra";
    static final String GETDAY_OF_MONTH_METHOD = "getDayOfMonth";
    static final String GETDAY_OF_WEEK_METHOD = "getDayOfWeek";
    static final String GETDAY_OF_YEAR_METHOD = "getDayOfYear";
    static final String GETERA_METHOD = "getEra";
    static final String GETHOUR_OF_DAY_METHOD = "getHourOfDay";
    static final String GETMILLIS_OF_DAY_METHOD = "getMillisOfDay";
    static final String GETMILLIS_OF_SECOND_METHOD = "getMillisOfSecond";
    static final String GETMINUTE_OF_DAY_METHOD = "getMinuteOfDay";
    static final String GETMINUTE_OF_HOUR_METHOD = "getMinuteOfHour";
    static final String GETMONTH_OF_YEAR_METHOD = "getMonthOfYear";
    static final String GETSECOND_OF_DAY_METHOD = "getSecondOfDay";
    static final String GETSECOND_OF_MINUTE_METHOD = "getSecondOfMinute";
    static final String GETWEEK_OF_WEEK_YEAR_METHOD = "getWeekOfWeekyear";
    static final String GETWEEK_YEAR_METHOD = "getWeekyear";
    static final String GETYEAR_METHOD = "getYear";
    static final String GETYEAR_OF_CENTURY_METHOD = "getYearOfCentury";
    static final String GETYEAR_OF_ERA_METHOD = "getYearOfEra";

    private DateObject() {
    }

    static DoubleValuesSource getVariable(IndexFieldData<?> fieldData, String fieldName, String variable) {
        switch (variable) {
            case "centuryOfEra": {
                return new DateObjectValueSource(fieldData, MultiValueMode.MIN, variable, zdt -> zdt.get(ChronoField.YEAR_OF_ERA) / 100);
            }
            case "dayOfMonth": {
                return new DateObjectValueSource(fieldData, MultiValueMode.MIN, variable, ZonedDateTime::getDayOfMonth);
            }
            case "dayOfWeek": {
                return new DateObjectValueSource(fieldData, MultiValueMode.MIN, variable, zdt -> zdt.getDayOfWeek().getValue());
            }
            case "dayOfYear": {
                return new DateObjectValueSource(fieldData, MultiValueMode.MIN, variable, ZonedDateTime::getDayOfYear);
            }
            case "era": {
                return new DateObjectValueSource(fieldData, MultiValueMode.MIN, variable, zdt -> zdt.get(ChronoField.ERA));
            }
            case "hourOfDay": {
                return new DateObjectValueSource(fieldData, MultiValueMode.MIN, variable, ZonedDateTime::getHour);
            }
            case "millisOfDay": {
                return new DateObjectValueSource(fieldData, MultiValueMode.MIN, variable, zdt -> zdt.get(ChronoField.MILLI_OF_DAY));
            }
            case "millisOfSecond": {
                return new DateObjectValueSource(fieldData, MultiValueMode.MIN, variable, zdt -> zdt.get(ChronoField.MILLI_OF_SECOND));
            }
            case "minuteOfDay": {
                return new DateObjectValueSource(fieldData, MultiValueMode.MIN, variable, zdt -> zdt.get(ChronoField.MINUTE_OF_DAY));
            }
            case "minuteOfHour": {
                return new DateObjectValueSource(fieldData, MultiValueMode.MIN, variable, ZonedDateTime::getMinute);
            }
            case "monthOfYear": {
                return new DateObjectValueSource(fieldData, MultiValueMode.MIN, variable, ZonedDateTime::getMonthValue);
            }
            case "secondOfDay": {
                return new DateObjectValueSource(fieldData, MultiValueMode.MIN, variable, zdt -> zdt.get(ChronoField.SECOND_OF_DAY));
            }
            case "secondOfMinute": {
                return new DateObjectValueSource(fieldData, MultiValueMode.MIN, variable, ZonedDateTime::getSecond);
            }
            case "weekOfWeekyear": {
                return new DateObjectValueSource(fieldData, MultiValueMode.MIN, variable, zdt -> zdt.get(DateFormatters.WEEK_FIELDS_ROOT.weekOfWeekBasedYear()));
            }
            case "weekyear": {
                return new DateObjectValueSource(fieldData, MultiValueMode.MIN, variable, zdt -> zdt.get(DateFormatters.WEEK_FIELDS_ROOT.weekBasedYear()));
            }
            case "year": {
                return new DateObjectValueSource(fieldData, MultiValueMode.MIN, variable, ZonedDateTime::getYear);
            }
            case "yearOfCentury": {
                return new DateObjectValueSource(fieldData, MultiValueMode.MIN, variable, zdt -> zdt.get(ChronoField.YEAR_OF_ERA) % 100);
            }
            case "yearOfEra": {
                return new DateObjectValueSource(fieldData, MultiValueMode.MIN, variable, zdt -> zdt.get(ChronoField.YEAR_OF_ERA));
            }
        }
        throw new IllegalArgumentException("Member variable [" + variable + "] does not exist for date object on field [" + fieldName + "].");
    }

    static DoubleValuesSource getMethod(IndexFieldData<?> fieldData, String fieldName, String method) {
        switch (method) {
            case "getCenturyOfEra": {
                return new DateObjectValueSource(fieldData, MultiValueMode.MIN, method, zdt -> zdt.get(ChronoField.YEAR_OF_ERA) / 100);
            }
            case "getDayOfMonth": {
                return new DateObjectValueSource(fieldData, MultiValueMode.MIN, method, ZonedDateTime::getDayOfMonth);
            }
            case "getDayOfWeek": {
                return new DateObjectValueSource(fieldData, MultiValueMode.MIN, method, zdt -> zdt.getDayOfWeek().getValue());
            }
            case "getDayOfYear": {
                return new DateObjectValueSource(fieldData, MultiValueMode.MIN, method, ZonedDateTime::getDayOfYear);
            }
            case "getEra": {
                return new DateObjectValueSource(fieldData, MultiValueMode.MIN, method, zdt -> zdt.get(ChronoField.ERA));
            }
            case "getHourOfDay": {
                return new DateObjectValueSource(fieldData, MultiValueMode.MIN, method, ZonedDateTime::getHour);
            }
            case "getMillisOfDay": {
                return new DateObjectValueSource(fieldData, MultiValueMode.MIN, method, zdt -> zdt.get(ChronoField.MILLI_OF_DAY));
            }
            case "getMillisOfSecond": {
                return new DateObjectValueSource(fieldData, MultiValueMode.MIN, method, zdt -> zdt.get(ChronoField.MILLI_OF_SECOND));
            }
            case "getMinuteOfDay": {
                return new DateObjectValueSource(fieldData, MultiValueMode.MIN, method, zdt -> zdt.get(ChronoField.MINUTE_OF_DAY));
            }
            case "getMinuteOfHour": {
                return new DateObjectValueSource(fieldData, MultiValueMode.MIN, method, ZonedDateTime::getMinute);
            }
            case "getMonthOfYear": {
                return new DateObjectValueSource(fieldData, MultiValueMode.MIN, method, ZonedDateTime::getMonthValue);
            }
            case "getSecondOfDay": {
                return new DateObjectValueSource(fieldData, MultiValueMode.MIN, method, zdt -> zdt.get(ChronoField.SECOND_OF_DAY));
            }
            case "getSecondOfMinute": {
                return new DateObjectValueSource(fieldData, MultiValueMode.MIN, method, ZonedDateTime::getSecond);
            }
            case "getWeekOfWeekyear": {
                return new DateObjectValueSource(fieldData, MultiValueMode.MIN, method, zdt -> zdt.get(DateFormatters.WEEK_FIELDS_ROOT.weekOfWeekBasedYear()));
            }
            case "getWeekyear": {
                return new DateObjectValueSource(fieldData, MultiValueMode.MIN, method, zdt -> zdt.get(DateFormatters.WEEK_FIELDS_ROOT.weekBasedYear()));
            }
            case "getYear": {
                return new DateObjectValueSource(fieldData, MultiValueMode.MIN, method, ZonedDateTime::getYear);
            }
            case "getYearOfCentury": {
                return new DateObjectValueSource(fieldData, MultiValueMode.MIN, method, zdt -> zdt.get(ChronoField.YEAR_OF_ERA) % 100);
            }
            case "getYearOfEra": {
                return new DateObjectValueSource(fieldData, MultiValueMode.MIN, method, zdt -> zdt.get(ChronoField.YEAR_OF_ERA));
            }
        }
        throw new IllegalArgumentException("Member method [" + method + "] does not exist for date object on field [" + fieldName + "].");
    }
}

