/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.script.expression;

import io.lucenia.script.expression.DateField;
import io.lucenia.script.expression.DateObject;
import io.lucenia.script.expression.ExpressionAggregationScript;
import io.lucenia.script.expression.ExpressionFieldScript;
import io.lucenia.script.expression.ExpressionNumberSortScript;
import io.lucenia.script.expression.ExpressionScoreScript;
import io.lucenia.script.expression.ExpressionTermSetQueryScript;
import io.lucenia.script.expression.GeoField;
import io.lucenia.script.expression.NumericField;
import io.lucenia.script.expression.ReplaceableConstDoubleValueSource;
import io.lucenia.script.expression.ReplaceableConstDoubleValues;
import io.skylite.SpecialPermission;
import io.skylite.common.Nullable;
import io.skylite.core.aggregations.AggregationScript;
import io.skylite.core.index.fielddata.IndexFieldData;
import io.skylite.core.index.fielddata.IndexNumericFieldData;
import io.skylite.core.mapper.BaseMappedFieldType;
import io.skylite.core.mapper.DateFieldMapper;
import io.skylite.core.script.FieldScript;
import io.skylite.core.script.NumberSortScript;
import io.skylite.core.script.ScriptContext;
import io.skylite.core.script.ScriptEngine;
import io.skylite.core.script.ScriptException;
import io.skylite.core.script.TermsSetQueryScript;
import io.skylite.core.search.lookup.SearchLookup;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.lucene.expressions.Expression;
import org.apache.lucene.expressions.SimpleBindings;
import org.apache.lucene.expressions.js.JavascriptCompiler;
import org.apache.lucene.expressions.js.VariableContext;
import org.apache.lucene.search.DoubleValues;
import org.apache.lucene.search.DoubleValuesSource;
import org.apache.lucene.search.IndexSearcher;
import org.opensearch.index.mapper.GeoPointFieldMapper;
import org.opensearch.script.BucketAggregationScript;
import org.opensearch.script.BucketAggregationSelectorScript;
import org.opensearch.script.FilterScript;
import org.opensearch.script.ScoreScript;

public class ExpressionScriptEngine
implements ScriptEngine {
    public static final String NAME = "expression";
    private static Map<ScriptContext<?>, Function<Expression, Object>> contexts;

    public String getType() {
        return NAME;
    }

    public <T> T compile(String scriptName, String scriptSource, ScriptContext<T> context, Map<String, String> params) {
        Expression expr;
        SpecialPermission.check();
        try {
            expr = JavascriptCompiler.compile((String)scriptSource, (Map)JavascriptCompiler.DEFAULT_FUNCTIONS);
        }
        catch (ParseException e) {
            throw ExpressionScriptEngine.convertToScriptException("compile error", scriptSource, scriptSource, e);
        }
        if (!contexts.containsKey(context)) {
            throw new IllegalArgumentException("expression engine does not know how to handle script context [" + context.name + "]");
        }
        return context.factoryClazz.cast(contexts.get(context).apply(expr));
    }

    public Set<ScriptContext<?>> getSupportedContexts() {
        return contexts.keySet();
    }

    private static BucketAggregationScript.Factory newBucketAggregationScriptFactory(final Expression expr) {
        return parameters -> {
            final ReplaceableConstDoubleValues[] functionValuesArray = new ReplaceableConstDoubleValues[expr.variables.length];
            final HashMap<String, ReplaceableConstDoubleValues> functionValuesMap = new HashMap<String, ReplaceableConstDoubleValues>();
            for (int i = 0; i < expr.variables.length; ++i) {
                functionValuesArray[i] = new ReplaceableConstDoubleValues();
                functionValuesMap.put(expr.variables[i], functionValuesArray[i]);
            }
            return new BucketAggregationScript(parameters){

                public Double execute() {
                    this.getParams().forEach((name, value) -> {
                        ReplaceableConstDoubleValues placeholder = (ReplaceableConstDoubleValues)((Object)((Object)functionValuesMap.get(name)));
                        if (placeholder == null) {
                            throw new IllegalArgumentException("Error using " + String.valueOf(expr) + ". The variable [" + name + "] does not exist in the executable expressions script.");
                        }
                        if (!(value instanceof Number)) {
                            throw new IllegalArgumentException("Error using " + String.valueOf(expr) + ". Executable expressions scripts can only process numbers.  The variable [" + name + "] is not a number.");
                        }
                        placeholder.setValue(((Number)value).doubleValue());
                    });
                    try {
                        return expr.evaluate((DoubleValues[])functionValuesArray);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
            };
        };
    }

    private static NumberSortScript.LeafFactory newSortScript(Expression expr, SearchLookup lookup, @Nullable Map<String, Object> vars) {
        SimpleBindings bindings = new SimpleBindings();
        boolean needsScores = false;
        for (String variable : expr.variables) {
            try {
                if (variable.equals("_score")) {
                    bindings.add("_score", DoubleValuesSource.SCORES);
                    needsScores = true;
                    continue;
                }
                if (vars != null && vars.containsKey(variable)) {
                    ExpressionScriptEngine.bindFromParams(vars, bindings, variable);
                    continue;
                }
                DoubleValuesSource valueSource = ExpressionScriptEngine.getDocValueSource(variable, lookup);
                needsScores |= valueSource.needsScores();
                bindings.add(variable, valueSource);
            }
            catch (Exception e) {
                throw ExpressionScriptEngine.convertToScriptException("link error", expr.sourceText, variable, e);
            }
        }
        return new ExpressionNumberSortScript(expr, bindings, needsScores);
    }

    private static TermsSetQueryScript.LeafFactory newTermsSetQueryScript(Expression expr, SearchLookup lookup, @Nullable Map<String, Object> vars) {
        SimpleBindings bindings = new SimpleBindings();
        for (String variable : expr.variables) {
            try {
                if (vars != null && vars.containsKey(variable)) {
                    ExpressionScriptEngine.bindFromParams(vars, bindings, variable);
                    continue;
                }
                bindings.add(variable, ExpressionScriptEngine.getDocValueSource(variable, lookup));
            }
            catch (Exception e) {
                throw ExpressionScriptEngine.convertToScriptException("link error", expr.sourceText, variable, e);
            }
        }
        return new ExpressionTermSetQueryScript(expr, bindings);
    }

    private static AggregationScript.LeafFactory newAggregationScript(Expression expr, SearchLookup lookup, @Nullable Map<String, Object> vars) {
        SimpleBindings bindings = new SimpleBindings();
        boolean needsScores = false;
        ReplaceableConstDoubleValueSource specialValue = null;
        for (String variable : expr.variables) {
            try {
                if (variable.equals("_score")) {
                    bindings.add("_score", DoubleValuesSource.SCORES);
                    needsScores = true;
                    continue;
                }
                if (variable.equals("_value")) {
                    specialValue = new ReplaceableConstDoubleValueSource();
                    bindings.add("_value", (DoubleValuesSource)specialValue);
                    continue;
                }
                if (vars != null && vars.containsKey(variable)) {
                    ExpressionScriptEngine.bindFromParams(vars, bindings, variable);
                    continue;
                }
                DoubleValuesSource valueSource = ExpressionScriptEngine.getDocValueSource(variable, lookup);
                needsScores |= valueSource.needsScores();
                bindings.add(variable, valueSource);
            }
            catch (Exception e) {
                throw ExpressionScriptEngine.convertToScriptException("link error", expr.sourceText, variable, e);
            }
        }
        return new ExpressionAggregationScript(expr, bindings, needsScores, specialValue);
    }

    private static FieldScript.LeafFactory newFieldScript(Expression expr, SearchLookup lookup, @Nullable Map<String, Object> vars) {
        SimpleBindings bindings = new SimpleBindings();
        for (String variable : expr.variables) {
            try {
                if (vars != null && vars.containsKey(variable)) {
                    ExpressionScriptEngine.bindFromParams(vars, bindings, variable);
                    continue;
                }
                bindings.add(variable, ExpressionScriptEngine.getDocValueSource(variable, lookup));
            }
            catch (Exception e) {
                throw ExpressionScriptEngine.convertToScriptException("link error", expr.sourceText, variable, e);
            }
        }
        return new ExpressionFieldScript(expr, bindings);
    }

    private static FilterScript.LeafFactory newFilterScript(Expression expr, SearchLookup lookup, @Nullable Map<String, Object> vars) {
        ScoreScript.LeafFactory searchLeafFactory = ExpressionScriptEngine.newScoreScript(expr, lookup, vars);
        return ctx -> {
            final ScoreScript script = searchLeafFactory.newInstance(ctx);
            return new FilterScript(vars, lookup, ctx){

                public boolean execute() {
                    return script.execute(null) != 0.0;
                }

                public void setDocument(int docid) {
                    script.setDocument(docid);
                }
            };
        };
    }

    private static ScoreScript.LeafFactory newScoreScript(Expression expr, SearchLookup lookup, @Nullable Map<String, Object> vars) {
        SimpleBindings bindings = new SimpleBindings();
        ReplaceableConstDoubleValueSource specialValue = null;
        boolean needsScores = false;
        for (String variable : expr.variables) {
            try {
                if (variable.equals("_score")) {
                    bindings.add("_score", DoubleValuesSource.SCORES);
                    needsScores = true;
                    continue;
                }
                if (variable.equals("_value")) {
                    specialValue = new ReplaceableConstDoubleValueSource();
                    bindings.add("_value", (DoubleValuesSource)specialValue);
                    continue;
                }
                if (vars != null && vars.containsKey(variable)) {
                    ExpressionScriptEngine.bindFromParams(vars, bindings, variable);
                    continue;
                }
                DoubleValuesSource valueSource = ExpressionScriptEngine.getDocValueSource(variable, lookup);
                needsScores |= valueSource.needsScores();
                bindings.add(variable, valueSource);
            }
            catch (Exception e) {
                throw ExpressionScriptEngine.convertToScriptException("link error", expr.sourceText, variable, e);
            }
        }
        return new ExpressionScoreScript(expr, bindings, needsScores);
    }

    private static ScriptException convertToScriptException(String message, String source, String portion, Throwable cause) {
        ArrayList<String> stack = new ArrayList<String>();
        stack.add(portion);
        StringBuilder pointer = new StringBuilder();
        if (cause instanceof ParseException) {
            int offset = ((ParseException)cause).getErrorOffset();
            for (int i = 0; i < offset; ++i) {
                pointer.append(' ');
            }
        }
        pointer.append("^---- HERE");
        stack.add(pointer.toString());
        throw new ScriptException(message, cause, stack, source, NAME);
    }

    private static DoubleValuesSource getDocValueSource(String variable, SearchLookup lookup) throws ParseException {
        DoubleValuesSource valueSource;
        String fieldname;
        BaseMappedFieldType fieldType;
        VariableContext[] parts = VariableContext.parse((String)variable);
        if (!parts[0].text.equals("doc")) {
            throw new ParseException("Unknown variable [" + parts[0].text + "]", 0);
        }
        if (parts.length < 2 || parts[1].type != VariableContext.Type.STR_INDEX) {
            throw new ParseException("Variable 'doc' must be used with a specific field like: doc['myfield']", 3);
        }
        String variablename = "value";
        String methodname = null;
        if (parts.length == 3) {
            if (parts[2].type == VariableContext.Type.METHOD) {
                methodname = parts[2].text;
            } else if (parts[2].type == VariableContext.Type.MEMBER) {
                variablename = parts[2].text;
            } else {
                throw new IllegalArgumentException("Only member variables or member methods may be accessed on a field when not accessing the field directly");
            }
        }
        boolean dateAccessor = false;
        if (parts.length > 3) {
            if (parts.length == 4 && ("date".equals(parts[2].text) || "getDate".equals(parts[2].text))) {
                if (parts[3].type == VariableContext.Type.METHOD) {
                    methodname = parts[3].text;
                    dateAccessor = true;
                } else if (parts[3].type == VariableContext.Type.MEMBER) {
                    variablename = parts[3].text;
                    dateAccessor = true;
                }
            }
            if (!dateAccessor) {
                throw new IllegalArgumentException("Variable [" + variable + "] does not follow an allowed format of either doc['field'] or doc['field'].method()");
            }
        }
        if ((fieldType = lookup.fieldType(fieldname = parts[1].text)) == null) {
            throw new ParseException("Field [" + fieldname + "] does not exist in mappings", 5);
        }
        IndexFieldData fieldData = (IndexFieldData)lookup.getForField(fieldType);
        if (fieldType instanceof GeoPointFieldMapper.GeoPointFieldType) {
            valueSource = methodname == null ? GeoField.getVariable(fieldData, fieldname, variablename) : GeoField.getMethod(fieldData, fieldname, methodname);
        } else if (fieldType instanceof DateFieldMapper.DateFieldType) {
            valueSource = dateAccessor ? (methodname == null ? DateObject.getVariable(fieldData, fieldname, variablename) : DateObject.getMethod(fieldData, fieldname, methodname)) : (methodname == null ? DateField.getVariable(fieldData, fieldname, variablename) : DateField.getMethod(fieldData, fieldname, methodname));
        } else if (fieldData instanceof IndexNumericFieldData) {
            valueSource = methodname == null ? NumericField.getVariable(fieldData, fieldname, variablename) : NumericField.getMethod(fieldData, fieldname, methodname);
        } else {
            throw new ParseException("Field [" + fieldname + "] must be numeric, date, or geopoint", 5);
        }
        return valueSource;
    }

    private static void bindFromParams(@Nullable Map<String, Object> params, SimpleBindings bindings, String variable) throws ParseException {
        Object value = params.get(variable);
        if (!(value instanceof Number)) {
            throw new ParseException("Parameter [" + variable + "] must be a numeric type", 0);
        }
        bindings.add(variable, DoubleValuesSource.constant((double)((Number)value).doubleValue()));
    }

    static {
        HashMap<ScriptContext, Function<Expression, Object>> contexts = new HashMap<ScriptContext, Function<Expression, Object>>();
        contexts.put(BucketAggregationScript.CONTEXT, ExpressionScriptEngine::newBucketAggregationScriptFactory);
        contexts.put(BucketAggregationSelectorScript.CONTEXT, expr -> {
            final BucketAggregationScript.Factory factory = ExpressionScriptEngine.newBucketAggregationScriptFactory(expr);
            BucketAggregationSelectorScript.Factory wrappedFactory = parameters -> new BucketAggregationSelectorScript(parameters){

                public boolean execute() {
                    return factory.newInstance(this.getParams()).execute().doubleValue() == 1.0;
                }
            };
            return wrappedFactory;
        });
        contexts.put(FilterScript.CONTEXT, expr -> new FilterScript.Factory((Expression)expr){
            final /* synthetic */ Expression val$expr;
            {
                this.val$expr = expression;
            }

            public boolean isResultDeterministic() {
                return true;
            }

            public FilterScript.LeafFactory newFactory(Map<String, Object> params, SearchLookup lookup) {
                return ExpressionScriptEngine.newFilterScript(this.val$expr, lookup, params);
            }
        });
        contexts.put(ScoreScript.CONTEXT, expr -> new ScoreScript.Factory((Expression)expr){
            final /* synthetic */ Expression val$expr;
            {
                this.val$expr = expression;
            }

            public ScoreScript.LeafFactory newFactory(Map<String, Object> params, SearchLookup lookup, IndexSearcher indexSearcher) {
                return ExpressionScriptEngine.newScoreScript(this.val$expr, lookup, params);
            }

            public boolean isResultDeterministic() {
                return true;
            }
        });
        contexts.put(TermsSetQueryScript.CONTEXT, expr -> (p, lookup) -> ExpressionScriptEngine.newTermsSetQueryScript(expr, lookup, p));
        contexts.put(AggregationScript.CONTEXT, expr -> new AggregationScript.Factory((Expression)expr){
            final /* synthetic */ Expression val$expr;
            {
                this.val$expr = expression;
            }

            public AggregationScript.LeafFactory newFactory(Map<String, Object> params, SearchLookup lookup) {
                return ExpressionScriptEngine.newAggregationScript(this.val$expr, lookup, params);
            }

            public boolean isResultDeterministic() {
                return true;
            }
        });
        contexts.put(NumberSortScript.CONTEXT, expr -> new NumberSortScript.Factory((Expression)expr){
            final /* synthetic */ Expression val$expr;
            {
                this.val$expr = expression;
            }

            public NumberSortScript.LeafFactory newFactory(Map<String, Object> params, SearchLookup lookup) {
                return ExpressionScriptEngine.newSortScript(this.val$expr, lookup, params);
            }

            public boolean isResultDeterministic() {
                return true;
            }
        });
        contexts.put(FieldScript.CONTEXT, expr -> new FieldScript.Factory((Expression)expr){
            final /* synthetic */ Expression val$expr;
            {
                this.val$expr = expression;
            }

            public FieldScript.LeafFactory newFactory(Map<String, Object> params, SearchLookup lookup) {
                return ExpressionScriptEngine.newFieldScript(this.val$expr, lookup, params);
            }

            public boolean isResultDeterministic() {
                return true;
            }
        });
        ExpressionScriptEngine.contexts = Collections.unmodifiableMap(contexts);
    }
}

