/*
 * Decompiled with CFR 0.152.
 */
package com.maxmind.db;

import com.maxmind.db.Buffer;
import com.maxmind.db.CacheKey;
import com.maxmind.db.CachedConstructor;
import com.maxmind.db.CachedCreator;
import com.maxmind.db.ConstructorNotFoundException;
import com.maxmind.db.CtrlData;
import com.maxmind.db.DecodedValue;
import com.maxmind.db.DeserializationException;
import com.maxmind.db.InvalidDatabaseException;
import com.maxmind.db.MaxMindDbConstructor;
import com.maxmind.db.MaxMindDbCreator;
import com.maxmind.db.MaxMindDbIpAddress;
import com.maxmind.db.MaxMindDbNetwork;
import com.maxmind.db.MaxMindDbParameter;
import com.maxmind.db.Network;
import com.maxmind.db.NodeCache;
import com.maxmind.db.ParameterInjection;
import com.maxmind.db.ParameterNotFoundException;
import com.maxmind.db.Type;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.RecordComponent;
import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class Decoder {
    private static final Charset UTF_8 = StandardCharsets.UTF_8;
    private static final int[] POINTER_VALUE_OFFSETS = new int[]{0, 0, 2048, 526336, 0};
    private static final CachedCreator NO_CREATOR = new CachedCreator(null, null);
    private final NodeCache cache;
    private final long pointerBase;
    private final CharsetDecoder utfDecoder = UTF_8.newDecoder();
    private final Buffer buffer;
    private final ConcurrentHashMap<Class<?>, CachedConstructor<?>> constructors;
    private final ConcurrentHashMap<Class<?>, CachedCreator> creators;
    private final InetAddress lookupIp;
    private final Network lookupNetwork;
    private final NodeCache.Loader cacheLoader = this::decode;

    Decoder(NodeCache cache, Buffer buffer, long pointerBase) {
        this(cache, buffer, pointerBase, new ConcurrentHashMap(), new ConcurrentHashMap(), null, null);
    }

    Decoder(NodeCache cache, Buffer buffer, long pointerBase, ConcurrentHashMap<Class<?>, CachedConstructor<?>> constructors) {
        this(cache, buffer, pointerBase, constructors, new ConcurrentHashMap(), null, null);
    }

    Decoder(NodeCache cache, Buffer buffer, long pointerBase, ConcurrentHashMap<Class<?>, CachedConstructor<?>> constructors, ConcurrentHashMap<Class<?>, CachedCreator> creators, InetAddress lookupIp, Network lookupNetwork) {
        this.cache = cache;
        this.pointerBase = pointerBase;
        this.buffer = buffer;
        this.constructors = constructors;
        this.creators = creators;
        this.lookupIp = lookupIp;
        this.lookupNetwork = lookupNetwork;
    }

    <T> T decode(long offset, Class<T> cls) throws IOException {
        if (offset >= this.buffer.capacity()) {
            throw new InvalidDatabaseException("The MaxMind DB file's data section contains bad data: pointer larger than the database.");
        }
        this.buffer.position(offset);
        return cls.cast(this.decode(cls, null).value());
    }

    private <T> DecodedValue decode(CacheKey<T> key) throws IOException {
        long offset = key.offset();
        if (offset >= this.buffer.capacity()) {
            throw new InvalidDatabaseException("The MaxMind DB file's data section contains bad data: pointer larger than the database.");
        }
        this.buffer.position(offset);
        Class<T> cls = key.cls();
        return this.decode(cls, key.type());
    }

    private <T> DecodedValue decode(Class<T> cls, java.lang.reflect.Type genericType) throws IOException {
        int size;
        int ctrlByte = 0xFF & this.buffer.get();
        Type type = Type.fromControlByte(ctrlByte);
        if (type.equals((Object)Type.POINTER)) {
            int pointerSize = (ctrlByte >>> 3 & 3) + 1;
            int base = (byte)(pointerSize == 4 ? 0 : (byte)(ctrlByte & 7));
            int packed = this.decodeInteger(base, pointerSize);
            long pointer = (long)packed + this.pointerBase + (long)POINTER_VALUE_OFFSETS[pointerSize];
            return this.decodePointer(pointer, cls, genericType);
        }
        if (type.equals((Object)Type.EXTENDED)) {
            byte nextByte = this.buffer.get();
            int typeNum = nextByte + 7;
            if (typeNum < 8) {
                throw new InvalidDatabaseException("Something went horribly wrong in the decoder. An extended type resolved to a type number < 8 (" + typeNum + ")");
            }
            type = Type.get(typeNum);
        }
        if ((size = ctrlByte & 0x1F) >= 29) {
            size = switch (size) {
                case 29 -> 29 + (0xFF & this.buffer.get());
                case 30 -> 285 + this.decodeInteger(2);
                default -> 65821 + this.decodeInteger(3);
            };
        }
        return new DecodedValue(this.decodeByType(type, size, cls, genericType));
    }

    DecodedValue decodePointer(long pointer, Class<?> cls, java.lang.reflect.Type genericType) throws IOException {
        long position = this.buffer.position();
        CacheKey key = new CacheKey(pointer, cls, genericType);
        DecodedValue value = this.requiresLookupContext(cls) ? this.decode(key) : this.cache.get(key, this.cacheLoader);
        this.buffer.position(position);
        return value;
    }

    private boolean requiresLookupContext(Class<?> cls) {
        if (cls == null || cls.equals(Object.class) || Map.class.isAssignableFrom(cls) || List.class.isAssignableFrom(cls) || cls.isEnum() || Decoder.isSimpleType(cls)) {
            return false;
        }
        if (this.getCachedCreator(cls) != null) {
            return false;
        }
        CachedConstructor<?> cached = this.getCachedConstructor(cls);
        if (cached == null) {
            cached = this.loadConstructorMetadata(cls);
        }
        return cached.requiresLookupContext();
    }

    private static boolean isSimpleType(Class<?> cls) {
        if (cls.isPrimitive() || cls.isArray()) {
            return true;
        }
        return cls.equals(String.class) || Number.class.isAssignableFrom(cls) || cls.equals(Boolean.class) || cls.equals(Character.class) || cls.equals(BigInteger.class);
    }

    private <T> Object decodeByType(Type type, int size, Class<T> cls, java.lang.reflect.Type genericType) throws IOException {
        switch (type) {
            case MAP: {
                return this.decodeMap(size, cls, genericType);
            }
            case ARRAY: {
                ParameterizedType ptype;
                java.lang.reflect.Type[] actualTypes;
                Class elementClass = Object.class;
                if (genericType instanceof ParameterizedType && (actualTypes = (ptype = (ParameterizedType)genericType).getActualTypeArguments()).length == 1) {
                    elementClass = (Class)actualTypes[0];
                }
                return this.decodeArray(size, cls, elementClass);
            }
            case BOOLEAN: {
                Boolean bool = Decoder.decodeBoolean(size);
                return this.convertValue(bool, cls);
            }
            case UTF8_STRING: {
                String str = this.decodeString(size);
                return this.convertValue(str, cls);
            }
            case DOUBLE: {
                return this.decodeDouble(size);
            }
            case FLOAT: {
                return Float.valueOf(this.decodeFloat(size));
            }
            case BYTES: {
                return this.getByteArray(size);
            }
            case UINT16: {
                return Decoder.coerceFromInt(this.decodeUint16(size), cls);
            }
            case UINT32: {
                return Decoder.coerceFromLong(this.decodeUint32(size), cls);
            }
            case INT32: {
                return Decoder.coerceFromInt(this.decodeInt32(size), cls);
            }
            case UINT64: 
            case UINT128: {
                if (size < 8 && !cls.equals(Object.class)) {
                    return Decoder.coerceFromLong(this.decodeLong(size), cls);
                }
                return Decoder.coerceFromBigInteger(this.decodeBigInteger(size), cls);
            }
        }
        throw new InvalidDatabaseException("Unknown or unexpected type: " + type.name());
    }

    private static Object coerceFromInt(int value, Class<?> target) {
        if (target.equals(Object.class) || target.equals(Integer.TYPE) || target.equals(Integer.class)) {
            return value;
        }
        if (target.equals(Long.TYPE) || target.equals(Long.class)) {
            return (long)value;
        }
        if (target.equals(Short.TYPE) || target.equals(Short.class)) {
            if (value < Short.MIN_VALUE || value > Short.MAX_VALUE) {
                throw new DeserializationException("Value " + value + " out of range for short");
            }
            return (short)value;
        }
        if (target.equals(Byte.TYPE) || target.equals(Byte.class)) {
            if (value < -128 || value > 127) {
                throw new DeserializationException("Value " + value + " out of range for byte");
            }
            return (byte)value;
        }
        if (target.equals(Double.TYPE) || target.equals(Double.class)) {
            return (double)value;
        }
        if (target.equals(Float.TYPE) || target.equals(Float.class)) {
            return Float.valueOf(value);
        }
        if (target.equals(BigInteger.class)) {
            return BigInteger.valueOf(value);
        }
        return value;
    }

    private static Object coerceFromLong(long value, Class<?> target) {
        if (target.equals(Object.class) || target.equals(Long.TYPE) || target.equals(Long.class)) {
            return value;
        }
        if (target.equals(Integer.TYPE) || target.equals(Integer.class)) {
            if (value < Integer.MIN_VALUE || value > Integer.MAX_VALUE) {
                throw new DeserializationException("Value " + value + " out of range for int");
            }
            return (int)value;
        }
        if (target.equals(Short.TYPE) || target.equals(Short.class)) {
            if (value < -32768L || value > 32767L) {
                throw new DeserializationException("Value " + value + " out of range for short");
            }
            return (short)value;
        }
        if (target.equals(Byte.TYPE) || target.equals(Byte.class)) {
            if (value < -128L || value > 127L) {
                throw new DeserializationException("Value " + value + " out of range for byte");
            }
            return (byte)value;
        }
        if (target.equals(Double.TYPE) || target.equals(Double.class)) {
            return (double)value;
        }
        if (target.equals(Float.TYPE) || target.equals(Float.class)) {
            return Float.valueOf(value);
        }
        if (target.equals(BigInteger.class)) {
            return BigInteger.valueOf(value);
        }
        return value;
    }

    private static Object coerceFromBigInteger(BigInteger value, Class<?> target) {
        if (target.equals(Object.class) || target.equals(BigInteger.class)) {
            return value;
        }
        if (target.equals(Long.TYPE) || target.equals(Long.class)) {
            if (value.compareTo(BigInteger.valueOf(Long.MIN_VALUE)) < 0 || value.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) > 0) {
                throw new DeserializationException("Value " + String.valueOf(value) + " out of range for long");
            }
            return value.longValue();
        }
        if (target.equals(Integer.TYPE) || target.equals(Integer.class)) {
            if (value.compareTo(BigInteger.valueOf(Integer.MIN_VALUE)) < 0 || value.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) > 0) {
                throw new DeserializationException("Value " + String.valueOf(value) + " out of range for int");
            }
            return value.intValue();
        }
        if (target.equals(Short.TYPE) || target.equals(Short.class)) {
            if (value.compareTo(BigInteger.valueOf(-32768L)) < 0 || value.compareTo(BigInteger.valueOf(32767L)) > 0) {
                throw new DeserializationException("Value " + String.valueOf(value) + " out of range for short");
            }
            return value.shortValue();
        }
        if (target.equals(Byte.TYPE) || target.equals(Byte.class)) {
            if (value.compareTo(BigInteger.valueOf(-128L)) < 0 || value.compareTo(BigInteger.valueOf(127L)) > 0) {
                throw new DeserializationException("Value " + String.valueOf(value) + " out of range for byte");
            }
            return value.byteValue();
        }
        if (target.equals(Double.TYPE) || target.equals(Double.class)) {
            return value.doubleValue();
        }
        if (target.equals(Float.TYPE) || target.equals(Float.class)) {
            return Float.valueOf(value.floatValue());
        }
        return value;
    }

    private String decodeString(long size) throws CharacterCodingException {
        long oldLimit = this.buffer.limit();
        this.buffer.limit(this.buffer.position() + size);
        String s = this.buffer.decode(this.utfDecoder);
        this.buffer.limit(oldLimit);
        return s;
    }

    private int decodeUint16(int size) {
        return this.decodeInteger(size);
    }

    private int decodeInt32(int size) {
        return this.decodeInteger(size);
    }

    private long decodeLong(int size) {
        return Decoder.decodeLong(this.buffer, 0, size);
    }

    static long decodeLong(Buffer buffer, int base, int size) {
        long integer = base;
        for (int i = 0; i < size; ++i) {
            integer = integer << 8 | (long)(buffer.get() & 0xFF);
        }
        return integer;
    }

    private long decodeUint32(int size) {
        return this.decodeLong(size);
    }

    private int decodeInteger(int size) {
        return this.decodeInteger(0, size);
    }

    private int decodeInteger(int base, int size) {
        return Decoder.decodeInteger(this.buffer, base, size);
    }

    static int decodeInteger(Buffer buffer, int base, int size) {
        int integer = base;
        for (int i = 0; i < size; ++i) {
            integer = integer << 8 | buffer.get() & 0xFF;
        }
        return integer;
    }

    private BigInteger decodeBigInteger(int size) {
        byte[] bytes = this.getByteArray(size);
        return new BigInteger(1, bytes);
    }

    private double decodeDouble(int size) throws InvalidDatabaseException {
        if (size != 8) {
            throw new InvalidDatabaseException("The MaxMind DB file's data section contains bad data: invalid size of double.");
        }
        return this.buffer.getDouble();
    }

    private float decodeFloat(int size) throws InvalidDatabaseException {
        if (size != 4) {
            throw new InvalidDatabaseException("The MaxMind DB file's data section contains bad data: invalid size of float.");
        }
        return this.buffer.getFloat();
    }

    private static boolean decodeBoolean(int size) throws InvalidDatabaseException {
        return switch (size) {
            case 0 -> false;
            case 1 -> true;
            default -> throw new InvalidDatabaseException("The MaxMind DB file's data section contains bad data: invalid size of boolean.");
        };
    }

    private <T, V> List<V> decodeArray(int size, Class<T> cls, Class<V> elementClass) throws IOException {
        List<Object> array;
        if (!List.class.isAssignableFrom(cls) && !cls.equals(Object.class)) {
            throw new DeserializationException("Unable to deserialize an array into an " + String.valueOf(cls));
        }
        if (cls.equals(List.class) || cls.equals(Object.class)) {
            array = new ArrayList<V>(size);
        } else {
            Constructor<T> constructor;
            try {
                constructor = cls.getConstructor(Integer.TYPE);
            }
            catch (NoSuchMethodException e) {
                throw new DeserializationException("No constructor found for the List: " + e.getMessage(), e);
            }
            Object[] parameters = new Object[]{size};
            try {
                List array2 = (List)constructor.newInstance(parameters);
                array = array2;
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new DeserializationException("Error creating list: " + e.getMessage(), e);
            }
        }
        for (int i = 0; i < size; ++i) {
            Object e = this.decode(elementClass, null).value();
            array.add(elementClass.cast(e));
        }
        return array;
    }

    private <T> Object decodeMap(int size, Class<T> cls, java.lang.reflect.Type genericType) throws IOException {
        if (Map.class.isAssignableFrom(cls) || cls.equals(Object.class)) {
            ParameterizedType ptype;
            java.lang.reflect.Type[] actualTypes;
            Class valueClass = Object.class;
            if (genericType instanceof ParameterizedType && (actualTypes = (ptype = (ParameterizedType)genericType).getActualTypeArguments()).length == 2) {
                Class keyClass = (Class)actualTypes[0];
                if (!keyClass.equals(String.class)) {
                    throw new DeserializationException("Map keys must be strings.");
                }
                valueClass = (Class)actualTypes[1];
            }
            return this.decodeMapIntoMap(cls, size, valueClass);
        }
        return this.decodeMapIntoObject(size, cls);
    }

    private <T, V> Map<String, V> decodeMapIntoMap(Class<T> cls, int size, Class<V> valueClass) throws IOException {
        Map<String, V> map;
        if (cls.equals(Map.class) || cls.equals(Object.class)) {
            map = new HashMap<String, V>(size);
        } else {
            Constructor<T> constructor;
            try {
                constructor = cls.getConstructor(Integer.TYPE);
            }
            catch (NoSuchMethodException e) {
                throw new DeserializationException("No constructor found for the Map: " + e.getMessage(), e);
            }
            Object[] parameters = new Object[]{size};
            try {
                Map map2 = (Map)constructor.newInstance(parameters);
                map = map2;
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new DeserializationException("Error creating map: " + e.getMessage(), e);
            }
        }
        for (int i = 0; i < size; ++i) {
            String key = (String)this.decode(String.class, null).value();
            Object value = this.decode(valueClass, null).value();
            try {
                map.put(key, valueClass.cast(value));
                continue;
            }
            catch (ClassCastException e) {
                throw new DeserializationException("Error creating map entry for '" + key + "': " + e.getMessage(), e);
            }
        }
        return map;
    }

    private <T> CachedConstructor<T> loadConstructorMetadata(Class<T> cls) {
        CachedConstructor<T> cachedConstructor;
        CachedConstructor<T> existing;
        int i;
        CachedConstructor<T> cached = this.getCachedConstructor(cls);
        if (cached != null) {
            return cached;
        }
        Constructor<T> constructor = Decoder.findConstructor(cls);
        Class<?>[] parameterTypes = constructor.getParameterTypes();
        java.lang.reflect.Type[] parameterGenericTypes = constructor.getGenericParameterTypes();
        HashMap<String, Integer> parameterIndexes = new HashMap<String, Integer>();
        Object[] parameterDefaults = new Object[constructor.getParameterCount()];
        ParameterInjection[] parameterInjections = new ParameterInjection[constructor.getParameterCount()];
        boolean requiresContext = false;
        Annotation[][] annotations = constructor.getParameterAnnotations();
        for (i = 0; i < constructor.getParameterCount(); ++i) {
            String name;
            ParameterInjection injection;
            parameterInjections[i] = injection = Decoder.getParameterInjection(annotations[i]);
            MaxMindDbParameter parameterAnnotation = Decoder.getParameterAnnotation(annotations[i]);
            if (injection != ParameterInjection.NONE) {
                requiresContext = true;
                if (parameterAnnotation != null) {
                    throw new DeserializationException("Parameter index " + i + " on class " + cls.getName() + " cannot have both @MaxMindDbParameter and a lookup context annotation.");
                }
                Decoder.validateInjectionTarget(cls, i, parameterTypes[i], injection);
                continue;
            }
            if (parameterAnnotation != null && parameterAnnotation.useDefault()) {
                parameterDefaults[i] = Decoder.parseDefault(parameterAnnotation.defaultValue(), parameterTypes[i]);
            }
            String string = name = parameterAnnotation != null ? parameterAnnotation.name() : null;
            if (name == null) {
                if (cls.isRecord()) {
                    name = cls.getRecordComponents()[i].getName();
                } else {
                    Parameter param = constructor.getParameters()[i];
                    if (param.isNamePresent()) {
                        name = param.getName();
                    } else {
                        throw new ParameterNotFoundException("Parameter name for index " + i + " on class " + cls.getName() + " is not available. Annotate with @MaxMindDbParameter or compile with -parameters.");
                    }
                }
            }
            parameterIndexes.put(name, i);
        }
        if (!requiresContext) {
            for (i = 0; i < parameterTypes.length; ++i) {
                if (parameterInjections[i] != ParameterInjection.NONE || !this.shouldInstantiateFromContext(parameterTypes[i])) continue;
                requiresContext = true;
                break;
            }
        }
        return (existing = this.constructors.putIfAbsent(cls, cachedConstructor = new CachedConstructor<T>(constructor, parameterTypes, parameterGenericTypes, parameterIndexes, parameterDefaults, parameterInjections, requiresContext))) != null ? existing : cachedConstructor;
    }

    private <T> Object decodeMapIntoObject(int size, Class<T> cls) throws IOException {
        int i;
        CachedConstructor<T> cachedConstructor = this.loadConstructorMetadata(cls);
        Constructor<T> constructor = cachedConstructor.constructor();
        Class<?>[] parameterTypes = cachedConstructor.parameterTypes();
        java.lang.reflect.Type[] parameterGenericTypes = cachedConstructor.parameterGenericTypes();
        Map<String, Integer> parameterIndexes = cachedConstructor.parameterIndexes();
        Object[] parameterDefaults = cachedConstructor.parameterDefaults();
        ParameterInjection[] parameterInjections = cachedConstructor.parameterInjections();
        Object[] parameters = new Object[parameterTypes.length];
        for (i = 0; i < size; ++i) {
            String key = (String)this.decode(String.class, null).value();
            Integer parameterIndex = parameterIndexes.get(key);
            if (parameterIndex == null) {
                long offset = this.nextValueOffset(this.buffer.position(), 1);
                this.buffer.position(offset);
                continue;
            }
            parameters[parameterIndex.intValue()] = this.decode(parameterTypes[parameterIndex], parameterGenericTypes[parameterIndex]).value();
        }
        for (i = 0; i < parameters.length; ++i) {
            if (parameterInjections[i] != ParameterInjection.NONE) {
                parameters[i] = this.injectParameter(parameterInjections[i], parameterTypes[i]);
                continue;
            }
            if (parameters[i] != null) continue;
            if (parameterDefaults[i] != null) {
                parameters[i] = parameterDefaults[i];
                continue;
            }
            if (!this.shouldInstantiateFromContext(parameterTypes[i])) continue;
            parameters[i] = this.instantiateWithLookupContext(parameterTypes[i]);
        }
        try {
            return constructor.newInstance(parameters);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new DeserializationException("Error creating object: " + e.getMessage(), e);
        }
        catch (IllegalArgumentException e) {
            StringBuilder sbErrors = new StringBuilder();
            for (String key : parameterIndexes.keySet()) {
                Integer index = parameterIndexes.get(key);
                if (parameters[index] == null && parameterTypes[index].isPrimitive()) {
                    sbErrors.append(" null value for primitive ").append(parameterTypes[index].getName()).append(" parameter '").append(key).append("'.");
                    continue;
                }
                if (parameters[index] == null || Decoder.isAssignableType(parameters[index].getClass(), parameterTypes[index])) continue;
                sbErrors.append(" argument type mismatch in ").append(key).append(" MMDB Type: ").append(parameters[index].getClass().getCanonicalName()).append(" Java Type: ").append(parameterTypes[index].getCanonicalName()).append(".");
            }
            throw new DeserializationException("Error creating object of type: " + cls.getSimpleName() + " -" + String.valueOf(sbErrors), e);
        }
    }

    private static boolean isAssignableType(Class<?> actual, Class<?> expected) {
        if (expected.isAssignableFrom(actual)) {
            return true;
        }
        if (expected.isPrimitive()) {
            return actual.equals(Decoder.boxedType(expected));
        }
        return false;
    }

    private static Class<?> boxedType(Class<?> primitive) {
        if (primitive == Boolean.TYPE) {
            return Boolean.class;
        }
        if (primitive == Byte.TYPE) {
            return Byte.class;
        }
        if (primitive == Short.TYPE) {
            return Short.class;
        }
        if (primitive == Integer.TYPE) {
            return Integer.class;
        }
        if (primitive == Long.TYPE) {
            return Long.class;
        }
        if (primitive == Float.TYPE) {
            return Float.class;
        }
        if (primitive == Double.TYPE) {
            return Double.class;
        }
        if (primitive == Character.TYPE) {
            return Character.class;
        }
        return primitive;
    }

    private boolean shouldInstantiateFromContext(Class<?> parameterType) {
        if (parameterType == null || parameterType.isPrimitive() || parameterType.isEnum() || Decoder.isSimpleType(parameterType) || Map.class.isAssignableFrom(parameterType) || List.class.isAssignableFrom(parameterType)) {
            return false;
        }
        return this.requiresLookupContext(parameterType);
    }

    private Object instantiateWithLookupContext(Class<?> parameterType) {
        CachedConstructor<?> metadata = this.loadConstructorMetadata(parameterType);
        if (metadata == null || !metadata.requiresLookupContext()) {
            return null;
        }
        Constructor<?> ctor = metadata.constructor();
        Class<?>[] types = metadata.parameterTypes();
        Object[] defaults = metadata.parameterDefaults();
        ParameterInjection[] injections = metadata.parameterInjections();
        Object[] args = new Object[types.length];
        for (int i = 0; i < args.length; ++i) {
            args[i] = injections[i] != ParameterInjection.NONE ? this.injectParameter(injections[i], types[i]) : (defaults[i] != null ? defaults[i] : (types[i].isPrimitive() ? Decoder.primitiveDefault(types[i]) : null));
        }
        try {
            return ctor.newInstance(args);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new DeserializationException("Error creating object of type: " + parameterType.getName(), e);
        }
    }

    private static Object primitiveDefault(Class<?> type) {
        if (type.equals(Boolean.TYPE)) {
            return false;
        }
        if (type.equals(Byte.TYPE)) {
            return (byte)0;
        }
        if (type.equals(Short.TYPE)) {
            return (short)0;
        }
        if (type.equals(Integer.TYPE)) {
            return 0;
        }
        if (type.equals(Long.TYPE)) {
            return 0L;
        }
        if (type.equals(Float.TYPE)) {
            return Float.valueOf(0.0f);
        }
        if (type.equals(Double.TYPE)) {
            return 0.0;
        }
        if (type.equals(Character.TYPE)) {
            return Character.valueOf('\u0000');
        }
        return null;
    }

    private Object injectParameter(ParameterInjection injection, Class<?> parameterType) {
        return switch (injection) {
            default -> throw new IncompatibleClassChangeError();
            case ParameterInjection.IP_ADDRESS -> this.getLookupIpValue(parameterType);
            case ParameterInjection.NETWORK -> this.getLookupNetworkValue(parameterType);
            case ParameterInjection.NONE -> null;
        };
    }

    private Object getLookupIpValue(Class<?> parameterType) {
        if (this.lookupIp == null) {
            throw new DeserializationException("Cannot inject lookup IP address because no lookup context is available.");
        }
        if (String.class.equals(parameterType)) {
            return this.lookupIp.getHostAddress();
        }
        if (InetAddress.class.isAssignableFrom(parameterType)) {
            return this.lookupIp;
        }
        throw new DeserializationException("Unsupported parameter type " + parameterType.getName() + " for @MaxMindDbIpAddress; expected java.net.InetAddress or java.lang.String.");
    }

    private Object getLookupNetworkValue(Class<?> parameterType) {
        if (this.lookupNetwork == null) {
            throw new DeserializationException("Cannot inject lookup network because no lookup context is available.");
        }
        if (String.class.equals(parameterType)) {
            return this.lookupNetwork.toString();
        }
        if (Network.class.isAssignableFrom(parameterType)) {
            return this.lookupNetwork;
        }
        throw new DeserializationException("Unsupported parameter type " + parameterType.getName() + " for @MaxMindDbNetwork; expected com.maxmind.db.Network or java.lang.String.");
    }

    private <T> CachedConstructor<T> getCachedConstructor(Class<T> cls) {
        CachedConstructor<?> result = this.constructors.get(cls);
        return result;
    }

    private static <T> Constructor<T> findConstructor(Class<T> cls) throws ConstructorNotFoundException {
        Constructor<?>[] constructors;
        for (Constructor<?> constructor : constructors = cls.getConstructors()) {
            if (constructor.getAnnotation(MaxMindDbConstructor.class) == null) continue;
            Constructor<?> selected = constructor;
            return selected;
        }
        if (cls.isRecord()) {
            try {
                Constructor<T> c;
                RecordComponent[] components = cls.getRecordComponents();
                Class[] types = new Class[components.length];
                for (int i = 0; i < components.length; ++i) {
                    types[i] = components[i].getType();
                }
                Constructor<T> selected = c = cls.getDeclaredConstructor(types);
                return selected;
            }
            catch (NoSuchMethodException components) {
                // empty catch block
            }
        }
        if (constructors.length == 1) {
            Constructor<?> only;
            Constructor<?> selected = only = constructors[0];
            return selected;
        }
        throw new ConstructorNotFoundException("No usable constructor on class " + cls.getName() + ". Annotate a constructor with MaxMindDbConstructor, provide a record canonical constructor, or a single public constructor.");
    }

    private static MaxMindDbParameter getParameterAnnotation(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            if (!annotation.annotationType().equals(MaxMindDbParameter.class)) continue;
            return (MaxMindDbParameter)annotation;
        }
        return null;
    }

    private static ParameterInjection getParameterInjection(Annotation[] annotations) {
        ParameterInjection injection = ParameterInjection.NONE;
        for (Annotation annotation : annotations) {
            Class<? extends Annotation> type = annotation.annotationType();
            if (type.equals(MaxMindDbIpAddress.class)) {
                if (injection != ParameterInjection.NONE) {
                    throw new DeserializationException("Constructor parameters may have at most one lookup context annotation.");
                }
                injection = ParameterInjection.IP_ADDRESS;
                continue;
            }
            if (!type.equals(MaxMindDbNetwork.class)) continue;
            if (injection != ParameterInjection.NONE) {
                throw new DeserializationException("Constructor parameters may have at most one lookup context annotation.");
            }
            injection = ParameterInjection.NETWORK;
        }
        return injection;
    }

    private static void validateInjectionTarget(Class<?> cls, int parameterIndex, Class<?> parameterType, ParameterInjection injection) {
        if (injection == ParameterInjection.IP_ADDRESS) {
            if (!InetAddress.class.isAssignableFrom(parameterType) && !String.class.equals(parameterType)) {
                throw new DeserializationException("Parameter index " + parameterIndex + " on class " + cls.getName() + " annotated with @MaxMindDbIpAddress must be of type java.net.InetAddress or java.lang.String.");
            }
        } else if (injection == ParameterInjection.NETWORK && !Network.class.isAssignableFrom(parameterType) && !String.class.equals(parameterType)) {
            throw new DeserializationException("Parameter index " + parameterIndex + " on class " + cls.getName() + " annotated with @MaxMindDbNetwork must be of type com.maxmind.db.Network or java.lang.String.");
        }
    }

    private Object convertValue(Object value, Class<?> targetType) {
        if (value == null || targetType == null || targetType == Object.class || targetType.isInstance(value)) {
            return value;
        }
        CachedCreator creator = this.getCachedCreator(targetType);
        if (creator == null) {
            return value;
        }
        if (!creator.parameterType().isInstance(value)) {
            return value;
        }
        try {
            return creator.method().invoke(null, value);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new DeserializationException("Error invoking creator method " + creator.method().getName() + " on class " + targetType.getName(), e);
        }
    }

    private CachedCreator getCachedCreator(Class<?> cls) {
        CachedCreator cached = this.creators.get(cls);
        if (cached == NO_CREATOR) {
            return null;
        }
        if (cached != null) {
            return cached;
        }
        CachedCreator creator = Decoder.findCreatorMethod(cls);
        this.creators.putIfAbsent(cls, creator != null ? creator : NO_CREATOR);
        return creator;
    }

    private static CachedCreator findCreatorMethod(Class<?> cls) {
        Method[] methods;
        for (Method method : methods = cls.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(MaxMindDbCreator.class)) continue;
            if (!Modifier.isStatic(method.getModifiers())) {
                throw new DeserializationException("Creator method " + method.getName() + " on class " + cls.getName() + " must be static.");
            }
            if (method.getParameterCount() != 1) {
                throw new DeserializationException("Creator method " + method.getName() + " on class " + cls.getName() + " must have exactly one parameter.");
            }
            if (!cls.isAssignableFrom(method.getReturnType())) {
                throw new DeserializationException("Creator method " + method.getName() + " on class " + cls.getName() + " must return " + cls.getName() + " or a subtype.");
            }
            return new CachedCreator(method, method.getParameterTypes()[0]);
        }
        return null;
    }

    private static Object parseDefault(String value, Class<?> target) {
        try {
            if (target.equals(Boolean.TYPE) || target.equals(Boolean.class)) {
                return value.isEmpty() ? false : Boolean.parseBoolean(value);
            }
            if (target.equals(Byte.TYPE) || target.equals(Byte.class)) {
                int v;
                int n = v = value.isEmpty() ? 0 : Integer.parseInt(value);
                if (v < -128 || v > 127) {
                    throw new DeserializationException("Default value out of range for byte");
                }
                return (byte)v;
            }
            if (target.equals(Short.TYPE) || target.equals(Short.class)) {
                int v;
                int n = v = value.isEmpty() ? 0 : Integer.parseInt(value);
                if (v < Short.MIN_VALUE || v > Short.MAX_VALUE) {
                    throw new DeserializationException("Default value out of range for short");
                }
                return (short)v;
            }
            if (target.equals(Integer.TYPE) || target.equals(Integer.class)) {
                return value.isEmpty() ? 0 : Integer.parseInt(value);
            }
            if (target.equals(Long.TYPE) || target.equals(Long.class)) {
                return value.isEmpty() ? 0L : Long.parseLong(value);
            }
            if (target.equals(Float.TYPE) || target.equals(Float.class)) {
                return Float.valueOf(value.isEmpty() ? 0.0f : Float.parseFloat(value));
            }
            if (target.equals(Double.TYPE) || target.equals(Double.class)) {
                return value.isEmpty() ? 0.0 : Double.parseDouble(value);
            }
            if (target.equals(String.class)) {
                return value;
            }
        }
        catch (NumberFormatException e) {
            throw new DeserializationException("Invalid default '" + value + "' for type " + target.getSimpleName(), e);
        }
        throw new DeserializationException("Defaults are only supported for primitives, boxed types, and String.");
    }

    private long nextValueOffset(long offset, int numberToSkip) throws InvalidDatabaseException {
        if (numberToSkip == 0) {
            return offset;
        }
        CtrlData ctrlData = this.getCtrlData(offset);
        int ctrlByte = ctrlData.ctrlByte();
        int size = ctrlData.size();
        offset = ctrlData.offset();
        Type type = ctrlData.type();
        switch (type) {
            case POINTER: {
                int pointerSize = (ctrlByte >>> 3 & 3) + 1;
                offset += (long)pointerSize;
                break;
            }
            case MAP: {
                numberToSkip += 2 * size;
                break;
            }
            case ARRAY: {
                numberToSkip += size;
                break;
            }
            case BOOLEAN: {
                break;
            }
            default: {
                offset += (long)size;
            }
        }
        return this.nextValueOffset(offset, numberToSkip - 1);
    }

    private CtrlData getCtrlData(long offset) throws InvalidDatabaseException {
        int size;
        if (offset >= this.buffer.capacity()) {
            throw new InvalidDatabaseException("The MaxMind DB file's data section contains bad data: pointer larger than the database.");
        }
        this.buffer.position(offset);
        int ctrlByte = 0xFF & this.buffer.get();
        ++offset;
        Type type = Type.fromControlByte(ctrlByte);
        if (type.equals((Object)Type.EXTENDED)) {
            byte nextByte = this.buffer.get();
            int typeNum = nextByte + 7;
            if (typeNum < 8) {
                throw new InvalidDatabaseException("Something went horribly wrong in the decoder. An extended type resolved to a type number < 8 (" + typeNum + ")");
            }
            type = Type.get(typeNum);
            ++offset;
        }
        if ((size = ctrlByte & 0x1F) >= 29) {
            int bytesToRead = size - 28;
            offset += (long)bytesToRead;
            size = switch (size) {
                case 29 -> 29 + (0xFF & this.buffer.get());
                case 30 -> 285 + this.decodeInteger(2);
                default -> 65821 + this.decodeInteger(3);
            };
        }
        return new CtrlData(type, ctrlByte, offset, size);
    }

    private byte[] getByteArray(int length) {
        return Decoder.getByteArray(this.buffer, length);
    }

    private static byte[] getByteArray(Buffer buffer, int length) {
        byte[] bytes = new byte[length];
        buffer.get(bytes);
        return bytes;
    }
}

