/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.admin.cluster.allocation;

import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.admin.cluster.allocation.ClusterAllocationExplainAction;
import io.skylite.core.action.admin.cluster.allocation.ClusterAllocationExplainRequest;
import io.skylite.core.action.admin.cluster.allocation.ClusterAllocationExplainResponse;
import io.skylite.core.action.admin.cluster.allocation.ClusterAllocationExplanation;
import io.skylite.core.action.spi.ActionProvider;
import io.skylite.core.action.support.TransportAction;
import io.skylite.core.action.support.clustermanager.TransportClusterManagerNodeAction;
import io.skylite.core.cluster.ClusterInfo;
import io.skylite.core.cluster.ClusterInfoService;
import io.skylite.core.cluster.block.ClusterBlockException;
import io.skylite.core.cluster.block.ClusterBlockLevel;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.cluster.routing.RoutingNodes;
import io.skylite.core.cluster.routing.ShardRouting;
import io.skylite.core.cluster.routing.allocation.RoutingAllocation;
import io.skylite.core.cluster.routing.allocation.ShardAllocationDecision;
import io.skylite.core.cluster.routing.allocation.decider.AllocationDeciders;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportService;
import java.io.IOException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.cluster.routing.allocation.AllocationService;
import org.opensearch.snapshots.SnapshotsInfoService;

public class TransportClusterAllocationExplainAction
extends TransportClusterManagerNodeAction<ClusterAllocationExplainRequest, ClusterAllocationExplainResponse> {
    private static final Logger logger = LogManager.getLogger(TransportClusterAllocationExplainAction.class);
    private final ClusterInfoService clusterInfoService;
    private final SnapshotsInfoService snapshotsInfoService;
    private final AllocationDeciders allocationDeciders;
    private final AllocationService allocationService;

    @Inject
    public TransportClusterAllocationExplainAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, ClusterInfoService clusterInfoService, SnapshotsInfoService snapshotsInfoService, AllocationDeciders allocationDeciders, AllocationService allocationService) {
        super("cluster:monitor/allocation/explain", transportService, clusterService, threadPool, actionFilters, ClusterAllocationExplainRequest::new, indexNameExpressionResolver);
        this.clusterInfoService = clusterInfoService;
        this.snapshotsInfoService = snapshotsInfoService;
        this.allocationDeciders = allocationDeciders;
        this.allocationService = allocationService;
    }

    protected String executor() {
        return "management";
    }

    protected ClusterAllocationExplainResponse read(StreamInput in) throws IOException {
        return new ClusterAllocationExplainResponse(in);
    }

    protected ClusterBlockException checkBlock(ClusterAllocationExplainRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    protected void clusterManagerOperation(ClusterAllocationExplainRequest request, ClusterState state, ActionListener<ClusterAllocationExplainResponse> listener) {
        RoutingNodes routingNodes = state.getRoutingNodes();
        ClusterInfo clusterInfo = this.clusterInfoService.getClusterInfo();
        RoutingAllocation allocation = new RoutingAllocation(this.allocationDeciders, routingNodes, state, clusterInfo, this.snapshotsInfoService.snapshotShardSizes(), System.nanoTime());
        ShardRouting shardRouting = TransportClusterAllocationExplainAction.findShardToExplain(request, allocation);
        logger.debug("explaining the allocation for [{}], found shard [{}]", (Object)request, (Object)shardRouting);
        ClusterAllocationExplanation cae = TransportClusterAllocationExplainAction.explainShard(shardRouting, allocation, (ClusterInfo)(request.includeDiskInfo() ? clusterInfo : null), request.includeYesDecisions(), this.allocationService);
        listener.onResponse((Object)new ClusterAllocationExplainResponse(cae));
    }

    public static ClusterAllocationExplanation explainShard(ShardRouting shardRouting, RoutingAllocation allocation, ClusterInfo clusterInfo, boolean includeYesDecisions, AllocationService allocationService) {
        allocation.setDebugMode(includeYesDecisions ? RoutingAllocation.DebugMode.ON : RoutingAllocation.DebugMode.EXCLUDE_YES_DECISIONS);
        ShardAllocationDecision shardDecision = shardRouting.initializing() || shardRouting.relocating() ? ShardAllocationDecision.NOT_TAKEN : allocationService.explainShardAllocation(shardRouting, allocation);
        return new ClusterAllocationExplanation(shardRouting, shardRouting.currentNodeId() != null ? allocation.nodes().get(shardRouting.currentNodeId()) : null, shardRouting.relocatingNodeId() != null ? allocation.nodes().get(shardRouting.relocatingNodeId()) : null, clusterInfo, shardDecision);
    }

    public static ShardRouting findShardToExplain(ClusterAllocationExplainRequest request, RoutingAllocation allocation) {
        ShardRouting foundShard = null;
        if (request.useAnyUnassignedShard()) {
            RoutingNodes.UnassignedShards.UnassignedIterator ui = allocation.routingNodes().unassigned().iterator();
            if (ui.hasNext()) {
                foundShard = ui.next();
            }
            if (foundShard == null) {
                throw new IllegalArgumentException("unable to find any unassigned shards to explain [" + String.valueOf(request) + "]");
            }
        } else {
            String index = request.getIndex();
            int shard = request.getShard();
            if (request.isPrimary().booleanValue()) {
                DiscoveryNode primaryNode;
                foundShard = allocation.routingTable().shardRoutingTable(index, shard).primaryShard();
                if (request.getCurrentNode() != null && !(primaryNode = allocation.nodes().resolveNode(request.getCurrentNode())).getId().equals(foundShard.currentNodeId())) {
                    throw new IllegalArgumentException("unable to find primary shard assigned to node [" + request.getCurrentNode() + "]");
                }
            } else {
                List replicaShardRoutings = allocation.routingTable().shardRoutingTable(index, shard).replicaShards();
                if (request.getCurrentNode() != null) {
                    DiscoveryNode replicaNode = allocation.nodes().resolveNode(request.getCurrentNode());
                    for (ShardRouting replica : replicaShardRoutings) {
                        if (!replicaNode.getId().equals(replica.currentNodeId())) continue;
                        foundShard = replica;
                        break;
                    }
                    if (foundShard == null) {
                        throw new IllegalArgumentException("unable to find a replica shard assigned to node [" + request.getCurrentNode() + "]");
                    }
                } else if (replicaShardRoutings.size() > 0) {
                    foundShard = (ShardRouting)replicaShardRoutings.get(0);
                    for (ShardRouting replica : replicaShardRoutings) {
                        if (replica.unassigned()) {
                            foundShard = replica;
                            break;
                        }
                        if (!replica.started() || !foundShard.initializing() && !foundShard.relocating()) continue;
                        foundShard = replica;
                    }
                }
            }
        }
        if (foundShard == null) {
            throw new IllegalArgumentException("unable to find any shards to explain [" + String.valueOf(request) + "] in the routing table");
        }
        return foundShard;
    }

    public static final class ActionProviderImpl
    implements ActionProvider {
        public ActionType<? extends ActionResponse> getInstance() {
            return ClusterAllocationExplainAction.INSTANCE;
        }

        public Class<? extends TransportAction<? extends ActionRequest, ? extends ActionResponse>> getTransportAction() {
            return TransportClusterAllocationExplainAction.class;
        }
    }
}

