/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.admin.cluster.decommission.awareness.delete;

import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.admin.cluster.decommission.awareness.delete.DeleteDecommissionStateAction;
import io.skylite.core.action.admin.cluster.decommission.awareness.delete.DeleteDecommissionStateRequest;
import io.skylite.core.action.admin.cluster.decommission.awareness.delete.DeleteDecommissionStateResponse;
import io.skylite.core.action.spi.ActionProvider;
import io.skylite.core.action.support.TransportAction;
import io.skylite.core.action.support.clustermanager.TransportClusterManagerNodeAction;
import io.skylite.core.cluster.block.ClusterBlockException;
import io.skylite.core.cluster.block.ClusterBlockLevel;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportService;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.cluster.decommission.DecommissionService;

public class TransportDeleteDecommissionStateAction
extends TransportClusterManagerNodeAction<DeleteDecommissionStateRequest, DeleteDecommissionStateResponse> {
    private static final Logger logger = LogManager.getLogger(TransportDeleteDecommissionStateAction.class);
    private final DecommissionService decommissionService;

    @Inject
    public TransportDeleteDecommissionStateAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, DecommissionService decommissionService) {
        super("cluster:admin/decommission/awareness/delete", transportService, clusterService, threadPool, actionFilters, DeleteDecommissionStateRequest::new, indexNameExpressionResolver);
        this.decommissionService = decommissionService;
    }

    protected String executor() {
        return "same";
    }

    protected DeleteDecommissionStateResponse read(StreamInput in) throws IOException {
        return new DeleteDecommissionStateResponse(in);
    }

    protected ClusterBlockException checkBlock(DeleteDecommissionStateRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    protected void clusterManagerOperation(DeleteDecommissionStateRequest request, ClusterState state, ActionListener<DeleteDecommissionStateResponse> listener) {
        logger.info("Received delete decommission Request [{}]", (Object)request);
        this.decommissionService.startRecommissionAction(listener);
    }

    public static final class ActionProviderImpl
    implements ActionProvider {
        public ActionType<? extends ActionResponse> getInstance() {
            return DeleteDecommissionStateAction.INSTANCE;
        }

        public Class<? extends TransportAction<? extends ActionRequest, ? extends ActionResponse>> getTransportAction() {
            return TransportDeleteDecommissionStateAction.class;
        }
    }
}

