/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.admin.cluster.decommission.awareness.put;

import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.admin.cluster.decommission.awareness.put.DecommissionAction;
import io.skylite.core.action.admin.cluster.decommission.awareness.put.DecommissionRequest;
import io.skylite.core.action.admin.cluster.decommission.awareness.put.DecommissionResponse;
import io.skylite.core.action.spi.ActionProvider;
import io.skylite.core.action.support.TransportAction;
import io.skylite.core.action.support.clustermanager.TransportClusterManagerNodeAction;
import io.skylite.core.cluster.block.ClusterBlockException;
import io.skylite.core.cluster.block.ClusterBlockLevel;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportService;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.cluster.decommission.DecommissionService;

public class TransportDecommissionAction
extends TransportClusterManagerNodeAction<DecommissionRequest, DecommissionResponse> {
    private static final Logger logger = LogManager.getLogger(TransportDecommissionAction.class);
    private final DecommissionService decommissionService;

    @Inject
    public TransportDecommissionAction(TransportService transportService, ClusterService clusterService, DecommissionService decommissionService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:admin/decommission/awareness/put", transportService, clusterService, threadPool, actionFilters, DecommissionRequest::new, indexNameExpressionResolver);
        this.decommissionService = decommissionService;
    }

    protected String executor() {
        return "same";
    }

    protected DecommissionResponse read(StreamInput in) throws IOException {
        return new DecommissionResponse(in);
    }

    protected ClusterBlockException checkBlock(DecommissionRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    protected void clusterManagerOperation(DecommissionRequest request, ClusterState state, ActionListener<DecommissionResponse> listener) throws Exception {
        logger.info("starting awareness attribute [{}] decommissioning", (Object)request.getDecommissionAttribute().toString());
        this.decommissionService.startDecommissionAction(request, listener);
    }

    public static final class ActionProviderImpl
    implements ActionProvider {
        public ActionType<? extends ActionResponse> getInstance() {
            return DecommissionAction.INSTANCE;
        }

        public Class<? extends TransportAction<? extends ActionRequest, ? extends ActionResponse>> getTransportAction() {
            return TransportDecommissionAction.class;
        }
    }
}

