/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.admin.cluster.health;

import io.skylite.common.action.ActionListener;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.IndicesRequest;
import io.skylite.core.action.admin.cluster.health.ClusterHealthAction;
import io.skylite.core.action.admin.cluster.health.ClusterHealthRequest;
import io.skylite.core.action.admin.cluster.health.ClusterHealthResponse;
import io.skylite.core.action.spi.ActionProvider;
import io.skylite.core.action.support.ActiveShardCount;
import io.skylite.core.action.support.ActiveShardsObserver;
import io.skylite.core.action.support.IndicesOptions;
import io.skylite.core.action.support.TransportAction;
import io.skylite.core.action.support.clustermanager.TransportClusterManagerNodeReadAction;
import io.skylite.core.cluster.NotClusterManagerException;
import io.skylite.core.cluster.ProcessClusterEventTimeoutException;
import io.skylite.core.cluster.block.ClusterBlockException;
import io.skylite.core.cluster.health.ClusterHealthStatus;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.cluster.routing.WeightedRoutingUtils;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.cluster.state.ClusterStateObserver;
import io.skylite.core.cluster.state.ClusterStateTaskConfig;
import io.skylite.core.cluster.state.ClusterStateTaskExecutor;
import io.skylite.core.cluster.state.ClusterStateUpdateTask;
import io.skylite.core.cluster.state.LocalClusterStateUpdateTask;
import io.skylite.core.common.Strings;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.util.CollectionUtils;
import io.skylite.core.discovery.ClusterManagerNotDiscoveredException;
import io.skylite.core.discovery.Discovery;
import io.skylite.core.index.IndexNotFoundException;
import io.skylite.core.node.NodeClosedException;
import io.skylite.core.tasks.Task;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportService;
import java.io.IOException;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.cluster.coordination.Coordinator;
import org.opensearch.cluster.decommission.NodeDecommissionedException;
import org.opensearch.cluster.routing.DelayedAllocationService;
import org.opensearch.cluster.routing.NodeWeighedAwayException;
import org.opensearch.cluster.routing.allocation.AllocationService;

public class TransportClusterHealthAction
extends TransportClusterManagerNodeReadAction<ClusterHealthRequest, ClusterHealthResponse> {
    private static final Logger logger = LogManager.getLogger(TransportClusterHealthAction.class);
    private final AllocationService allocationService;
    private final Discovery discovery;

    @Inject
    public TransportClusterHealthAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, AllocationService allocationService, Discovery discovery) {
        super("cluster:monitor/health", false, transportService, clusterService, threadPool, actionFilters, ClusterHealthRequest::new, indexNameExpressionResolver);
        this.allocationService = allocationService;
        this.discovery = discovery;
    }

    protected String executor() {
        return "same";
    }

    protected ClusterHealthResponse read(StreamInput in) throws IOException {
        return new ClusterHealthResponse(in);
    }

    protected ClusterBlockException checkBlock(ClusterHealthRequest request, ClusterState state) {
        return null;
    }

    protected final void clusterManagerOperation(ClusterHealthRequest request, ClusterState state, ActionListener<ClusterHealthResponse> listener) throws Exception {
        logger.warn("attempt to execute a cluster health operation without a task");
        throw new UnsupportedOperationException("task parameter is required for this operation");
    }

    protected void clusterManagerOperation(Task task, ClusterHealthRequest request, ClusterState unusedState, ActionListener<ClusterHealthResponse> listener) {
        if (request.ensureNodeWeighedIn() && this.discovery instanceof Coordinator && !((Coordinator)this.discovery).localNodeCommissioned()) {
            listener.onFailure((Exception)((Object)new NodeDecommissionedException("local node is decommissioned", new Object[0])));
            return;
        }
        int waitCount = TransportClusterHealthAction.getWaitCount(request);
        if (request.waitForEvents() != null) {
            this.waitForEventsAndExecuteHealth(request, listener, waitCount, this.threadPool.relativeTimeInMillis() + request.timeout().millis());
        } else {
            this.executeHealth(request, this.clusterService.state(), listener, waitCount, clusterState -> listener.onResponse((Object)this.getResponse(request, (ClusterState)clusterState, waitCount, TimeoutState.OK)));
        }
    }

    private void waitForEventsAndExecuteHealth(final ClusterHealthRequest request, final ActionListener<ClusterHealthResponse> listener, final int waitCount, final long endTimeRelativeMillis) {
        assert (request.waitForEvents() != null);
        if (request.local()) {
            this.clusterService.submitStateUpdateTask("cluster_health (wait_for_events [" + String.valueOf(request.waitForEvents()) + "])", (ClusterStateTaskConfig)new LocalClusterStateUpdateTask(request.waitForEvents()){

                public ClusterStateTaskExecutor.ClusterStateTasksResult<LocalClusterStateUpdateTask> execute(ClusterState currentState) {
                    return 1.unchanged();
                }

                public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                    long timeoutInMillis = Math.max(0L, endTimeRelativeMillis - TransportClusterHealthAction.this.threadPool.relativeTimeInMillis());
                    TimeValue newTimeout = TimeValue.timeValueMillis((long)timeoutInMillis);
                    request.timeout(newTimeout);
                    TransportClusterHealthAction.this.executeHealth(request, TransportClusterHealthAction.this.clusterService.state(), (ActionListener<ClusterHealthResponse>)listener, waitCount, observedState -> TransportClusterHealthAction.this.waitForEventsAndExecuteHealth(request, (ActionListener<ClusterHealthResponse>)listener, waitCount, endTimeRelativeMillis));
                }

                public void onFailure(String source, Exception e) {
                    logger.error(() -> new ParameterizedMessage("unexpected failure during [{}]", (Object)source), (Throwable)e);
                    listener.onFailure(e);
                }
            });
        } else {
            final TimeValue taskTimeout = TimeValue.timeValueMillis((long)Math.max(0L, endTimeRelativeMillis - this.threadPool.relativeTimeInMillis()));
            this.clusterService.submitStateUpdateTask("cluster_health (wait_for_events [" + String.valueOf(request.waitForEvents()) + "])", (ClusterStateTaskConfig)new ClusterStateUpdateTask(request.waitForEvents()){

                public ClusterState execute(ClusterState currentState) {
                    return currentState;
                }

                public TimeValue timeout() {
                    return taskTimeout;
                }

                public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                    long timeoutInMillis = Math.max(0L, endTimeRelativeMillis - TransportClusterHealthAction.this.threadPool.relativeTimeInMillis());
                    TimeValue newTimeout = TimeValue.timeValueMillis((long)timeoutInMillis);
                    request.timeout(newTimeout);
                    ClusterState appliedState = TransportClusterHealthAction.this.clusterService.state();
                    assert (newState.stateUUID().equals(appliedState.stateUUID())) : newState.stateUUID() + " vs " + appliedState.stateUUID();
                    TransportClusterHealthAction.this.executeHealth(request, appliedState, (ActionListener<ClusterHealthResponse>)listener, waitCount, observedState -> TransportClusterHealthAction.this.waitForEventsAndExecuteHealth(request, (ActionListener<ClusterHealthResponse>)listener, waitCount, endTimeRelativeMillis));
                }

                public void onNoLongerClusterManager(String source) {
                    logger.trace("stopped being cluster-manager while waiting for events with priority [{}]. retrying.", (Object)request.waitForEvents());
                    listener.onFailure((Exception)new NotClusterManagerException("no longer cluster-manager. source: [" + source + "]"));
                }

                public void onFailure(String source, Exception e) {
                    if (e instanceof ProcessClusterEventTimeoutException) {
                        listener.onResponse((Object)TransportClusterHealthAction.this.getResponse(request, TransportClusterHealthAction.this.clusterService.state(), waitCount, TimeoutState.TIMED_OUT));
                    } else {
                        logger.error(() -> new ParameterizedMessage("unexpected failure during [{}]", (Object)source), (Throwable)e);
                        listener.onFailure(e);
                    }
                }
            });
        }
    }

    private void executeHealth(final ClusterHealthRequest request, ClusterState currentState, final ActionListener<ClusterHealthResponse> listener, final int waitCount, final Consumer<ClusterState> onNewClusterStateAfterDelay) {
        if (request.timeout().millis() == 0L) {
            listener.onResponse((Object)this.getResponse(request, currentState, waitCount, TimeoutState.ZERO_TIMEOUT));
            return;
        }
        Predicate<ClusterState> validationPredicate = newState -> this.validateRequest(request, (ClusterState)newState, waitCount);
        if (validationPredicate.test(currentState)) {
            ClusterHealthResponse clusterHealthResponse = this.getResponse(request, currentState, waitCount, TimeoutState.OK);
            if (request.ensureNodeWeighedIn()) {
                if (!clusterHealthResponse.hasDiscoveredClusterManager()) {
                    listener.onFailure((Exception)new ClusterManagerNotDiscoveredException("cluster-manager not discovered"));
                    return;
                }
                DiscoveryNode localNode = currentState.getNodes().getLocalNode();
                if (localNode.isDataNode()) {
                    assert (request.local()) : "local node request false for request for local node weighed in";
                    boolean weighedAway = WeightedRoutingUtils.isWeighedAway((String)localNode.getId(), (ClusterState)currentState);
                    if (weighedAway) {
                        listener.onFailure((Exception)((Object)new NodeWeighedAwayException("local node is weighed away", new Object[0])));
                        return;
                    }
                }
            }
            listener.onResponse((Object)clusterHealthResponse);
        } else {
            final ClusterStateObserver observer = new ClusterStateObserver(currentState, this.clusterService, null, logger, this.threadPool.getThreadContext());
            ClusterStateObserver.Listener stateListener = new ClusterStateObserver.Listener(){

                public void onNewClusterState(ClusterState newState) {
                    onNewClusterStateAfterDelay.accept(newState);
                }

                public void onClusterServiceClose() {
                    listener.onFailure((Exception)new NodeClosedException(TransportClusterHealthAction.this.clusterService.localNode()));
                }

                public void onTimeout(TimeValue timeout) {
                    listener.onResponse((Object)TransportClusterHealthAction.this.getResponse(request, observer.setAndGetObservedState(), waitCount, TimeoutState.TIMED_OUT));
                }
            };
            observer.waitForNextChange(stateListener, validationPredicate, request.timeout());
        }
    }

    private static int getWaitCount(ClusterHealthRequest request) {
        int waitCount = 0;
        if (request.waitForStatus() != null) {
            ++waitCount;
        }
        if (request.waitForNoRelocatingShards()) {
            ++waitCount;
        }
        if (request.waitForNoInitializingShards()) {
            ++waitCount;
        }
        if (!request.waitForActiveShards().equals((Object)ActiveShardCount.NONE)) {
            ++waitCount;
        }
        if (!request.waitForNodes().isEmpty()) {
            ++waitCount;
        }
        if (!CollectionUtils.isEmpty((Object[])request.indices())) {
            ++waitCount;
        }
        return waitCount;
    }

    private boolean validateRequest(ClusterHealthRequest request, ClusterState clusterState, int waitCount) {
        ClusterHealthResponse response = this.clusterHealth(request, clusterState, this.clusterService.getClusterManagerService().numberOfPendingTasks(), this.allocationService.getNumberOfInFlightFetches(), this.clusterService.getClusterManagerService().getMaxTaskWaitTime());
        return TransportClusterHealthAction.prepareResponse(request, response, clusterState, this.indexNameExpressionResolver) == waitCount;
    }

    private ClusterHealthResponse getResponse(ClusterHealthRequest request, ClusterState clusterState, int waitFor, TimeoutState timeoutState) {
        boolean valid;
        ClusterHealthResponse response = this.clusterHealth(request, clusterState, this.clusterService.getClusterManagerService().numberOfPendingTasks(), this.allocationService.getNumberOfInFlightFetches(), this.clusterService.getClusterManagerService().getMaxTaskWaitTime());
        int readyCounter = TransportClusterHealthAction.prepareResponse(request, response, clusterState, this.indexNameExpressionResolver);
        boolean bl = valid = readyCounter == waitFor;
        assert (valid || timeoutState != TimeoutState.OK);
        response.setTimedOut(!valid || timeoutState == TimeoutState.TIMED_OUT);
        return response;
    }

    static int prepareResponse(ClusterHealthRequest request, ClusterHealthResponse response, ClusterState clusterState, IndexNameExpressionResolver indexNameExpressionResolver) {
        int waitForCounter = 0;
        if (request.waitForStatus() != null && response.getStatus().value() <= request.waitForStatus().value()) {
            ++waitForCounter;
        }
        if (request.waitForNoRelocatingShards() && response.getRelocatingShards() == 0) {
            ++waitForCounter;
        }
        if (request.waitForNoInitializingShards() && response.getInitializingShards() == 0) {
            ++waitForCounter;
        }
        if (!request.waitForActiveShards().equals((Object)ActiveShardCount.NONE)) {
            ActiveShardCount waitForActiveShards = request.waitForActiveShards();
            assert (!waitForActiveShards.equals((Object)ActiveShardCount.DEFAULT)) : "waitForActiveShards must not be DEFAULT on the request object, instead it should be NONE";
            if (waitForActiveShards.equals((Object)ActiveShardCount.ALL)) {
                if (response.getUnassignedShards() == 0 && response.getInitializingShards() == 0) {
                    ++waitForCounter;
                }
            } else if (ActiveShardsObserver.enoughShardsActive((ActiveShardCount)waitForActiveShards, (int)response.getActiveShards())) {
                ++waitForCounter;
            }
        }
        if (!CollectionUtils.isEmpty((Object[])request.indices())) {
            try {
                indexNameExpressionResolver.concreteIndexNames(clusterState, IndicesOptions.strictExpand(), (IndicesRequest)request);
                ++waitForCounter;
            }
            catch (IndexNotFoundException e) {
                response.setStatus(ClusterHealthStatus.RED);
            }
        }
        if (!request.waitForNodes().isEmpty()) {
            if (request.waitForNodes().startsWith(">=")) {
                int expected = Integer.parseInt(request.waitForNodes().substring(2));
                if (response.getNumberOfNodes() >= expected) {
                    ++waitForCounter;
                }
            } else if (request.waitForNodes().startsWith("ge(")) {
                int expected = Integer.parseInt(request.waitForNodes().substring(3, request.waitForNodes().length() - 1));
                if (response.getNumberOfNodes() >= expected) {
                    ++waitForCounter;
                }
            } else if (request.waitForNodes().startsWith("<=")) {
                int expected = Integer.parseInt(request.waitForNodes().substring(2));
                if (response.getNumberOfNodes() <= expected) {
                    ++waitForCounter;
                }
            } else if (request.waitForNodes().startsWith("le(")) {
                int expected = Integer.parseInt(request.waitForNodes().substring(3, request.waitForNodes().length() - 1));
                if (response.getNumberOfNodes() <= expected) {
                    ++waitForCounter;
                }
            } else if (request.waitForNodes().startsWith(">")) {
                int expected = Integer.parseInt(request.waitForNodes().substring(1));
                if (response.getNumberOfNodes() > expected) {
                    ++waitForCounter;
                }
            } else if (request.waitForNodes().startsWith("gt(")) {
                int expected = Integer.parseInt(request.waitForNodes().substring(3, request.waitForNodes().length() - 1));
                if (response.getNumberOfNodes() > expected) {
                    ++waitForCounter;
                }
            } else if (request.waitForNodes().startsWith("<")) {
                int expected = Integer.parseInt(request.waitForNodes().substring(1));
                if (response.getNumberOfNodes() < expected) {
                    ++waitForCounter;
                }
            } else if (request.waitForNodes().startsWith("lt(")) {
                int expected = Integer.parseInt(request.waitForNodes().substring(3, request.waitForNodes().length() - 1));
                if (response.getNumberOfNodes() < expected) {
                    ++waitForCounter;
                }
            } else {
                int expected = Integer.parseInt(request.waitForNodes());
                if (response.getNumberOfNodes() == expected) {
                    ++waitForCounter;
                }
            }
        }
        return waitForCounter;
    }

    private ClusterHealthResponse clusterHealth(ClusterHealthRequest request, ClusterState clusterState, int numberOfPendingTasks, int numberOfInFlightFetch, TimeValue pendingTaskTimeInQueue) {
        String[] concreteIndices;
        if (logger.isTraceEnabled()) {
            logger.trace("Calculating health based on state version [{}]", (Object)clusterState.version());
        }
        if (request.level().equals((Object)ClusterHealthRequest.Level.AWARENESS_ATTRIBUTES)) {
            String awarenessAttribute = request.getAwarenessAttribute();
            String[] concreteIndices2 = clusterState.getMetadata().getConcreteAllIndices();
            return new ClusterHealthResponse(clusterState.getClusterName().value(), clusterState, this.clusterService.getClusterSettings(), concreteIndices2, awarenessAttribute, numberOfPendingTasks, numberOfInFlightFetch, DelayedAllocationService.getNumberOfDelayedUnassigned(clusterState.routingTable()), pendingTaskTimeInQueue);
        }
        try {
            concreteIndices = this.indexNameExpressionResolver.concreteIndexNames(clusterState, (IndicesRequest)request);
        }
        catch (IndexNotFoundException e) {
            ClusterHealthResponse response = new ClusterHealthResponse(clusterState.getClusterName().value(), Strings.EMPTY_ARRAY, clusterState, numberOfPendingTasks, numberOfInFlightFetch, DelayedAllocationService.getNumberOfDelayedUnassigned(clusterState.routingTable()), pendingTaskTimeInQueue);
            response.setStatus(ClusterHealthStatus.RED);
            return response;
        }
        return new ClusterHealthResponse(clusterState.getClusterName().value(), concreteIndices, clusterState, numberOfPendingTasks, numberOfInFlightFetch, DelayedAllocationService.getNumberOfDelayedUnassigned(clusterState.routingTable()), pendingTaskTimeInQueue);
    }

    private static enum TimeoutState {
        OK,
        TIMED_OUT,
        ZERO_TIMEOUT;

    }

    public static final class ActionProviderImpl
    implements ActionProvider {
        public ActionType<? extends ActionResponse> getInstance() {
            return ClusterHealthAction.INSTANCE;
        }

        public Class<? extends TransportAction<? extends ActionRequest, ? extends ActionResponse>> getTransportAction() {
            return TransportClusterHealthAction.class;
        }
    }
}

