/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.admin.cluster.node.reload;

import io.lucenia.action.support.nodes.TransportNodesAction;
import io.lucenia.plugins.PluginsService;
import io.lucenia.plugins.ReloadablePlugin;
import io.skylite.SkyliteException;
import io.skylite.common.ExceptionsHelper;
import io.skylite.common.SecureString;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.FailedNodeException;
import io.skylite.core.action.admin.cluster.node.reload.NodesReloadSecureSettingsAction;
import io.skylite.core.action.admin.cluster.node.reload.NodesReloadSecureSettingsRequest;
import io.skylite.core.action.admin.cluster.node.reload.NodesReloadSecureSettingsResponse;
import io.skylite.core.action.spi.ActionProvider;
import io.skylite.core.action.support.TransportAction;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.env.Environment;
import io.skylite.core.settings.KeyStoreWrapper;
import io.skylite.core.settings.SecureSettings;
import io.skylite.core.settings.Settings;
import io.skylite.core.tasks.Task;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportRequest;
import io.skylite.core.transport.TransportService;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.message.ParameterizedMessage;

public class TransportNodesReloadSecureSettingsAction
extends TransportNodesAction<NodesReloadSecureSettingsRequest, NodesReloadSecureSettingsResponse, NodeRequest, NodesReloadSecureSettingsResponse.NodeResponse> {
    private final Environment environment;
    private final PluginsService pluginsService;

    @Inject
    public TransportNodesReloadSecureSettingsAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, Environment environment, PluginsService pluginService) {
        super("cluster:admin/nodes/reload_secure_settings", threadPool, clusterService, transportService, actionFilters, NodesReloadSecureSettingsRequest::new, NodeRequest::new, "generic", NodesReloadSecureSettingsResponse.NodeResponse.class);
        this.environment = environment;
        this.pluginsService = pluginService;
    }

    @Override
    protected NodesReloadSecureSettingsResponse newResponse(NodesReloadSecureSettingsRequest request, List<NodesReloadSecureSettingsResponse.NodeResponse> responses, List<FailedNodeException> failures) {
        return new NodesReloadSecureSettingsResponse(this.clusterService.getClusterName(), responses, failures);
    }

    @Override
    protected NodeRequest newNodeRequest(NodesReloadSecureSettingsRequest request) {
        return new NodeRequest(request);
    }

    @Override
    protected NodesReloadSecureSettingsResponse.NodeResponse newNodeResponse(StreamInput in) throws IOException {
        return new NodesReloadSecureSettingsResponse.NodeResponse(in);
    }

    @Override
    public void doExecute(Task task, NodesReloadSecureSettingsRequest request, ActionListener<NodesReloadSecureSettingsResponse> listener) {
        if (request.hasPassword() && !this.isNodeLocal(request) && !this.isNodeTransportTLSEnabled()) {
            request.closePassword();
            listener.onFailure((Exception)new SkyliteException("Secure settings cannot be updated cluster wide when TLS for the transport layer is not enabled. Enable TLS or use the API with a `_local` filter on each node.", new Object[0]));
        } else {
            super.doExecute(task, request, ActionListenerHelper.wrap(response -> {
                request.closePassword();
                listener.onResponse(response);
            }, e -> {
                request.closePassword();
                listener.onFailure(e);
            }));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected NodesReloadSecureSettingsResponse.NodeResponse nodeOperation(NodeRequest nodeReloadRequest) {
        NodesReloadSecureSettingsRequest request = nodeReloadRequest.request;
        try (SecureString secureSettingsPassword = request.hasPassword() ? request.getSecureSettingsPassword() : new SecureString(new char[0]);){
            NodesReloadSecureSettingsResponse.NodeResponse nodeResponse;
            block15: {
                KeyStoreWrapper keystore;
                block13: {
                    NodesReloadSecureSettingsResponse.NodeResponse nodeResponse2;
                    block14: {
                        keystore = KeyStoreWrapper.load((Path)this.environment.configDir());
                        try {
                            if (keystore != null) break block13;
                            nodeResponse2 = new NodesReloadSecureSettingsResponse.NodeResponse(this.clusterService.localNode(), (Exception)new IllegalStateException("Keystore is missing"));
                            if (keystore == null) break block14;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (keystore != null) {
                                    try {
                                        keystore.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (Exception e) {
                                NodesReloadSecureSettingsResponse.NodeResponse nodeResponse3 = new NodesReloadSecureSettingsResponse.NodeResponse(this.clusterService.localNode(), e);
                                return nodeResponse3;
                            }
                        }
                        keystore.close();
                    }
                    return nodeResponse2;
                }
                keystore.decrypt(secureSettingsPassword.getChars());
                Settings settingsWithKeystore = Settings.builder().put(this.environment.settings(), false).setSecureSettings((SecureSettings)keystore).build();
                ArrayList exceptions = new ArrayList();
                this.pluginsService.filterPlugins(ReloadablePlugin.class).stream().forEach(p -> {
                    try {
                        p.reload(settingsWithKeystore);
                    }
                    catch (Exception e) {
                        this.logger.warn(() -> new ParameterizedMessage("Reload failed for plugin [{}]", (Object)p.getClass().getSimpleName()), (Throwable)e);
                        exceptions.add(e);
                    }
                });
                ExceptionsHelper.rethrowAndSuppress(exceptions);
                nodeResponse = new NodesReloadSecureSettingsResponse.NodeResponse(this.clusterService.localNode(), null);
                if (keystore == null) break block15;
                keystore.close();
            }
            return nodeResponse;
        }
    }

    private boolean isNodeTransportTLSEnabled() {
        return this.transportService.isTransportSecure();
    }

    private boolean isNodeLocal(NodesReloadSecureSettingsRequest request) {
        DiscoveryNode[] nodes;
        if (null == request.concreteNodes()) {
            this.resolveRequest(request, this.clusterService.state());
            assert (request.concreteNodes() != null);
        }
        return (nodes = request.concreteNodes()).length == 1 && nodes[0].getId().equals(this.clusterService.localNode().getId());
    }

    public static class NodeRequest
    extends TransportRequest {
        NodesReloadSecureSettingsRequest request;

        public NodeRequest(StreamInput in) throws IOException {
            super(in);
            this.request = new NodesReloadSecureSettingsRequest(in);
        }

        NodeRequest(NodesReloadSecureSettingsRequest request) {
            this.request = request;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.request.writeTo(out);
        }
    }

    public static final class ActionProviderImpl
    implements ActionProvider {
        public ActionType<? extends ActionResponse> getInstance() {
            return NodesReloadSecureSettingsAction.INSTANCE;
        }

        public Class<? extends TransportAction<? extends ActionRequest, ? extends ActionResponse>> getTransportAction() {
            return TransportNodesReloadSecureSettingsAction.class;
        }
    }
}

