/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.admin.cluster.node.tasks.get;

import io.lucenia.action.admin.cluster.node.tasks.list.TransportListTasksAction;
import io.skylite.ResourceNotFoundException;
import io.skylite.SkyliteException;
import io.skylite.SkyliteExceptionsHelper;
import io.skylite.common.action.ActionListener;
import io.skylite.common.transport.TransportRequestOptions;
import io.skylite.common.util.concurrent.AbstractRunnable;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.ActionListenerResponseHandler;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.admin.cluster.node.tasks.get.GetTaskAction;
import io.skylite.core.action.admin.cluster.node.tasks.get.GetTaskResponse;
import io.skylite.core.action.admin.cluster.tasks.get.GetTaskRequest;
import io.skylite.core.action.get.GetRequest;
import io.skylite.core.action.get.GetResponse;
import io.skylite.core.action.spi.ActionProvider;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.action.support.TransportAction;
import io.skylite.core.client.Client;
import io.skylite.core.client.OriginSettingClient;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.index.IndexNotFoundException;
import io.skylite.core.tasks.Task;
import io.skylite.core.tasks.TaskInfo;
import io.skylite.core.tasks.TaskResult;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportRequest;
import io.skylite.core.transport.TransportResponseHandler;
import io.skylite.core.transport.TransportService;
import io.skylite.core.xcontent.DeprecationHandler;
import io.skylite.core.xcontent.LoggingDeprecationHandler;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.XContentHelper;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;

public class TransportGetTaskAction
extends HandledTransportAction<GetTaskRequest, GetTaskResponse> {
    private final ThreadPool threadPool;
    private final ClusterService clusterService;
    private final TransportService transportService;
    private final Client client;
    private final NamedXContentRegistry xContentRegistry;

    @Inject
    public TransportGetTaskAction(ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, ClusterService clusterService, Client client, NamedXContentRegistry xContentRegistry) {
        super("cluster:monitor/task/get", transportService, actionFilters, GetTaskRequest::new);
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.transportService = transportService;
        this.client = new OriginSettingClient(client, "tasks");
        this.xContentRegistry = xContentRegistry;
    }

    protected void doExecute(Task thisTask, GetTaskRequest request, ActionListener<GetTaskResponse> listener) {
        if (this.clusterService.localNode().getId().equals(request.getTaskId().getNodeId())) {
            this.getRunningTaskFromNode(thisTask, request, listener);
        } else {
            this.runOnNodeWithTaskIfPossible(thisTask, request, listener);
        }
    }

    private void runOnNodeWithTaskIfPossible(Task thisTask, GetTaskRequest request, ActionListener<GetTaskResponse> listener) {
        DiscoveryNode node;
        TransportRequestOptions.Builder builder = TransportRequestOptions.builder();
        if (request.getTimeout() != null) {
            builder.withTimeout(request.getTimeout());
        }
        if ((node = this.clusterService.state().nodes().get(request.getTaskId().getNodeId())) == null) {
            this.getFinishedTaskFromIndex(thisTask, request, (ActionListener<GetTaskResponse>)ActionListenerHelper.wrap(arg_0 -> listener.onResponse(arg_0), e -> {
                if (e instanceof ResourceNotFoundException) {
                    e = new ResourceNotFoundException("task [" + String.valueOf(request.getTaskId()) + "] belongs to the node [" + request.getTaskId().getNodeId() + "] which isn't part of the cluster and there is no record of the task", (Throwable)e, new Object[0]);
                }
                listener.onFailure(e);
            }));
            return;
        }
        GetTaskRequest nodeRequest = request.nodeRequest(this.clusterService.localNode().getId(), thisTask.getId());
        this.transportService.sendRequest(node, "cluster:monitor/task/get", (TransportRequest)nodeRequest, builder.build(), (TransportResponseHandler)new ActionListenerResponseHandler(listener, GetTaskResponse::new, "same"));
    }

    void getRunningTaskFromNode(final Task thisTask, final GetTaskRequest request, final ActionListener<GetTaskResponse> listener) {
        final Task runningTask = this.taskManager.getTask(request.getTaskId().getId());
        if (runningTask == null) {
            this.getFinishedTaskFromIndex(thisTask, request, listener);
        } else if (request.getWaitForCompletion()) {
            this.threadPool.generic().execute((Runnable)new AbstractRunnable(){

                public void doRun() {
                    TransportGetTaskAction.this.taskManager.waitForTaskCompletion(runningTask, TransportListTasksAction.waitForCompletionTimeout(request.getTimeout()));
                    TransportGetTaskAction.this.waitedForCompletion(thisTask, request, runningTask.taskInfo(TransportGetTaskAction.this.clusterService.localNode().getId(), true), (ActionListener<GetTaskResponse>)listener);
                }

                public void onFailure(Exception e) {
                    listener.onFailure(e);
                }
            });
        } else {
            TaskInfo info = runningTask.taskInfo(this.clusterService.localNode().getId(), true);
            listener.onResponse((Object)new GetTaskResponse(new TaskResult(false, info)));
        }
    }

    void waitedForCompletion(Task thisTask, GetTaskRequest request, TaskInfo snapshotOfRunningTask, ActionListener<GetTaskResponse> listener) {
        this.getFinishedTaskFromIndex(thisTask, request, (ActionListener<GetTaskResponse>)ActionListenerHelper.delegateResponse(listener, (delegatedListener, e) -> {
            if (SkyliteExceptionsHelper.unwrap((Throwable)e, (Class[])new Class[]{ResourceNotFoundException.class}) != null) {
                delegatedListener.onResponse((Object)new GetTaskResponse(new TaskResult(true, snapshotOfRunningTask)));
            } else {
                delegatedListener.onFailure(e);
            }
        }));
    }

    void getFinishedTaskFromIndex(Task thisTask, GetTaskRequest request, ActionListener<GetTaskResponse> listener) {
        GetRequest get = new GetRequest(".tasks", request.getTaskId().toString());
        get.setParentTask(this.clusterService.localNode().getId(), thisTask.getId());
        this.client.get(get, ActionListenerHelper.wrap(r -> this.onGetFinishedTaskFromIndex((GetResponse)r, listener), e -> {
            if (SkyliteExceptionsHelper.unwrap((Throwable)e, (Class[])new Class[]{IndexNotFoundException.class}) != null) {
                listener.onFailure((Exception)new ResourceNotFoundException("task [{}] isn't running and hasn't stored its results", (Throwable)e, new Object[]{request.getTaskId()}));
            } else {
                listener.onFailure(e);
            }
        }));
    }

    void onGetFinishedTaskFromIndex(GetResponse response, ActionListener<GetTaskResponse> listener) throws IOException {
        if (!response.isExists()) {
            listener.onFailure((Exception)new ResourceNotFoundException("task [{}] isn't running and hasn't stored its results", new Object[]{response.getId()}));
            return;
        }
        if (response.isSourceEmpty()) {
            listener.onFailure((Exception)new SkyliteException("Stored task status for [{}] didn't contain any source!", new Object[]{response.getId()}));
            return;
        }
        try (XContentParser parser = XContentHelper.createParser((NamedXContentRegistry)this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (BytesReference)response.getSourceAsBytesRef());){
            TaskResult result = (TaskResult)TaskResult.PARSER.apply(parser, null);
            listener.onResponse((Object)new GetTaskResponse(result));
        }
    }

    public static final class ActionProviderImpl
    implements ActionProvider {
        public ActionType<? extends ActionResponse> getInstance() {
            return GetTaskAction.INSTANCE;
        }

        public Class<? extends TransportAction<? extends ActionRequest, ? extends ActionResponse>> getTransportAction() {
            return TransportGetTaskAction.class;
        }
    }
}

