/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.admin.cluster.node.tasks.list;

import io.lucenia.action.support.tasks.TransportTasksAction;
import io.skylite.common.action.ActionListener;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.FailedNodeException;
import io.skylite.core.action.TaskOperationFailure;
import io.skylite.core.action.admin.cluster.node.tasks.list.ListTasksAction;
import io.skylite.core.action.admin.cluster.node.tasks.list.ListTasksRequest;
import io.skylite.core.action.admin.cluster.node.tasks.list.ListTasksResponse;
import io.skylite.core.action.spi.ActionProvider;
import io.skylite.core.action.support.TransportAction;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.tasks.Task;
import io.skylite.core.tasks.TaskInfo;
import io.skylite.core.tasks.TaskResourceTrackingService;
import io.skylite.core.transport.TransportService;
import java.util.List;
import java.util.function.Consumer;

public class TransportListTasksAction
extends TransportTasksAction<Task, ListTasksRequest, ListTasksResponse, TaskInfo> {
    private static final TimeValue DEFAULT_WAIT_FOR_COMPLETION_TIMEOUT = TimeValue.timeValueSeconds((long)30L);
    private final TaskResourceTrackingService taskResourceTrackingService;

    public static long waitForCompletionTimeout(TimeValue timeout) {
        if (timeout == null) {
            timeout = DEFAULT_WAIT_FOR_COMPLETION_TIMEOUT;
        }
        return System.nanoTime() + timeout.nanos();
    }

    @Inject
    public TransportListTasksAction(ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, TaskResourceTrackingService taskResourceTrackingService) {
        super("cluster:monitor/tasks/lists", clusterService, transportService, actionFilters, ListTasksRequest::new, ListTasksResponse::new, TaskInfo::new, "management");
        this.taskResourceTrackingService = taskResourceTrackingService;
    }

    @Override
    protected ListTasksResponse newResponse(ListTasksRequest request, List<TaskInfo> tasks, List<TaskOperationFailure> taskOperationFailures, List<FailedNodeException> failedNodeExceptions) {
        return new ListTasksResponse(tasks, taskOperationFailures, failedNodeExceptions);
    }

    @Override
    protected void taskOperation(ListTasksRequest request, Task task, ActionListener<TaskInfo> listener) {
        listener.onResponse((Object)task.taskInfo(this.clusterService.localNode().getId(), request.getDetailed()));
    }

    @Override
    protected void processTasks(ListTasksRequest request, Consumer<Task> operation) {
        if (request.getWaitForCompletion()) {
            long timeoutNanos = TransportListTasksAction.waitForCompletionTimeout(request.getTimeout());
            operation = operation.andThen(task -> {
                if (task.getAction().startsWith("cluster:monitor/tasks/lists")) {
                    return;
                }
                this.taskManager.waitForTaskCompletion(task, timeoutNanos);
            });
        } else {
            operation = operation.andThen(xva$0 -> this.taskResourceTrackingService.refreshResourceStats(new Task[]{xva$0}));
        }
        super.processTasks(request, operation);
    }

    public static final class ActionProviderImpl
    implements ActionProvider {
        public ActionType<? extends ActionResponse> getInstance() {
            return ListTasksAction.INSTANCE;
        }

        public Class<? extends TransportAction<? extends ActionRequest, ? extends ActionResponse>> getTransportAction() {
            return TransportListTasksAction.class;
        }
    }
}

