/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.admin.cluster.node.usage;

import io.lucenia.action.support.nodes.TransportNodesAction;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.FailedNodeException;
import io.skylite.core.action.admin.cluster.node.usage.NodeUsage;
import io.skylite.core.action.admin.cluster.node.usage.NodesUsageAction;
import io.skylite.core.action.admin.cluster.node.usage.NodesUsageRequest;
import io.skylite.core.action.admin.cluster.node.usage.NodesUsageResponse;
import io.skylite.core.action.spi.ActionProvider;
import io.skylite.core.action.support.TransportAction;
import io.skylite.core.aggregations.AggregationUsageService;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportRequest;
import io.skylite.core.transport.TransportService;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.opensearch.usage.UsageService;

public class TransportNodesUsageAction
extends TransportNodesAction<NodesUsageRequest, NodesUsageResponse, NodeUsageRequest, NodeUsage> {
    private final UsageService restUsageService;
    private final AggregationUsageService aggregationUsageService;
    private final long sinceTime;

    @Inject
    public TransportNodesUsageAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, UsageService restUsageService, AggregationUsageService aggregationUsageService) {
        super("cluster:monitor/nodes/usage", threadPool, clusterService, transportService, actionFilters, NodesUsageRequest::new, NodeUsageRequest::new, "management", NodeUsage.class);
        this.restUsageService = restUsageService;
        this.aggregationUsageService = aggregationUsageService;
        this.sinceTime = System.currentTimeMillis();
    }

    @Override
    protected NodesUsageResponse newResponse(NodesUsageRequest request, List<NodeUsage> responses, List<FailedNodeException> failures) {
        return new NodesUsageResponse(this.clusterService.getClusterName(), responses, failures);
    }

    @Override
    protected NodeUsageRequest newNodeRequest(NodesUsageRequest request) {
        return new NodeUsageRequest(request);
    }

    @Override
    protected NodeUsage newNodeResponse(StreamInput in) throws IOException {
        return new NodeUsage(in);
    }

    @Override
    protected NodeUsage nodeOperation(NodeUsageRequest nodeUsageRequest) {
        NodesUsageRequest request = nodeUsageRequest.request;
        Map<String, Long> restUsage = request.restActions() ? this.restUsageService.getRestUsageStats() : null;
        Map aggsUsage = request.aggregations() ? this.aggregationUsageService.getUsageStats() : null;
        return new NodeUsage(this.clusterService.localNode(), System.currentTimeMillis(), this.sinceTime, restUsage, aggsUsage);
    }

    public static class NodeUsageRequest
    extends TransportRequest {
        NodesUsageRequest request;

        public NodeUsageRequest(StreamInput in) throws IOException {
            super(in);
            this.request = new NodesUsageRequest(in);
        }

        NodeUsageRequest(NodesUsageRequest request) {
            this.request = request;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.request.writeTo(out);
        }
    }

    public static final class ActionProviderImpl
    implements ActionProvider {
        public ActionType<? extends ActionResponse> getInstance() {
            return NodesUsageAction.INSTANCE;
        }

        public Class<? extends TransportAction<? extends ActionRequest, ? extends ActionResponse>> getTransportAction() {
            return TransportNodesUsageAction.class;
        }
    }
}

