/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.admin.cluster.remotestore.restore;

import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.admin.cluster.remotestore.restore.RestoreRemoteStoreAction;
import io.skylite.core.action.admin.cluster.remotestore.restore.RestoreRemoteStoreRequest;
import io.skylite.core.action.admin.cluster.remotestore.restore.RestoreRemoteStoreResponse;
import io.skylite.core.action.admin.cluster.snapshots.restore.RestoreClusterStateListener;
import io.skylite.core.action.spi.ActionProvider;
import io.skylite.core.action.support.TransportAction;
import io.skylite.core.action.support.clustermanager.TransportClusterManagerNodeAction;
import io.skylite.core.cluster.block.ClusterBlockException;
import io.skylite.core.cluster.block.ClusterBlockLevel;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.snapshots.RestoreCompletionResponse;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportService;
import java.io.IOException;
import org.opensearch.index.recovery.RemoteStoreRestoreService;

public final class TransportRestoreRemoteStoreAction
extends TransportClusterManagerNodeAction<RestoreRemoteStoreRequest, RestoreRemoteStoreResponse> {
    private final RemoteStoreRestoreService restoreService;

    @Inject
    public TransportRestoreRemoteStoreAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, RemoteStoreRestoreService restoreService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:admin/remotestore/restore", transportService, clusterService, threadPool, actionFilters, RestoreRemoteStoreRequest::new, indexNameExpressionResolver);
        this.restoreService = restoreService;
    }

    protected String executor() {
        return "generic";
    }

    protected RestoreRemoteStoreResponse read(StreamInput in) throws IOException {
        return new RestoreRemoteStoreResponse(in);
    }

    protected ClusterBlockException checkBlock(RestoreRemoteStoreRequest request, ClusterState state) {
        ClusterBlockException blockException = state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
        if (blockException != null) {
            return blockException;
        }
        return state.blocks().globalBlockedException(ClusterBlockLevel.WRITE);
    }

    protected void clusterManagerOperation(RestoreRemoteStoreRequest request, ClusterState state, ActionListener<RestoreRemoteStoreResponse> listener) {
        this.restoreService.restore(request, (ActionListener<RestoreCompletionResponse>)ActionListenerHelper.delegateFailure(listener, (delegatedListener, restoreCompletionResponse) -> {
            if (restoreCompletionResponse.getRestoreInfo() == null && request.waitForCompletion()) {
                RestoreClusterStateListener.createAndRegisterListener((ClusterService)this.clusterService, (RestoreCompletionResponse)restoreCompletionResponse, (ActionListener)delegatedListener, RestoreRemoteStoreResponse::new);
            } else {
                delegatedListener.onResponse((Object)new RestoreRemoteStoreResponse(restoreCompletionResponse.getRestoreInfo()));
            }
        }));
    }

    public static final class ActionProviderImpl
    implements ActionProvider {
        public ActionType<? extends ActionResponse> getInstance() {
            return RestoreRemoteStoreAction.INSTANCE;
        }

        public Class<? extends TransportAction<? extends ActionRequest, ? extends ActionResponse>> getTransportAction() {
            return TransportRestoreRemoteStoreAction.class;
        }
    }
}

