/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.admin.cluster.repositories.verify;

import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.admin.cluster.repositories.verify.VerifyRepositoryAction;
import io.skylite.core.action.admin.cluster.repositories.verify.VerifyRepositoryRequest;
import io.skylite.core.action.admin.cluster.repositories.verify.VerifyRepositoryResponse;
import io.skylite.core.action.spi.ActionProvider;
import io.skylite.core.action.support.TransportAction;
import io.skylite.core.action.support.clustermanager.TransportClusterManagerNodeAction;
import io.skylite.core.cluster.block.ClusterBlockException;
import io.skylite.core.cluster.block.ClusterBlockLevel;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.repositories.RepositoriesService;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportService;
import java.io.IOException;

public class TransportVerifyRepositoryAction
extends TransportClusterManagerNodeAction<VerifyRepositoryRequest, VerifyRepositoryResponse> {
    private final RepositoriesService repositoriesService;

    @Inject
    public TransportVerifyRepositoryAction(TransportService transportService, ClusterService clusterService, RepositoriesService repositoriesService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:admin/repository/verify", transportService, clusterService, threadPool, actionFilters, VerifyRepositoryRequest::new, indexNameExpressionResolver);
        this.repositoriesService = repositoriesService;
    }

    protected String executor() {
        return "same";
    }

    protected VerifyRepositoryResponse read(StreamInput in) throws IOException {
        return new VerifyRepositoryResponse(in);
    }

    protected ClusterBlockException checkBlock(VerifyRepositoryRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    protected void clusterManagerOperation(VerifyRepositoryRequest request, ClusterState state, ActionListener<VerifyRepositoryResponse> listener) {
        this.repositoriesService.verifyRepository(request.name(), ActionListenerHelper.delegateFailure(listener, (delegatedListener, verifyResponse) -> delegatedListener.onResponse((Object)new VerifyRepositoryResponse(verifyResponse.toArray(new DiscoveryNode[0])))));
    }

    public static final class ActionProviderImpl
    implements ActionProvider {
        public ActionType<? extends ActionResponse> getInstance() {
            return VerifyRepositoryAction.INSTANCE;
        }

        public Class<? extends TransportAction<? extends ActionRequest, ? extends ActionResponse>> getTransportAction() {
            return TransportVerifyRepositoryAction.class;
        }
    }
}

