/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.admin.cluster.shards.routing.weighted.get;

import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.admin.cluster.shards.routing.weighted.get.ClusterGetWeightedRoutingAction;
import io.skylite.core.action.admin.cluster.shards.routing.weighted.get.ClusterGetWeightedRoutingRequest;
import io.skylite.core.action.admin.cluster.shards.routing.weighted.get.ClusterGetWeightedRoutingResponse;
import io.skylite.core.action.spi.ActionProvider;
import io.skylite.core.action.support.TransportAction;
import io.skylite.core.action.support.clustermanager.TransportClusterManagerNodeReadAction;
import io.skylite.core.cluster.block.ClusterBlockException;
import io.skylite.core.cluster.block.ClusterBlockLevel;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.metadata.WeightedRoutingMetadata;
import io.skylite.core.cluster.routing.WeightedRouting;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportService;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.cluster.routing.WeightedRoutingService;

public class TransportGetWeightedRoutingAction
extends TransportClusterManagerNodeReadAction<ClusterGetWeightedRoutingRequest, ClusterGetWeightedRoutingResponse> {
    private static final Logger logger = LogManager.getLogger(TransportGetWeightedRoutingAction.class);
    private final WeightedRoutingService weightedRoutingService;

    @Inject
    public TransportGetWeightedRoutingAction(TransportService transportService, ClusterService clusterService, WeightedRoutingService weightedRoutingService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:admin/routing/awareness/weights/get", transportService, clusterService, threadPool, actionFilters, ClusterGetWeightedRoutingRequest::new, indexNameExpressionResolver);
        this.weightedRoutingService = weightedRoutingService;
    }

    protected String executor() {
        return "same";
    }

    protected ClusterGetWeightedRoutingResponse read(StreamInput in) throws IOException {
        return new ClusterGetWeightedRoutingResponse(in);
    }

    protected ClusterBlockException checkBlock(ClusterGetWeightedRoutingRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    protected void clusterManagerOperation(ClusterGetWeightedRoutingRequest request, ClusterState state, ActionListener<ClusterGetWeightedRoutingResponse> listener) {
        try {
            this.weightedRoutingService.verifyAwarenessAttribute(request.getAwarenessAttribute());
            WeightedRoutingMetadata weightedRoutingMetadata = (WeightedRoutingMetadata)state.metadata().custom("weighted_shard_routing");
            ClusterGetWeightedRoutingResponse clusterGetWeightedRoutingResponse = new ClusterGetWeightedRoutingResponse();
            if (weightedRoutingMetadata != null && weightedRoutingMetadata.getWeightedRouting() != null) {
                WeightedRouting weightedRouting = weightedRoutingMetadata.getWeightedRouting();
                clusterGetWeightedRoutingResponse = new ClusterGetWeightedRoutingResponse(weightedRouting, Boolean.valueOf(state.nodes().getClusterManagerNodeId() != null), weightedRoutingMetadata.getVersion());
            }
            listener.onResponse((Object)clusterGetWeightedRoutingResponse);
        }
        catch (Exception ex) {
            listener.onFailure(ex);
        }
    }

    public static final class ActionProviderImpl
    implements ActionProvider {
        public ActionType<? extends ActionResponse> getInstance() {
            return ClusterGetWeightedRoutingAction.INSTANCE;
        }

        public Class<? extends TransportAction<? extends ActionRequest, ? extends ActionResponse>> getTransportAction() {
            return TransportGetWeightedRoutingAction.class;
        }
    }
}

