/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.admin.cluster.snapshots.status;

import io.lucenia.action.support.nodes.TransportNodesAction;
import io.skylite.SkyliteException;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.FailedNodeException;
import io.skylite.core.action.admin.cluster.snapshots.status.SnapshotIndexShardStatus;
import io.skylite.core.action.support.nodes.BaseNodeResponse;
import io.skylite.core.action.support.nodes.BaseNodesRequest;
import io.skylite.core.action.support.nodes.BaseNodesResponse;
import io.skylite.core.cluster.ClusterName;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.index.snapshots.IndexShardSnapshotStatus;
import io.skylite.core.snapshots.Snapshot;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportRequest;
import io.skylite.core.transport.TransportService;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opensearch.snapshots.SnapshotShardsService;

public class TransportNodesSnapshotsStatus
extends TransportNodesAction<Request, NodesSnapshotStatus, NodeRequest, NodeSnapshotStatus> {
    public static final String ACTION_NAME = "cluster:admin/snapshot/status[nodes]";
    public static final ActionType<NodesSnapshotStatus> TYPE = new ActionType("cluster:admin/snapshot/status[nodes]", NodesSnapshotStatus::new);
    private final SnapshotShardsService snapshotShardsService;

    public TransportNodesSnapshotsStatus(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, SnapshotShardsService snapshotShardsService, ActionFilters actionFilters) {
        super(ACTION_NAME, threadPool, clusterService, transportService, actionFilters, Request::new, NodeRequest::new, "generic", NodeSnapshotStatus.class);
        this.snapshotShardsService = snapshotShardsService;
    }

    @Override
    protected NodeRequest newNodeRequest(Request request) {
        return new NodeRequest(request);
    }

    @Override
    protected NodeSnapshotStatus newNodeResponse(StreamInput in) throws IOException {
        return new NodeSnapshotStatus(in);
    }

    @Override
    protected NodesSnapshotStatus newResponse(Request request, List<NodeSnapshotStatus> responses, List<FailedNodeException> failures) {
        return new NodesSnapshotStatus(this.clusterService.getClusterName(), responses, failures);
    }

    @Override
    protected NodeSnapshotStatus nodeOperation(NodeRequest request) {
        HashMap snapshotMapBuilder = new HashMap();
        try {
            String nodeId = this.clusterService.localNode().getId();
            for (Snapshot snapshot : request.snapshots) {
                Map<ShardId, IndexShardSnapshotStatus> shardsStatus = this.snapshotShardsService.currentSnapshotShards(snapshot);
                if (shardsStatus == null) continue;
                HashMap<ShardId, SnapshotIndexShardStatus> shardMapBuilder = new HashMap<ShardId, SnapshotIndexShardStatus>();
                for (Map.Entry<ShardId, IndexShardSnapshotStatus> shardEntry : shardsStatus.entrySet()) {
                    ShardId shardId = shardEntry.getKey();
                    IndexShardSnapshotStatus.Copy lastSnapshotStatus = shardEntry.getValue().asCopy();
                    IndexShardSnapshotStatus.Stage stage = lastSnapshotStatus.getStage();
                    String shardNodeId = null;
                    if (stage != IndexShardSnapshotStatus.Stage.DONE && stage != IndexShardSnapshotStatus.Stage.FAILURE) {
                        shardNodeId = nodeId;
                    }
                    shardMapBuilder.put(shardEntry.getKey(), new SnapshotIndexShardStatus(shardId, lastSnapshotStatus, shardNodeId));
                }
                snapshotMapBuilder.put(snapshot, Collections.unmodifiableMap(shardMapBuilder));
            }
            return new NodeSnapshotStatus(this.clusterService.localNode(), Collections.unmodifiableMap(snapshotMapBuilder));
        }
        catch (Exception e) {
            throw new SkyliteException("failed to load metadata", (Throwable)e, new Object[0]);
        }
    }

    public static class NodeSnapshotStatus
    extends BaseNodeResponse {
        private final Map<Snapshot, Map<ShardId, SnapshotIndexShardStatus>> status;

        public NodeSnapshotStatus(StreamInput in) throws IOException {
            super(in);
            this.status = Collections.unmodifiableMap(in.readMap(Snapshot::new, input -> Collections.unmodifiableMap(input.readMap(ShardId::new, SnapshotIndexShardStatus::new))));
        }

        public NodeSnapshotStatus(DiscoveryNode node, Map<Snapshot, Map<ShardId, SnapshotIndexShardStatus>> status) {
            super(node);
            this.status = status;
        }

        public Map<Snapshot, Map<ShardId, SnapshotIndexShardStatus>> status() {
            return this.status;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            if (this.status != null) {
                out.writeMap(this.status, (o, s) -> s.writeTo(o), (output, v) -> output.writeMap(v, (o, shardId) -> shardId.writeTo(o), (o, sis) -> sis.writeTo(o)));
            } else {
                out.writeVInt(0);
            }
        }
    }

    public static class NodeRequest
    extends TransportRequest {
        private final List<Snapshot> snapshots;

        public NodeRequest(StreamInput in) throws IOException {
            super(in);
            this.snapshots = in.readList(Snapshot::new);
        }

        NodeRequest(Request request) {
            this.snapshots = Arrays.asList(request.snapshots);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeList(this.snapshots);
        }
    }

    public static class Request
    extends BaseNodesRequest<Request> {
        private Snapshot[] snapshots;

        public Request(StreamInput in) throws IOException {
            super(in);
            throw new UnsupportedOperationException("shouldn't be here");
        }

        public Request(String[] nodesIds) {
            super(nodesIds);
        }

        public Request snapshots(Snapshot[] snapshots) {
            this.snapshots = snapshots;
            return this;
        }

        public void writeTo(StreamOutput out) throws IOException {
            throw new UnsupportedOperationException("shouldn't be here");
        }
    }

    public static class NodesSnapshotStatus
    extends BaseNodesResponse<NodeSnapshotStatus> {
        public NodesSnapshotStatus(StreamInput in) throws IOException {
            super(in);
        }

        public NodesSnapshotStatus(ClusterName clusterName, List<NodeSnapshotStatus> nodes, List<FailedNodeException> failures) {
            super(clusterName, nodes, failures);
        }

        protected List<NodeSnapshotStatus> readNodesFrom(StreamInput in) throws IOException {
            return in.readList(NodeSnapshotStatus::new);
        }

        protected void writeNodesTo(StreamOutput out, List<NodeSnapshotStatus> nodes) throws IOException {
            out.writeList(nodes);
        }
    }
}

