/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.admin.cluster.snapshots.status;

import io.lucenia.action.admin.cluster.snapshots.status.TransportNodesSnapshotsStatus;
import io.skylite.common.action.ActionListener;
import io.skylite.common.action.ActionRunnable;
import io.skylite.common.util.set.Sets;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.StepListener;
import io.skylite.core.action.admin.cluster.snapshots.status.SnapshotIndexShardStage;
import io.skylite.core.action.admin.cluster.snapshots.status.SnapshotIndexShardStatus;
import io.skylite.core.action.admin.cluster.snapshots.status.SnapshotStatus;
import io.skylite.core.action.admin.cluster.snapshots.status.SnapshotsStatusAction;
import io.skylite.core.action.admin.cluster.snapshots.status.SnapshotsStatusRequest;
import io.skylite.core.action.admin.cluster.snapshots.status.SnapshotsStatusResponse;
import io.skylite.core.action.spi.ActionProvider;
import io.skylite.core.action.support.TransportAction;
import io.skylite.core.action.support.clustermanager.TransportClusterManagerNodeAction;
import io.skylite.core.cluster.SnapshotsInProgress;
import io.skylite.core.cluster.block.ClusterBlockException;
import io.skylite.core.cluster.block.ClusterBlockLevel;
import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.common.Strings;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.util.CollectionUtils;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.index.snapshots.IndexShardSnapshotStatus;
import io.skylite.core.repositories.IndexId;
import io.skylite.core.repositories.RepositoriesService;
import io.skylite.core.repositories.Repository;
import io.skylite.core.repositories.RepositoryData;
import io.skylite.core.snapshots.Snapshot;
import io.skylite.core.snapshots.SnapshotId;
import io.skylite.core.snapshots.SnapshotInfo;
import io.skylite.core.snapshots.SnapshotMissingException;
import io.skylite.core.snapshots.SnapshotShardFailure;
import io.skylite.core.snapshots.SnapshotState;
import io.skylite.core.snapshots.SnapshotsService;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TransportSnapshotsStatusAction
extends TransportClusterManagerNodeAction<SnapshotsStatusRequest, SnapshotsStatusResponse> {
    private static final Logger logger = LogManager.getLogger(TransportSnapshotsStatusAction.class);
    private final RepositoriesService repositoriesService;
    private final TransportNodesSnapshotsStatus transportNodesSnapshotsStatus;

    @Inject
    public TransportSnapshotsStatusAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, RepositoriesService repositoriesService, TransportNodesSnapshotsStatus transportNodesSnapshotsStatus, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:admin/snapshot/status", transportService, clusterService, threadPool, actionFilters, SnapshotsStatusRequest::new, indexNameExpressionResolver);
        this.repositoriesService = repositoriesService;
        this.transportNodesSnapshotsStatus = transportNodesSnapshotsStatus;
    }

    protected String executor() {
        return "generic";
    }

    protected ClusterBlockException checkBlock(SnapshotsStatusRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    protected SnapshotsStatusResponse read(StreamInput in) throws IOException {
        return new SnapshotsStatusResponse(in);
    }

    protected void clusterManagerOperation(SnapshotsStatusRequest request, ClusterState state, ActionListener<SnapshotsStatusResponse> listener) throws Exception {
        SnapshotsInProgress snapshotsInProgress = (SnapshotsInProgress)state.custom("snapshots", (ClusterState.Custom)SnapshotsInProgress.EMPTY);
        List currentSnapshots = SnapshotsService.currentSnapshots((SnapshotsInProgress)snapshotsInProgress, (String)request.repository(), Arrays.asList(request.snapshots()));
        if (currentSnapshots.isEmpty()) {
            this.buildResponse(snapshotsInProgress, request, currentSnapshots, null, listener);
            return;
        }
        HashSet<String> nodesIds = new HashSet<String>();
        for (SnapshotsInProgress.Entry entry : currentSnapshots) {
            for (SnapshotsInProgress.ShardSnapshotStatus status : entry.shards().values()) {
                if (status.nodeId() == null) continue;
                nodesIds.add(status.nodeId());
            }
        }
        if (!nodesIds.isEmpty()) {
            Snapshot[] snapshots = new Snapshot[currentSnapshots.size()];
            for (int i = 0; i < currentSnapshots.size(); ++i) {
                snapshots[i] = ((SnapshotsInProgress.Entry)currentSnapshots.get(i)).snapshot();
            }
            this.transportNodesSnapshotsStatus.execute((ActionRequest)((TransportNodesSnapshotsStatus.Request)new TransportNodesSnapshotsStatus.Request(nodesIds.toArray(Strings.EMPTY_ARRAY)).snapshots(snapshots).timeout(request.clusterManagerNodeTimeout())), ActionListenerHelper.wrap(nodeSnapshotStatuses -> this.threadPool.generic().execute((Runnable)ActionRunnable.wrap((ActionListener)listener, l -> this.buildResponse(snapshotsInProgress, request, currentSnapshots, (TransportNodesSnapshotsStatus.NodesSnapshotStatus)((Object)nodeSnapshotStatuses), (ActionListener<SnapshotsStatusResponse>)l))), arg_0 -> listener.onFailure(arg_0)));
        } else {
            this.buildResponse(snapshotsInProgress, request, currentSnapshots, null, listener);
        }
    }

    private void buildResponse(SnapshotsInProgress snapshotsInProgress, SnapshotsStatusRequest request, List<SnapshotsInProgress.Entry> currentSnapshotEntries, TransportNodesSnapshotsStatus.NodesSnapshotStatus nodeSnapshotStatuses, ActionListener<SnapshotsStatusResponse> listener) {
        String repositoryName;
        ArrayList<SnapshotStatus> builder = new ArrayList<SnapshotStatus>();
        HashSet<String> currentSnapshotNames = new HashSet<String>();
        if (!currentSnapshotEntries.isEmpty()) {
            HashMap nodeSnapshotStatusMap = nodeSnapshotStatuses != null ? nodeSnapshotStatuses.getNodesMap() : new HashMap();
            for (SnapshotsInProgress.Entry entry : currentSnapshotEntries) {
                currentSnapshotNames.add(entry.snapshot().getSnapshotId().getName());
                ArrayList<SnapshotIndexShardStatus> shardStatusBuilder = new ArrayList<SnapshotIndexShardStatus>();
                Map indexIdLookup = null;
                for (Map.Entry shardEntry : entry.shards().entrySet()) {
                    SnapshotIndexShardStatus shardStatus;
                    SnapshotIndexShardStatus shardStatus2;
                    Map<ShardId, SnapshotIndexShardStatus> shardStatues;
                    TransportNodesSnapshotsStatus.NodeSnapshotStatus nodeStatus;
                    SnapshotsInProgress.ShardSnapshotStatus status = (SnapshotsInProgress.ShardSnapshotStatus)shardEntry.getValue();
                    if (status.nodeId() != null && (nodeStatus = (TransportNodesSnapshotsStatus.NodeSnapshotStatus)((Object)nodeSnapshotStatusMap.get(status.nodeId()))) != null && (shardStatues = nodeStatus.status().get(entry.snapshot())) != null && (shardStatus2 = shardStatues.get(shardEntry.getKey())) != null) {
                        if (shardStatus2.getStage() == SnapshotIndexShardStage.DONE && ((SnapshotsInProgress.ShardSnapshotStatus)shardEntry.getValue()).state() != SnapshotsInProgress.ShardState.SUCCESS) {
                            shardStatus2 = new SnapshotIndexShardStatus((ShardId)shardEntry.getKey(), SnapshotIndexShardStage.FINALIZE, shardStatus2.getStats(), shardStatus2.getNodeId(), shardStatus2.getFailure());
                        }
                        shardStatusBuilder.add(shardStatus2);
                        continue;
                    }
                    SnapshotIndexShardStage stage = switch (((SnapshotsInProgress.ShardSnapshotStatus)shardEntry.getValue()).state()) {
                        case SnapshotsInProgress.ShardState.FAILED, SnapshotsInProgress.ShardState.ABORTED, SnapshotsInProgress.ShardState.MISSING -> SnapshotIndexShardStage.FAILURE;
                        case SnapshotsInProgress.ShardState.INIT, SnapshotsInProgress.ShardState.WAITING, SnapshotsInProgress.ShardState.QUEUED -> SnapshotIndexShardStage.STARTED;
                        case SnapshotsInProgress.ShardState.SUCCESS -> SnapshotIndexShardStage.DONE;
                        default -> throw new IllegalArgumentException("Unknown snapshot state " + String.valueOf(((SnapshotsInProgress.ShardSnapshotStatus)shardEntry.getValue()).state()));
                    };
                    if (stage == SnapshotIndexShardStage.DONE) {
                        if (indexIdLookup == null) {
                            indexIdLookup = entry.indices().stream().collect(Collectors.toMap(IndexId::getName, Function.identity()));
                        }
                        ShardId shardId = (ShardId)shardEntry.getKey();
                        shardStatus = new SnapshotIndexShardStatus(shardId, this.repositoriesService.repository(entry.repository()).getShardSnapshotStatus(entry.snapshot().getSnapshotId(), (IndexId)indexIdLookup.get(shardId.getIndexName()), shardId).asCopy());
                    } else {
                        shardStatus = new SnapshotIndexShardStatus((ShardId)shardEntry.getKey(), stage);
                    }
                    shardStatusBuilder.add(shardStatus);
                }
                builder.add(new SnapshotStatus(entry.snapshot(), entry.state(), Collections.unmodifiableList(shardStatusBuilder), Boolean.valueOf(entry.includeGlobalState()), entry.startTime(), Math.max(this.threadPool.absoluteTimeInMillis() - entry.startTime(), 0L)));
            }
        }
        if (Strings.hasText((String)(repositoryName = request.repository())) && !CollectionUtils.isEmpty((Object[])request.snapshots())) {
            this.loadRepositoryData(snapshotsInProgress, request, builder, currentSnapshotNames, repositoryName, listener);
        } else {
            listener.onResponse((Object)new SnapshotsStatusResponse(Collections.unmodifiableList(builder)));
        }
    }

    private void loadRepositoryData(SnapshotsInProgress snapshotsInProgress, SnapshotsStatusRequest request, List<SnapshotStatus> builder, Set<String> currentSnapshotNames, String repositoryName, ActionListener<SnapshotsStatusResponse> listener) {
        HashSet requestedSnapshotNames = Sets.newHashSet((Object[])request.snapshots());
        StepListener repositoryDataListener = new StepListener();
        this.repositoriesService.getRepositoryData(repositoryName, (ActionListener)repositoryDataListener);
        repositoryDataListener.whenComplete(repositoryData -> {
            Map matchedSnapshotIds = repositoryData.getSnapshotIds().stream().filter(s -> requestedSnapshotNames.contains(s.getName())).collect(Collectors.toMap(SnapshotId::getName, Function.identity()));
            for (String snapshotName : request.snapshots()) {
                if (currentSnapshotNames.contains(snapshotName)) continue;
                SnapshotId snapshotId = (SnapshotId)matchedSnapshotIds.get(snapshotName);
                if (snapshotId == null) {
                    if (request.ignoreUnavailable()) {
                        logger.debug("snapshot status request ignoring snapshot [{}], not found in repository [{}]", (Object)snapshotName, (Object)repositoryName);
                        continue;
                    }
                    throw new SnapshotMissingException(repositoryName, snapshotName);
                }
                SnapshotInfo snapshotInfo = this.snapshot(snapshotsInProgress, repositoryName, snapshotId);
                ArrayList<SnapshotIndexShardStatus> shardStatusBuilder = new ArrayList<SnapshotIndexShardStatus>();
                if (!snapshotInfo.state().completed()) continue;
                Map<ShardId, IndexShardSnapshotStatus> shardStatuses = this.snapshotShards(repositoryName, (RepositoryData)repositoryData, snapshotInfo);
                for (Map.Entry<ShardId, IndexShardSnapshotStatus> shardStatus : shardStatuses.entrySet()) {
                    IndexShardSnapshotStatus.Copy lastSnapshotStatus = shardStatus.getValue().asCopy();
                    shardStatusBuilder.add(new SnapshotIndexShardStatus(shardStatus.getKey(), lastSnapshotStatus));
                }
                SnapshotsInProgress.State state = switch (snapshotInfo.state()) {
                    case SnapshotState.FAILED -> SnapshotsInProgress.State.FAILED;
                    case SnapshotState.SUCCESS, SnapshotState.PARTIAL -> SnapshotsInProgress.State.SUCCESS;
                    default -> throw new IllegalArgumentException("Unknown snapshot state " + String.valueOf(snapshotInfo.state()));
                };
                long startTime = snapshotInfo.startTime();
                long endTime = snapshotInfo.endTime();
                assert (endTime >= startTime || endTime == 0L && !snapshotInfo.state().completed()) : "Inconsistent timestamps found in SnapshotInfo [" + String.valueOf(snapshotInfo) + "]";
                builder.add(new SnapshotStatus(new Snapshot(repositoryName, snapshotId), state, Collections.unmodifiableList(shardStatusBuilder), snapshotInfo.includeGlobalState(), startTime, (endTime == 0L ? this.threadPool.absoluteTimeInMillis() : endTime) - startTime));
            }
            listener.onResponse((Object)new SnapshotsStatusResponse(Collections.unmodifiableList(builder)));
        }, arg_0 -> listener.onFailure(arg_0));
    }

    private SnapshotInfo snapshot(SnapshotsInProgress snapshotsInProgress, String repositoryName, SnapshotId snapshotId) {
        List entries = SnapshotsService.currentSnapshots((SnapshotsInProgress)snapshotsInProgress, (String)repositoryName, Collections.singletonList(snapshotId.getName()));
        if (!entries.isEmpty()) {
            return new SnapshotInfo((SnapshotsInProgress.Entry)entries.iterator().next());
        }
        return this.repositoriesService.repository(repositoryName).getSnapshotInfo(snapshotId);
    }

    private Map<ShardId, IndexShardSnapshotStatus> snapshotShards(String repositoryName, RepositoryData repositoryData, SnapshotInfo snapshotInfo) throws IOException {
        Repository repository = this.repositoriesService.repository(repositoryName);
        HashMap<ShardId, IndexShardSnapshotStatus> shardStatus = new HashMap<ShardId, IndexShardSnapshotStatus>();
        for (String index : snapshotInfo.indices()) {
            IndexId indexId = repositoryData.resolveIndexId(index);
            IndexMetadata indexMetadata = repository.getSnapshotIndexMetaData(repositoryData, snapshotInfo.snapshotId(), indexId);
            if (indexMetadata == null) continue;
            int numberOfShards = indexMetadata.getNumberOfShards();
            for (int i = 0; i < numberOfShards; ++i) {
                ShardId shardId = new ShardId(indexMetadata.getIndex(), i);
                SnapshotShardFailure shardFailure = TransportSnapshotsStatusAction.findShardFailure(snapshotInfo.shardFailures(), shardId);
                if (shardFailure != null) {
                    shardStatus.put(shardId, IndexShardSnapshotStatus.newFailed((String)shardFailure.reason()));
                    continue;
                }
                IndexShardSnapshotStatus shardSnapshotStatus = snapshotInfo.state() == SnapshotState.FAILED ? IndexShardSnapshotStatus.newFailed((String)"skipped") : repository.getShardSnapshotStatus(snapshotInfo.snapshotId(), indexId, shardId);
                shardStatus.put(shardId, shardSnapshotStatus);
            }
        }
        return Collections.unmodifiableMap(shardStatus);
    }

    private static SnapshotShardFailure findShardFailure(List<SnapshotShardFailure> shardFailures, ShardId shardId) {
        for (SnapshotShardFailure shardFailure : shardFailures) {
            if (!shardId.getIndexName().equals(shardFailure.index()) || shardId.getId() != shardFailure.shardId()) continue;
            return shardFailure;
        }
        return null;
    }

    public static final class ActionProviderImpl
    implements ActionProvider {
        public ActionType<? extends ActionResponse> getInstance() {
            return SnapshotsStatusAction.INSTANCE;
        }

        public Class<? extends TransportAction<? extends ActionRequest, ? extends ActionResponse>> getTransportAction() {
            return TransportSnapshotsStatusAction.class;
        }
    }
}

