/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.admin.cluster.stats;

import io.lucenia.action.support.nodes.TransportNodesAction;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.FailedNodeException;
import io.skylite.core.action.admin.cluster.node.info.NodeInfo;
import io.skylite.core.action.admin.cluster.node.stats.NodeStats;
import io.skylite.core.action.admin.cluster.stats.ClusterStatsAction;
import io.skylite.core.action.admin.cluster.stats.ClusterStatsNodeResponse;
import io.skylite.core.action.admin.cluster.stats.ClusterStatsRequest;
import io.skylite.core.action.admin.cluster.stats.ClusterStatsResponse;
import io.skylite.core.action.admin.indices.stats.CommonStats;
import io.skylite.core.action.admin.indices.stats.CommonStatsFlags;
import io.skylite.core.action.admin.indices.stats.ShardStats;
import io.skylite.core.action.spi.ActionProvider;
import io.skylite.core.action.support.TransportAction;
import io.skylite.core.cluster.health.ClusterHealthStatus;
import io.skylite.core.cluster.health.ClusterStateHealth;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.index.BaseIndexService;
import io.skylite.core.index.engine.CommitStats;
import io.skylite.core.index.seqno.RetentionLeaseStats;
import io.skylite.core.index.seqno.SeqNoStats;
import io.skylite.core.index.shard.BaseIndexShard;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportRequest;
import io.skylite.core.transport.TransportService;
import io.skylite.core.transport.Transports;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.store.AlreadyClosedException;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.indices.IndicesService;
import org.opensearch.node.NodeService;

public class TransportClusterStatsAction
extends TransportNodesAction<ClusterStatsRequest, ClusterStatsResponse, ClusterStatsNodeRequest, ClusterStatsNodeResponse> {
    private static final CommonStatsFlags SHARD_STATS_FLAGS = new CommonStatsFlags(new CommonStatsFlags.Flag[]{CommonStatsFlags.Flag.Docs, CommonStatsFlags.Flag.Store, CommonStatsFlags.Flag.FieldData, CommonStatsFlags.Flag.QueryCache, CommonStatsFlags.Flag.Completion, CommonStatsFlags.Flag.Segments});
    private final NodeService nodeService;
    private final IndicesService indicesService;

    @Inject
    public TransportClusterStatsAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, NodeService nodeService, IndicesService indicesService, ActionFilters actionFilters) {
        super("cluster:monitor/stats", threadPool, clusterService, transportService, actionFilters, ClusterStatsRequest::new, ClusterStatsNodeRequest::new, "management", "management", ClusterStatsNodeResponse.class);
        this.nodeService = nodeService;
        this.indicesService = indicesService;
    }

    @Override
    protected ClusterStatsResponse newResponse(ClusterStatsRequest request, List<ClusterStatsNodeResponse> responses, List<FailedNodeException> failures) {
        assert (Transports.assertNotTransportThread((String)"Constructor of ClusterStatsResponse runs expensive computations on mappings found in the cluster state that are too slow for a transport thread"));
        ClusterState state = this.clusterService.state();
        return new ClusterStatsResponse(System.currentTimeMillis(), state.metadata().clusterUUID(), this.clusterService.getClusterName(), responses, failures, state);
    }

    @Override
    protected ClusterStatsNodeRequest newNodeRequest(ClusterStatsRequest request) {
        return new ClusterStatsNodeRequest(request);
    }

    @Override
    protected ClusterStatsNodeResponse newNodeResponse(StreamInput in) throws IOException {
        return new ClusterStatsNodeResponse(in);
    }

    @Override
    protected ClusterStatsNodeResponse nodeOperation(ClusterStatsNodeRequest nodeRequest) {
        NodeInfo nodeInfo = this.nodeService.info(true, true, false, true, false, true, false, true, false, false, false, false);
        NodeStats nodeStats = this.nodeService.stats(CommonStatsFlags.NONE, true, true, true, false, true, false, false, false, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false);
        ArrayList<ShardStats> shardsStats = new ArrayList<ShardStats>();
        Iterator<BaseIndexService> iterator = this.indicesService.iterator();
        while (iterator.hasNext()) {
            BaseIndexService indexService = iterator.next();
            for (BaseIndexShard baseIndexShard : indexService) {
                RetentionLeaseStats retentionLeaseStats;
                SeqNoStats seqNoStats;
                CommitStats commitStats;
                IndexShard indexShard = (IndexShard)baseIndexShard;
                if (indexShard.routingEntry() == null || !indexShard.routingEntry().active()) continue;
                try {
                    commitStats = indexShard.commitStats();
                    seqNoStats = indexShard.seqNoStats();
                    retentionLeaseStats = indexShard.getRetentionLeaseStats();
                }
                catch (AlreadyClosedException e) {
                    commitStats = null;
                    seqNoStats = null;
                    retentionLeaseStats = null;
                }
                CommonStatsFlags flags = SHARD_STATS_FLAGS;
                shardsStats.add(new ShardStats(indexShard.routingEntry(), indexShard.shardPath(), new CommonStats(flags, indexShard.docStats(), indexShard.storeStats(), indexShard.indexingStats(), indexShard.getStats(), indexShard.searchStats(flags.groups()), indexShard.mergeStats(), indexShard.refreshStats(), indexShard.flushStats(), indexShard.warmerStats(), this.indicesService.getIndicesQueryCache().getStats(indexShard.shardId()), indexShard.fieldDataStats(flags.fieldDataFields()), indexShard.completionStats(flags.completionDataFields()), indexShard.segmentStats(flags.includeSegmentFileSizes(), flags.includeUnloadedSegments()), indexShard.translogStats(), indexShard.requestCache().stats(), indexShard.recoveryStats()), commitStats, seqNoStats, retentionLeaseStats));
            }
        }
        ClusterHealthStatus clusterStatus = null;
        if (this.clusterService.state().nodes().isLocalNodeElectedClusterManager()) {
            clusterStatus = new ClusterStateHealth(this.clusterService.state()).getStatus();
        }
        return new ClusterStatsNodeResponse(nodeInfo.getNode(), clusterStatus, nodeInfo, nodeStats, shardsStats.toArray(new ShardStats[0]));
    }

    public static class ClusterStatsNodeRequest
    extends TransportRequest {
        ClusterStatsRequest request;

        public ClusterStatsNodeRequest(StreamInput in) throws IOException {
            super(in);
            this.request = new ClusterStatsRequest(in);
        }

        ClusterStatsNodeRequest(ClusterStatsRequest request) {
            this.request = request;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.request.writeTo(out);
        }
    }

    public static final class ActionProviderImpl
    implements ActionProvider {
        public ActionType<? extends ActionResponse> getInstance() {
            return ClusterStatsAction.INSTANCE;
        }

        public Class<? extends TransportAction<? extends ActionRequest, ? extends ActionResponse>> getTransportAction() {
            return TransportClusterStatsAction.class;
        }
    }
}

