/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.admin.indices.cache.clear;

import io.lucenia.action.support.broadcast.node.TransportBroadcastByNodeAction;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.admin.indices.cache.clear.ClearIndicesCacheAction;
import io.skylite.core.action.admin.indices.cache.clear.ClearIndicesCacheRequest;
import io.skylite.core.action.admin.indices.cache.clear.ClearIndicesCacheResponse;
import io.skylite.core.action.spi.ActionProvider;
import io.skylite.core.action.support.DefaultShardOperationFailedException;
import io.skylite.core.action.support.TransportAction;
import io.skylite.core.cluster.block.ClusterBlockException;
import io.skylite.core.cluster.block.ClusterBlockLevel;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.routing.ShardRouting;
import io.skylite.core.cluster.routing.ShardsIterator;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.env.NodeEnvironment;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.index.shard.ShardPath;
import io.skylite.core.transport.TransportService;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Predicate;
import org.opensearch.indices.IndicesService;
import org.opensearch.node.Node;

public class TransportClearIndicesCacheAction
extends TransportBroadcastByNodeAction<ClearIndicesCacheRequest, ClearIndicesCacheResponse, TransportBroadcastByNodeAction.EmptyResult> {
    private final IndicesService indicesService;
    private final Node node;

    @Inject
    public TransportClearIndicesCacheAction(ClusterService clusterService, TransportService transportService, IndicesService indicesService, Node node, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("indices:admin/cache/clear", clusterService, transportService, actionFilters, indexNameExpressionResolver, ClearIndicesCacheRequest::new, "management", false);
        this.indicesService = indicesService;
        this.node = node;
    }

    @Override
    protected TransportBroadcastByNodeAction.EmptyResult readShardResult(StreamInput in) throws IOException {
        return TransportBroadcastByNodeAction.EmptyResult.readEmptyResultFrom(in);
    }

    @Override
    protected ClearIndicesCacheResponse newResponse(ClearIndicesCacheRequest request, int totalShards, int successfulShards, int failedShards, List<TransportBroadcastByNodeAction.EmptyResult> responses, List<DefaultShardOperationFailedException> shardFailures, ClusterState clusterState) {
        return new ClearIndicesCacheResponse(totalShards, successfulShards, failedShards, shardFailures);
    }

    @Override
    protected ClearIndicesCacheRequest readRequestFrom(StreamInput in) throws IOException {
        return new ClearIndicesCacheRequest(in);
    }

    @Override
    protected TransportBroadcastByNodeAction.EmptyResult shardOperation(ClearIndicesCacheRequest request, ShardRouting shardRouting) {
        if (request.fileCache() && this.node.fileCache() != null) {
            ShardPath shardPath = ShardPath.loadFileCachePath((NodeEnvironment)this.node.getNodeEnvironment(), (ShardId)shardRouting.shardId());
            Predicate<Path> pathStartsWithShardPathPredicate = path -> path.startsWith(shardPath.getDataPath());
            this.node.fileCache().prune(pathStartsWithShardPathPredicate);
        }
        this.indicesService.clearIndexShardCache(shardRouting.shardId(), request.queryCache(), request.fieldDataCache(), request.requestCache(), request.fields());
        return TransportBroadcastByNodeAction.EmptyResult.INSTANCE;
    }

    @Override
    protected ShardsIterator shards(ClusterState clusterState, ClearIndicesCacheRequest request, String[] concreteIndices) {
        return clusterState.routingTable().allShards(concreteIndices);
    }

    @Override
    protected ClusterBlockException checkGlobalBlock(ClusterState state, ClearIndicesCacheRequest request) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    @Override
    protected ClusterBlockException checkRequestBlock(ClusterState state, ClearIndicesCacheRequest request, String[] concreteIndices) {
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_READ, concreteIndices);
    }

    public static final class ActionProviderImpl
    implements ActionProvider {
        public ActionType<? extends ActionResponse> getInstance() {
            return ClearIndicesCacheAction.INSTANCE;
        }

        public Class<? extends TransportAction<? extends ActionRequest, ? extends ActionResponse>> getTransportAction() {
            return TransportClearIndicesCacheAction.class;
        }
    }
}

