/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.admin.indices.create;

import io.lucenia.action.support.AutoCreateIndex;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.admin.indices.alias.Alias;
import io.skylite.core.action.admin.indices.create.AutoCreateAction;
import io.skylite.core.action.admin.indices.create.CreateIndexClusterStateUpdateRequest;
import io.skylite.core.action.admin.indices.create.CreateIndexRequest;
import io.skylite.core.action.admin.indices.create.CreateIndexResponse;
import io.skylite.core.action.spi.ActionProvider;
import io.skylite.core.action.support.ActiveShardCount;
import io.skylite.core.action.support.ActiveShardsObserver;
import io.skylite.core.action.support.TransportAction;
import io.skylite.core.action.support.clustermanager.TransportClusterManagerNodeAction;
import io.skylite.core.cluster.AckedRequest;
import io.skylite.core.cluster.block.ClusterBlockException;
import io.skylite.core.cluster.block.ClusterBlockLevel;
import io.skylite.core.cluster.metadata.ComposableIndexTemplate;
import io.skylite.core.cluster.metadata.DataStream;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.metadata.Metadata;
import io.skylite.core.cluster.service.ClusterManagerTaskThrottler;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.AckedClusterStateUpdateTask;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.cluster.state.ClusterStateTaskConfig;
import io.skylite.core.cluster.state.ClusterStateUpdateResponse;
import io.skylite.core.common.Priority;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.index.Index;
import io.skylite.core.index.IndexNotFoundException;
import io.skylite.core.indices.SystemIndexDescriptor;
import io.skylite.core.indices.SystemIndices;
import io.skylite.core.settings.Settings;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportService;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.cluster.metadata.MetadataCreateDataStreamService;
import org.opensearch.cluster.metadata.MetadataCreateIndexService;

public final class TransportAutoCreateIndexAction
extends TransportClusterManagerNodeAction<CreateIndexRequest, CreateIndexResponse> {
    private static final Logger logger = LogManager.getLogger(TransportAutoCreateIndexAction.class);
    private final ActiveShardsObserver activeShardsObserver;
    private final MetadataCreateIndexService createIndexService;
    private final MetadataCreateDataStreamService metadataCreateDataStreamService;
    private final AutoCreateIndex autoCreateIndex;
    private final SystemIndices systemIndices;
    private final ClusterManagerTaskThrottler.ThrottlingKey autoCreateTaskKey;

    @Inject
    public TransportAutoCreateIndexAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, MetadataCreateIndexService createIndexService, MetadataCreateDataStreamService metadataCreateDataStreamService, AutoCreateIndex autoCreateIndex, SystemIndices systemIndices) {
        super("indices:admin/auto_create", transportService, clusterService, threadPool, actionFilters, CreateIndexRequest::new, indexNameExpressionResolver);
        this.systemIndices = systemIndices;
        this.activeShardsObserver = new ActiveShardsObserver(clusterService, threadPool);
        this.createIndexService = createIndexService;
        this.metadataCreateDataStreamService = metadataCreateDataStreamService;
        this.autoCreateIndex = autoCreateIndex;
        this.autoCreateTaskKey = clusterService.registerClusterManagerTask("auto-create", true);
    }

    protected String executor() {
        return "same";
    }

    protected CreateIndexResponse read(StreamInput in) throws IOException {
        return new CreateIndexResponse(in);
    }

    protected void clusterManagerOperation(final CreateIndexRequest request, ClusterState state, ActionListener<CreateIndexResponse> finalListener) {
        final AtomicReference indexNameRef = new AtomicReference();
        ActionListener listener = ActionListenerHelper.wrap(response -> {
            String indexName = (String)indexNameRef.get();
            assert (indexName != null);
            if (response.isAcknowledged()) {
                this.activeShardsObserver.waitForActiveShards(new String[]{indexName}, ActiveShardCount.DEFAULT, request.timeout(), shardsAcked -> finalListener.onResponse((Object)new CreateIndexResponse(true, shardsAcked.booleanValue(), indexName)), arg_0 -> ((ActionListener)finalListener).onFailure(arg_0));
            } else {
                finalListener.onResponse((Object)new CreateIndexResponse(false, false, indexName));
            }
        }, arg_0 -> finalListener.onFailure(arg_0));
        this.clusterService.submitStateUpdateTask("auto create [" + request.index() + "]", (ClusterStateTaskConfig)new AckedClusterStateUpdateTask<ClusterStateUpdateResponse>(Priority.URGENT, (AckedRequest)request, listener){

            protected ClusterStateUpdateResponse newResponse(boolean acknowledged) {
                return new ClusterStateUpdateResponse(acknowledged);
            }

            public ClusterManagerTaskThrottler.ThrottlingKey getClusterManagerThrottlingKey() {
                return TransportAutoCreateIndexAction.this.autoCreateTaskKey;
            }

            public ClusterState execute(ClusterState currentState) throws Exception {
                ComposableIndexTemplate template = AutoCreateAction.resolveTemplate((CreateIndexRequest)request, (Metadata)currentState.metadata());
                if (template != null && template.getDataStreamTemplate() != null) {
                    if (Boolean.FALSE.equals(template.getAllowAutoCreate())) {
                        throw new IndexNotFoundException("composable template " + String.valueOf(template.indexPatterns()) + " forbids index auto creation");
                    }
                    MetadataCreateDataStreamService.CreateDataStreamClusterStateUpdateRequest createRequest = new MetadataCreateDataStreamService.CreateDataStreamClusterStateUpdateRequest(request.index(), request.clusterManagerNodeTimeout(), request.timeout());
                    ClusterState clusterState = TransportAutoCreateIndexAction.this.metadataCreateDataStreamService.createDataStream(createRequest, currentState);
                    indexNameRef.set(((Index)((DataStream)clusterState.metadata().dataStreams().get(request.index())).getIndices().get(0)).getName());
                    return clusterState;
                }
                String indexName = TransportAutoCreateIndexAction.this.indexNameExpressionResolver.resolveDateMathExpression(request.index());
                indexNameRef.set(indexName);
                boolean shouldAutoCreate = TransportAutoCreateIndexAction.this.autoCreateIndex.shouldAutoCreate(indexName, currentState);
                if (!shouldAutoCreate) {
                    return currentState;
                }
                SystemIndexDescriptor descriptor = TransportAutoCreateIndexAction.this.systemIndices.findMatchingDescriptor(indexName);
                CreateIndexClusterStateUpdateRequest updateRequest = descriptor != null && descriptor.isAutomaticallyManaged() ? this.buildSystemIndexUpdateRequest(descriptor) : this.buildUpdateRequest(indexName);
                return TransportAutoCreateIndexAction.this.createIndexService.applyCreateIndexRequest(currentState, updateRequest, false);
            }

            private CreateIndexClusterStateUpdateRequest buildUpdateRequest(String indexName) {
                CreateIndexClusterStateUpdateRequest updateRequest = (CreateIndexClusterStateUpdateRequest)((CreateIndexClusterStateUpdateRequest)new CreateIndexClusterStateUpdateRequest(request.cause(), indexName, request.index()).ackTimeout(request.timeout())).masterNodeTimeout(request.masterNodeTimeout());
                logger.debug("Auto-creating index {}", (Object)indexName);
                return updateRequest;
            }

            private CreateIndexClusterStateUpdateRequest buildSystemIndexUpdateRequest(SystemIndexDescriptor descriptor) {
                String mappings = descriptor.getMappings();
                Settings settings = descriptor.getSettings();
                String aliasName = descriptor.getAliasName();
                String concreteIndexName = descriptor.getPrimaryIndex();
                CreateIndexClusterStateUpdateRequest updateRequest = (CreateIndexClusterStateUpdateRequest)((CreateIndexClusterStateUpdateRequest)new CreateIndexClusterStateUpdateRequest(request.cause(), concreteIndexName, request.index()).ackTimeout(request.timeout())).masterNodeTimeout(request.masterNodeTimeout());
                updateRequest.waitForActiveShards(ActiveShardCount.ALL);
                if (mappings != null) {
                    updateRequest.mappings(mappings);
                }
                if (settings != null) {
                    updateRequest.settings(settings);
                }
                if (aliasName != null) {
                    updateRequest.aliases(Set.of(new Alias(aliasName)));
                }
                logger.debug("Auto-creating system index {}", (Object)concreteIndexName);
                return updateRequest;
            }
        });
    }

    protected ClusterBlockException checkBlock(CreateIndexRequest request, ClusterState state) {
        return state.blocks().indexBlockedException(ClusterBlockLevel.METADATA_WRITE, request.index());
    }

    public static final class ActionProviderImpl
    implements ActionProvider {
        public ActionType<? extends ActionResponse> getInstance() {
            return AutoCreateAction.INSTANCE;
        }

        public Class<? extends TransportAction<? extends ActionRequest, ? extends ActionResponse>> getTransportAction() {
            return TransportAutoCreateIndexAction.class;
        }
    }
}

