/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.admin.indices.dangling.delete;

import io.skylite.SkyliteException;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.FailedNodeException;
import io.skylite.core.action.admin.indices.dangling.DanglingIndexInfo;
import io.skylite.core.action.admin.indices.dangling.delete.DeleteDanglingIndexAction;
import io.skylite.core.action.admin.indices.dangling.delete.DeleteDanglingIndexRequest;
import io.skylite.core.action.admin.indices.dangling.list.ListDanglingIndicesAction;
import io.skylite.core.action.admin.indices.dangling.list.ListDanglingIndicesRequest;
import io.skylite.core.action.admin.indices.dangling.list.ListDanglingIndicesResponse;
import io.skylite.core.action.admin.indices.dangling.list.NodeListDanglingIndicesResponse;
import io.skylite.core.action.clustermanager.AcknowledgedResponse;
import io.skylite.core.action.spi.ActionProvider;
import io.skylite.core.action.support.TransportAction;
import io.skylite.core.action.support.clustermanager.TransportClusterManagerNodeAction;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.cluster.AckedRequest;
import io.skylite.core.cluster.block.ClusterBlockException;
import io.skylite.core.cluster.metadata.IndexGraveyard;
import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.metadata.Metadata;
import io.skylite.core.cluster.service.ClusterManagerTaskThrottler;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.AckedClusterStateUpdateTask;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.cluster.state.ClusterStateTaskConfig;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.index.Index;
import io.skylite.core.settings.Settings;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportService;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TransportDeleteDanglingIndexAction
extends TransportClusterManagerNodeAction<DeleteDanglingIndexRequest, AcknowledgedResponse> {
    private static final Logger logger = LogManager.getLogger(TransportDeleteDanglingIndexAction.class);
    private final Settings settings;
    private final NodeClient nodeClient;
    private final ClusterManagerTaskThrottler.ThrottlingKey deleteDanglingIndexTaskKey;

    @Inject
    public TransportDeleteDanglingIndexAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Settings settings, NodeClient nodeClient) {
        super("cluster:admin/indices/dangling/delete", transportService, clusterService, threadPool, actionFilters, DeleteDanglingIndexRequest::new, indexNameExpressionResolver);
        this.settings = settings;
        this.nodeClient = nodeClient;
        this.deleteDanglingIndexTaskKey = clusterService.registerClusterManagerTask("delete-dangling-index", true);
    }

    protected String executor() {
        return "generic";
    }

    protected AcknowledgedResponse read(StreamInput in) throws IOException {
        return new AcknowledgedResponse(in);
    }

    protected void clusterManagerOperation(final DeleteDanglingIndexRequest deleteRequest, ClusterState state, final ActionListener<AcknowledgedResponse> deleteListener) throws Exception {
        this.findDanglingIndex(deleteRequest.getIndexUUID(), new ActionListener<Index>(){

            public void onResponse(final Index indexToDelete) {
                if (!deleteRequest.isAcceptDataLoss()) {
                    deleteListener.onFailure((Exception)new IllegalArgumentException("accept_data_loss must be set to true"));
                    return;
                }
                final String indexName = indexToDelete.getName();
                final String indexUUID = indexToDelete.getUUID();
                ActionListener<AcknowledgedResponse> clusterStateUpdatedListener = new ActionListener<AcknowledgedResponse>(){

                    public void onResponse(AcknowledgedResponse response) {
                        deleteListener.onResponse((Object)response);
                    }

                    public void onFailure(Exception e) {
                        logger.debug("Failed to delete dangling index [" + indexName + "] [" + indexUUID + "]", (Throwable)e);
                        deleteListener.onFailure(e);
                    }
                };
                String taskSource = "delete-dangling-index [" + indexName + "] [" + indexUUID + "]";
                TransportDeleteDanglingIndexAction.this.clusterService.submitStateUpdateTask(taskSource, (ClusterStateTaskConfig)new AckedClusterStateUpdateTask<AcknowledgedResponse>((AckedRequest)deleteRequest, (ActionListener)clusterStateUpdatedListener){

                    protected AcknowledgedResponse newResponse(boolean acknowledged) {
                        return new AcknowledgedResponse(acknowledged);
                    }

                    public ClusterManagerTaskThrottler.ThrottlingKey getClusterManagerThrottlingKey() {
                        return TransportDeleteDanglingIndexAction.this.deleteDanglingIndexTaskKey;
                    }

                    public ClusterState execute(ClusterState currentState) {
                        return TransportDeleteDanglingIndexAction.this.deleteDanglingIndex(currentState, indexToDelete);
                    }
                });
            }

            public void onFailure(Exception e) {
                logger.debug("Failed to find dangling index [" + deleteRequest.getIndexUUID() + "]", (Throwable)e);
                deleteListener.onFailure(e);
            }
        });
    }

    private ClusterState deleteDanglingIndex(ClusterState currentState, Index indexToDelete) {
        Metadata metaData = currentState.getMetadata();
        for (IndexMetadata each : metaData.indices().values()) {
            if (!indexToDelete.getUUID().equals(each.getIndexUUID())) continue;
            throw new IllegalArgumentException("Refusing to delete dangling index " + String.valueOf(indexToDelete) + " as an index with UUID [" + indexToDelete.getUUID() + "] already exists in the cluster state");
        }
        if (metaData.indexGraveyard().containsIndex(indexToDelete)) {
            return currentState;
        }
        Metadata.Builder metaDataBuilder = Metadata.builder((Metadata)metaData);
        IndexGraveyard newGraveyard = IndexGraveyard.builder((IndexGraveyard)metaDataBuilder.indexGraveyard()).addTombstone(indexToDelete).build(this.settings);
        metaDataBuilder.indexGraveyard(newGraveyard);
        return ClusterState.builder((ClusterState)currentState).metadata(metaDataBuilder.build()).build();
    }

    protected ClusterBlockException checkBlock(DeleteDanglingIndexRequest request, ClusterState state) {
        return null;
    }

    private void findDanglingIndex(final String indexUUID, final ActionListener<Index> listener) {
        this.nodeClient.execute((ActionType)ListDanglingIndicesAction.INSTANCE, (ActionRequest)new ListDanglingIndicesRequest(indexUUID), (ActionListener)new ActionListener<ListDanglingIndicesResponse>(){

            public void onResponse(ListDanglingIndicesResponse response) {
                if (response.hasFailures()) {
                    String nodeIds = response.failures().stream().map(FailedNodeException::nodeId).collect(Collectors.joining(","));
                    SkyliteException e = new SkyliteException("Failed to query nodes [" + nodeIds + "]", new Object[0]);
                    for (FailedNodeException failure : response.failures()) {
                        logger.error("Failed to query node [" + failure.nodeId() + "]", (Throwable)failure);
                        e.addSuppressed((Throwable)failure);
                    }
                    listener.onFailure((Exception)e);
                    return;
                }
                List nodes = response.getNodes();
                for (NodeListDanglingIndicesResponse nodeResponse : nodes) {
                    for (DanglingIndexInfo each : nodeResponse.getDanglingIndices()) {
                        if (!each.getIndexUUID().equals(indexUUID)) continue;
                        listener.onResponse((Object)new Index(each.getIndexName(), each.getIndexUUID()));
                        return;
                    }
                }
                listener.onFailure((Exception)new IllegalArgumentException("No dangling index found for UUID [" + indexUUID + "]"));
            }

            public void onFailure(Exception exp) {
                listener.onFailure(exp);
            }
        });
    }

    public static final class ActionProviderImpl
    implements ActionProvider {
        public ActionType<? extends ActionResponse> getInstance() {
            return DeleteDanglingIndexAction.INSTANCE;
        }

        public Class<? extends TransportAction<? extends ActionRequest, ? extends ActionResponse>> getTransportAction() {
            return TransportDeleteDanglingIndexAction.class;
        }
    }
}

