/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.admin.indices.dangling.find;

import io.lucenia.action.support.nodes.TransportNodesAction;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.FailedNodeException;
import io.skylite.core.action.admin.indices.dangling.find.FindDanglingIndexAction;
import io.skylite.core.action.admin.indices.dangling.find.FindDanglingIndexRequest;
import io.skylite.core.action.admin.indices.dangling.find.FindDanglingIndexResponse;
import io.skylite.core.action.admin.indices.dangling.find.NodeFindDanglingIndexRequest;
import io.skylite.core.action.admin.indices.dangling.find.NodeFindDanglingIndexResponse;
import io.skylite.core.action.spi.ActionProvider;
import io.skylite.core.action.support.TransportAction;
import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.opensearch.gateway.DanglingIndicesState;

public class TransportFindDanglingIndexAction
extends TransportNodesAction<FindDanglingIndexRequest, FindDanglingIndexResponse, NodeFindDanglingIndexRequest, NodeFindDanglingIndexResponse> {
    private final TransportService transportService;
    private final DanglingIndicesState danglingIndicesState;

    @Inject
    public TransportFindDanglingIndexAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, DanglingIndicesState danglingIndicesState) {
        super("cluster:admin/indices/dangling/find", threadPool, clusterService, transportService, actionFilters, FindDanglingIndexRequest::new, NodeFindDanglingIndexRequest::new, "management", NodeFindDanglingIndexResponse.class);
        this.transportService = transportService;
        this.danglingIndicesState = danglingIndicesState;
    }

    @Override
    protected FindDanglingIndexResponse newResponse(FindDanglingIndexRequest request, List<NodeFindDanglingIndexResponse> nodeResponses, List<FailedNodeException> failures) {
        return new FindDanglingIndexResponse(this.clusterService.getClusterName(), nodeResponses, failures);
    }

    @Override
    protected NodeFindDanglingIndexRequest newNodeRequest(FindDanglingIndexRequest request) {
        return new NodeFindDanglingIndexRequest(request.getIndexUUID());
    }

    @Override
    protected NodeFindDanglingIndexResponse newNodeResponse(StreamInput in) throws IOException {
        return new NodeFindDanglingIndexResponse(in);
    }

    @Override
    protected NodeFindDanglingIndexResponse nodeOperation(NodeFindDanglingIndexRequest request) {
        DiscoveryNode localNode = this.transportService.getLocalNode();
        String indexUUID = request.getIndexUUID();
        ArrayList<IndexMetadata> danglingIndexInfo = new ArrayList<IndexMetadata>();
        for (IndexMetadata each : this.danglingIndicesState.getDanglingIndices().values()) {
            if (!each.getIndexUUID().equals(indexUUID)) continue;
            danglingIndexInfo.add(each);
        }
        return new NodeFindDanglingIndexResponse(localNode, danglingIndexInfo);
    }

    public static final class ActionProviderImpl
    implements ActionProvider {
        public ActionType<? extends ActionResponse> getInstance() {
            return FindDanglingIndexAction.INSTANCE;
        }

        public Class<? extends TransportAction<? extends ActionRequest, ? extends ActionResponse>> getTransportAction() {
            return TransportFindDanglingIndexAction.class;
        }
    }
}

