/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.admin.indices.datastream;

import io.lucenia.action.support.broadcast.node.TransportBroadcastByNodeAction;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.admin.indices.datastream.DataStreamsStatsAction;
import io.skylite.core.action.spi.ActionProvider;
import io.skylite.core.action.support.DefaultShardOperationFailedException;
import io.skylite.core.action.support.TransportAction;
import io.skylite.core.cluster.block.ClusterBlockException;
import io.skylite.core.cluster.block.ClusterBlockLevel;
import io.skylite.core.cluster.metadata.IndexAbstraction;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.routing.ShardRouting;
import io.skylite.core.cluster.routing.ShardsIterator;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.unit.ByteSizeValue;
import io.skylite.core.index.engine.Engine;
import io.skylite.core.index.shard.ShardNotFoundException;
import io.skylite.core.index.store.StoreStats;
import io.skylite.core.transport.TransportService;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.SortedMap;
import java.util.stream.Stream;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.PointValues;
import org.opensearch.cluster.metadata.IndexAbstractionResolver;
import org.opensearch.index.IndexService;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.indices.IndicesService;

public class TransportDataStreamsStatsAction
extends TransportBroadcastByNodeAction<DataStreamsStatsAction.Request, DataStreamsStatsAction.Response, DataStreamsStatsAction.DataStreamShardStats> {
    private final ClusterService clusterService;
    private final IndicesService indicesService;
    private final IndexAbstractionResolver indexAbstractionResolver;

    @Inject
    public TransportDataStreamsStatsAction(ClusterService clusterService, TransportService transportService, IndicesService indicesService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("indices:monitor/data_stream/stats", clusterService, transportService, actionFilters, indexNameExpressionResolver, DataStreamsStatsAction.Request::new, "management");
        this.clusterService = clusterService;
        this.indicesService = indicesService;
        this.indexAbstractionResolver = new IndexAbstractionResolver(indexNameExpressionResolver);
    }

    @Override
    protected DataStreamsStatsAction.Request readRequestFrom(StreamInput in) throws IOException {
        return new DataStreamsStatsAction.Request(in);
    }

    @Override
    protected ClusterBlockException checkGlobalBlock(ClusterState state, DataStreamsStatsAction.Request request) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    @Override
    protected ClusterBlockException checkRequestBlock(ClusterState state, DataStreamsStatsAction.Request request, String[] concreteIndices) {
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_READ, concreteIndices);
    }

    @Override
    protected ShardsIterator shards(ClusterState clusterState, DataStreamsStatsAction.Request request, String[] concreteIndices) {
        String[] requestIndices = request.indices();
        if (requestIndices == null || requestIndices.length == 0) {
            requestIndices = new String[]{"*"};
        }
        List<String> abstractionNames = this.indexAbstractionResolver.resolveIndexAbstractions(requestIndices, request.indicesOptions(), clusterState.getMetadata(), true);
        SortedMap indicesLookup = clusterState.getMetadata().getIndicesLookup();
        String[] concreteDatastreamIndices = (String[])abstractionNames.stream().flatMap(abstractionName -> {
            IndexAbstraction indexAbstraction = (IndexAbstraction)indicesLookup.get(abstractionName);
            assert (indexAbstraction != null);
            if (indexAbstraction.getType() == IndexAbstraction.Type.DATA_STREAM) {
                IndexAbstraction.DataStream dataStream = (IndexAbstraction.DataStream)indexAbstraction;
                List indices = dataStream.getIndices();
                return indices.stream().map(idx -> idx.getIndex().getName());
            }
            return Stream.empty();
        }).toArray(String[]::new);
        return clusterState.getRoutingTable().allShards(concreteDatastreamIndices);
    }

    @Override
    protected DataStreamsStatsAction.DataStreamShardStats shardOperation(DataStreamsStatsAction.Request request, ShardRouting shardRouting) throws IOException {
        IndexService indexService = this.indicesService.indexServiceSafe(shardRouting.shardId().getIndex());
        IndexShard indexShard = indexService.getShard(shardRouting.shardId().id());
        if (indexShard.routingEntry() == null) {
            throw new ShardNotFoundException(indexShard.shardId());
        }
        StoreStats storeStats = indexShard.storeStats();
        IndexAbstraction indexAbstraction = (IndexAbstraction)this.clusterService.state().getMetadata().getIndicesLookup().get(shardRouting.getIndexName());
        assert (indexAbstraction != null);
        IndexAbstraction.DataStream dataStream = indexAbstraction.getParentDataStream();
        assert (dataStream != null);
        long maxTimestamp = 0L;
        try (Engine.Searcher searcher = indexShard.acquireSearcher("data_stream_stats");){
            IndexReader indexReader = searcher.getIndexReader();
            String fieldName = dataStream.getDataStream().getTimeStampField().getName();
            byte[] maxPackedValue = PointValues.getMaxPackedValue((IndexReader)indexReader, (String)fieldName);
            if (maxPackedValue != null) {
                maxTimestamp = LongPoint.decodeDimension((byte[])maxPackedValue, (int)0);
            }
        }
        return new DataStreamsStatsAction.DataStreamShardStats(indexShard.routingEntry(), storeStats, maxTimestamp);
    }

    @Override
    protected DataStreamsStatsAction.DataStreamShardStats readShardResult(StreamInput in) throws IOException {
        return new DataStreamsStatsAction.DataStreamShardStats(in);
    }

    @Override
    protected DataStreamsStatsAction.Response newResponse(DataStreamsStatsAction.Request request, int totalShards, int successfulShards, int failedShards, List<DataStreamsStatsAction.DataStreamShardStats> dataStreamShardStats, List<DefaultShardOperationFailedException> shardFailures, ClusterState clusterState) {
        HashMap<String, DataStreamsStatsAction.AggregatedStats> aggregatedDataStreamsStats = new HashMap<String, DataStreamsStatsAction.AggregatedStats>();
        HashSet<String> allBackingIndices = new HashSet<String>();
        long totalStoreSizeBytes = 0L;
        SortedMap indicesLookup = clusterState.getMetadata().getIndicesLookup();
        for (DataStreamsStatsAction.DataStreamShardStats shardStat : dataStreamShardStats) {
            String indexName = shardStat.getShardRouting().getIndexName();
            IndexAbstraction indexAbstraction = (IndexAbstraction)indicesLookup.get(indexName);
            IndexAbstraction.DataStream dataStream = indexAbstraction.getParentDataStream();
            assert (dataStream != null);
            totalStoreSizeBytes += shardStat.getStoreStats().sizeInBytes();
            allBackingIndices.add(indexName);
            DataStreamsStatsAction.AggregatedStats stats = aggregatedDataStreamsStats.computeIfAbsent(dataStream.getName(), s -> new DataStreamsStatsAction.AggregatedStats());
            stats.storageBytes().addAndGet(shardStat.getStoreStats().sizeInBytes());
            stats.maxTimestamp().addAndGet(Math.max(stats.maxTimestamp().get(), shardStat.getMaxTimestamp()));
            stats.backingIndices().add(indexName);
        }
        DataStreamsStatsAction.DataStreamStats[] dataStreamStats = (DataStreamsStatsAction.DataStreamStats[])aggregatedDataStreamsStats.entrySet().stream().map(entry -> new DataStreamsStatsAction.DataStreamStats((String)entry.getKey(), ((DataStreamsStatsAction.AggregatedStats)entry.getValue()).backingIndices().size(), new ByteSizeValue(((DataStreamsStatsAction.AggregatedStats)entry.getValue()).storageBytes().get()), ((DataStreamsStatsAction.AggregatedStats)entry.getValue()).maxTimestamp().get())).toArray(DataStreamsStatsAction.DataStreamStats[]::new);
        return new DataStreamsStatsAction.Response(totalShards, successfulShards, failedShards, shardFailures, aggregatedDataStreamsStats.size(), allBackingIndices.size(), new ByteSizeValue(totalStoreSizeBytes), dataStreamStats);
    }

    public static final class ActionProviderImpl
    implements ActionProvider {
        public ActionType<? extends ActionResponse> getInstance() {
            return DataStreamsStatsAction.INSTANCE;
        }

        public Class<? extends TransportAction<? extends ActionRequest, ? extends ActionResponse>> getTransportAction() {
            return TransportDataStreamsStatsAction.class;
        }
    }
}

