/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.admin.indices.datastream;

import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.admin.indices.datastream.GetDataStreamAction;
import io.skylite.core.action.spi.ActionProvider;
import io.skylite.core.action.support.TransportAction;
import io.skylite.core.action.support.clustermanager.TransportClusterManagerNodeReadAction;
import io.skylite.core.cluster.block.ClusterBlockException;
import io.skylite.core.cluster.block.ClusterBlockLevel;
import io.skylite.core.cluster.health.ClusterStateHealth;
import io.skylite.core.cluster.metadata.DataStream;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.metadata.Metadata;
import io.skylite.core.cluster.metadata.MetadataIndexTemplateUtility;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.index.Index;
import io.skylite.core.settings.Settings;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TransportGetDataStreamAction
extends TransportClusterManagerNodeReadAction<GetDataStreamAction.Request, GetDataStreamAction.Response> {
    private static final Logger logger = LogManager.getLogger(TransportGetDataStreamAction.class);

    @Inject
    public TransportGetDataStreamAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("indices:admin/data_stream/get", transportService, clusterService, threadPool, actionFilters, GetDataStreamAction.Request::new, indexNameExpressionResolver);
    }

    protected String executor() {
        return "same";
    }

    protected GetDataStreamAction.Response read(StreamInput in) throws IOException {
        return new GetDataStreamAction.Response(in);
    }

    protected void clusterManagerOperation(GetDataStreamAction.Request request, ClusterState state, ActionListener<GetDataStreamAction.Response> listener) throws Exception {
        List<DataStream> dataStreams = TransportGetDataStreamAction.getDataStreams(state, this.indexNameExpressionResolver, request);
        ArrayList<GetDataStreamAction.Response.DataStreamInfo> dataStreamInfos = new ArrayList<GetDataStreamAction.Response.DataStreamInfo>(dataStreams.size());
        for (DataStream dataStream : dataStreams) {
            String indexTemplate = MetadataIndexTemplateUtility.findV2Template((Metadata)state.metadata(), (String)dataStream.getName(), (boolean)false);
            String ilmPolicyName = null;
            if (indexTemplate != null) {
                Settings settings = MetadataIndexTemplateUtility.resolveSettings((Metadata)state.metadata(), (String)indexTemplate);
                ilmPolicyName = settings.get("index.lifecycle.name");
            } else {
                logger.warn("couldn't find any matching template for data stream [{}]. has it been restored (and possibly renamed)from a snapshot?", (Object)dataStream.getName());
            }
            ClusterStateHealth streamHealth = new ClusterStateHealth(state, (String[])dataStream.getIndices().stream().map(Index::getName).toArray(String[]::new));
            dataStreamInfos.add(new GetDataStreamAction.Response.DataStreamInfo(dataStream, streamHealth.getStatus(), indexTemplate));
        }
        listener.onResponse((Object)new GetDataStreamAction.Response(dataStreamInfos));
    }

    static List<DataStream> getDataStreams(ClusterState clusterState, IndexNameExpressionResolver iner, GetDataStreamAction.Request request) {
        List results = iner.dataStreamNames(clusterState, request.indicesOptions(), request.names());
        Map dataStreams = clusterState.metadata().dataStreams();
        return results.stream().map(dataStreams::get).sorted(Comparator.comparing(DataStream::getName)).collect(Collectors.toList());
    }

    protected ClusterBlockException checkBlock(GetDataStreamAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    public static final class ActionProviderImpl
    implements ActionProvider {
        public ActionType<? extends ActionResponse> getInstance() {
            return GetDataStreamAction.INSTANCE;
        }

        public Class<? extends TransportAction<? extends ActionRequest, ? extends ActionResponse>> getTransportAction() {
            return TransportGetDataStreamAction.class;
        }
    }
}

