/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.admin.indices.mapping.put;

import io.lucenia.action.admin.indices.mapping.put.TransportPutMappingAction;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.admin.indices.mapping.put.AutoPutMappingAction;
import io.skylite.core.action.admin.indices.mapping.put.PutMappingRequest;
import io.skylite.core.action.clustermanager.AcknowledgedResponse;
import io.skylite.core.action.clustermanager.ClusterManagerNodeRequest;
import io.skylite.core.action.spi.ActionProvider;
import io.skylite.core.action.support.TransportAction;
import io.skylite.core.action.support.clustermanager.TransportClusterManagerNodeAction;
import io.skylite.core.cluster.block.ClusterBlockException;
import io.skylite.core.cluster.block.ClusterBlockLevel;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.index.Index;
import io.skylite.core.tasks.Task;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportService;
import java.io.IOException;
import org.opensearch.cluster.metadata.MetadataMappingService;

public class TransportAutoPutMappingAction
extends TransportClusterManagerNodeAction<PutMappingRequest, AcknowledgedResponse> {
    private final MetadataMappingService metadataMappingService;

    @Inject
    public TransportAutoPutMappingAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, MetadataMappingService metadataMappingService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("indices:admin/mapping/auto_put", transportService, clusterService, threadPool, actionFilters, PutMappingRequest::new, indexNameExpressionResolver);
        this.metadataMappingService = metadataMappingService;
    }

    protected String executor() {
        return "same";
    }

    protected AcknowledgedResponse read(StreamInput in) throws IOException {
        return new AcknowledgedResponse(in);
    }

    protected void doExecute(Task task, PutMappingRequest request, ActionListener<AcknowledgedResponse> listener) {
        if (request.getConcreteIndex() == null) {
            throw new IllegalArgumentException("concrete index missing");
        }
        super.doExecute(task, (ClusterManagerNodeRequest)request, listener);
    }

    protected ClusterBlockException checkBlock(PutMappingRequest request, ClusterState state) {
        String[] indices = new String[]{request.getConcreteIndex().getName()};
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_WRITE, indices);
    }

    protected void clusterManagerOperation(PutMappingRequest request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        Index[] concreteIndices = new Index[]{request.getConcreteIndex()};
        TransportPutMappingAction.performMappingUpdate(concreteIndices, request, listener, this.metadataMappingService);
    }

    public static final class ActionProviderImpl
    implements ActionProvider {
        public ActionType<? extends ActionResponse> getInstance() {
            return AutoPutMappingAction.INSTANCE;
        }

        public Class<? extends TransportAction<? extends ActionRequest, ? extends ActionResponse>> getTransportAction() {
            return TransportAutoPutMappingAction.class;
        }
    }
}

