/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.admin.indices.mapping.put;

import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.IndicesRequest;
import io.skylite.core.action.RequestValidators;
import io.skylite.core.action.admin.indices.mapping.put.PutMappingAction;
import io.skylite.core.action.admin.indices.mapping.put.PutMappingClusterStateUpdateRequest;
import io.skylite.core.action.admin.indices.mapping.put.PutMappingRequest;
import io.skylite.core.action.clustermanager.AcknowledgedResponse;
import io.skylite.core.action.spi.ActionProvider;
import io.skylite.core.action.support.TransportAction;
import io.skylite.core.action.support.clustermanager.TransportClusterManagerNodeAction;
import io.skylite.core.cluster.block.ClusterBlockException;
import io.skylite.core.cluster.block.ClusterBlockLevel;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.cluster.state.ClusterStateUpdateResponse;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.index.Index;
import io.skylite.core.index.IndexNotFoundException;
import io.skylite.core.indices.SystemIndexDescriptor;
import io.skylite.core.indices.SystemIndices;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.cluster.metadata.MetadataMappingService;

public class TransportPutMappingAction
extends TransportClusterManagerNodeAction<PutMappingRequest, AcknowledgedResponse> {
    private static final Logger logger = LogManager.getLogger(TransportPutMappingAction.class);
    private final MetadataMappingService metadataMappingService;
    private final RequestValidators<PutMappingRequest> requestValidators;
    private final SystemIndices systemIndices;

    @Inject
    public TransportPutMappingAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, MetadataMappingService metadataMappingService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, RequestValidators<PutMappingRequest> requestValidators, SystemIndices systemIndices) {
        super("indices:admin/mapping/put", transportService, clusterService, threadPool, actionFilters, PutMappingRequest::new, indexNameExpressionResolver);
        this.metadataMappingService = metadataMappingService;
        this.requestValidators = Objects.requireNonNull(requestValidators);
        this.systemIndices = systemIndices;
    }

    protected String executor() {
        return "same";
    }

    protected AcknowledgedResponse read(StreamInput in) throws IOException {
        return new AcknowledgedResponse(in);
    }

    protected ClusterBlockException checkBlock(PutMappingRequest request, ClusterState state) {
        String[] indices = request.getConcreteIndex() == null ? this.indexNameExpressionResolver.concreteIndexNames(state, (IndicesRequest)request) : new String[]{request.getConcreteIndex().getName()};
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_WRITE, indices);
    }

    protected void clusterManagerOperation(PutMappingRequest request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        try {
            Index[] concreteIndices = TransportPutMappingAction.resolveIndices(state, request, this.indexNameExpressionResolver);
            String mappingSource = request.source();
            Optional maybeValidationException = this.requestValidators.validateRequest((ActionRequest)request, state, concreteIndices);
            if (maybeValidationException.isPresent()) {
                listener.onFailure((Exception)maybeValidationException.get());
                return;
            }
            List<String> violations = this.checkForSystemIndexViolations(concreteIndices, mappingSource);
            if (!violations.isEmpty()) {
                String message = "Cannot update mappings in " + String.valueOf(violations) + ": system indices can only use mappings from their descriptors, but the mappings in the request did not match those in the descriptors(s)";
                logger.warn(message);
                listener.onFailure((Exception)new IllegalArgumentException(message));
                return;
            }
            TransportPutMappingAction.performMappingUpdate(concreteIndices, request, listener, this.metadataMappingService);
        }
        catch (IndexNotFoundException ex) {
            logger.debug(() -> new ParameterizedMessage("failed to put mappings on indices [{}]", Arrays.asList(request.indices())), (Throwable)ex);
            throw ex;
        }
    }

    static Index[] resolveIndices(ClusterState state, PutMappingRequest request, IndexNameExpressionResolver iner) {
        if (request.getConcreteIndex() == null) {
            if (request.writeIndexOnly()) {
                ArrayList<Index> indices = new ArrayList<Index>();
                for (String indexExpression : request.indices()) {
                    indices.add(iner.concreteWriteIndex(state, request.indicesOptions(), indexExpression, request.indicesOptions().allowNoIndices(), request.includeDataStreams()));
                }
                return indices.toArray(Index.EMPTY_ARRAY);
            }
            return iner.concreteIndices(state, (IndicesRequest)request);
        }
        return new Index[]{request.getConcreteIndex()};
    }

    static void performMappingUpdate(final Index[] concreteIndices, PutMappingRequest request, final ActionListener<AcknowledgedResponse> listener, MetadataMappingService metadataMappingService) {
        PutMappingClusterStateUpdateRequest updateRequest = (PutMappingClusterStateUpdateRequest)((PutMappingClusterStateUpdateRequest)((PutMappingClusterStateUpdateRequest)new PutMappingClusterStateUpdateRequest(request.source()).indices(concreteIndices)).ackTimeout(request.timeout())).masterNodeTimeout(request.clusterManagerNodeTimeout());
        metadataMappingService.putMapping(updateRequest, new ActionListener<ClusterStateUpdateResponse>(){

            public void onResponse(ClusterStateUpdateResponse response) {
                listener.onResponse((Object)new AcknowledgedResponse(response.isAcknowledged()));
            }

            public void onFailure(Exception t) {
                logger.debug(() -> new ParameterizedMessage("failed to put mappings on indices [{}]", Arrays.asList(concreteIndices)), (Throwable)t);
                listener.onFailure(t);
            }
        });
    }

    private List<String> checkForSystemIndexViolations(Index[] concreteIndices, String requestMappings) {
        ArrayList<String> violations = new ArrayList<String>();
        for (Index index : concreteIndices) {
            String descriptorMappings;
            SystemIndexDescriptor descriptor = this.systemIndices.findMatchingDescriptor(index.getName());
            if (descriptor == null || !descriptor.isAutomaticallyManaged() || (descriptorMappings = descriptor.getMappings()).equals(requestMappings)) continue;
            violations.add(index.getName());
        }
        return violations;
    }

    public static final class ActionProviderImpl
    implements ActionProvider {
        public ActionType<? extends ActionResponse> getInstance() {
            return PutMappingAction.INSTANCE;
        }

        public Class<? extends TransportAction<? extends ActionRequest, ? extends ActionResponse>> getTransportAction() {
            return TransportPutMappingAction.class;
        }
    }
}

