/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.admin.indices.resolve;

import io.skylite.common.action.ActionListener;
import io.skylite.common.util.concurrent.CountDown;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.OriginalIndices;
import io.skylite.core.action.admin.indices.resolve.ResolveIndexAction;
import io.skylite.core.action.spi.ActionProvider;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.action.support.IndicesOptions;
import io.skylite.core.action.support.TransportAction;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.metadata.IndexAbstraction;
import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.metadata.Metadata;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.common.Strings;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.tasks.Task;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.RemoteClusterService;
import io.skylite.core.transport.RemoteClusterUtils;
import io.skylite.core.transport.TransportService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.Spliterators;
import java.util.TreeMap;
import java.util.stream.StreamSupport;
import org.opensearch.cluster.metadata.IndexAbstractionResolver;

public class TransportResolveIndexAction
extends HandledTransportAction<ResolveIndexAction.Request, ResolveIndexAction.Response> {
    private final ThreadPool threadPool;
    private final ClusterService clusterService;
    private final RemoteClusterService remoteClusterService;
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private final IndexAbstractionResolver indexAbstractionResolver;

    @Inject
    public TransportResolveIndexAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("indices:admin/resolve/index", transportService, actionFilters, ResolveIndexAction.Request::new);
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.remoteClusterService = transportService.getRemoteClusterService();
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.indexAbstractionResolver = new IndexAbstractionResolver(indexNameExpressionResolver);
    }

    protected void doExecute(Task task, ResolveIndexAction.Request request, ActionListener<ResolveIndexAction.Response> listener) {
        ClusterState clusterState = this.clusterService.state();
        Map remoteClusterIndices = this.remoteClusterService.groupIndices(request.indicesOptions(), request.indices(), idx -> this.indexNameExpressionResolver.hasIndexAbstraction(idx, clusterState));
        OriginalIndices localIndices = (OriginalIndices)remoteClusterIndices.remove("");
        Metadata metadata = clusterState.metadata();
        ArrayList<ResolveIndexAction.ResolvedIndex> indices = new ArrayList<ResolveIndexAction.ResolvedIndex>();
        ArrayList<ResolveIndexAction.ResolvedAlias> aliases = new ArrayList<ResolveIndexAction.ResolvedAlias>();
        ArrayList<ResolveIndexAction.ResolvedDataStream> dataStreams = new ArrayList<ResolveIndexAction.ResolvedDataStream>();
        if (localIndices != null) {
            TransportResolveIndexAction.resolveIndices(localIndices.indices(), request.indicesOptions(), metadata, this.indexAbstractionResolver, indices, aliases, dataStreams, request.includeDataStreams());
        }
        if (remoteClusterIndices.size() > 0) {
            int remoteRequests = remoteClusterIndices.size();
            CountDown completionCounter = new CountDown(remoteRequests);
            SortedMap remoteResponses = Collections.synchronizedSortedMap(new TreeMap());
            Runnable terminalHandler = () -> {
                if (completionCounter.countDown()) {
                    TransportResolveIndexAction.mergeResults(remoteResponses, indices, aliases, dataStreams);
                    listener.onResponse((Object)new ResolveIndexAction.Response(indices, aliases, dataStreams));
                }
            };
            for (Map.Entry remoteIndices : remoteClusterIndices.entrySet()) {
                String clusterAlias = (String)remoteIndices.getKey();
                OriginalIndices originalIndices = (OriginalIndices)remoteIndices.getValue();
                Client remoteClusterClient = this.remoteClusterService.getRemoteClusterClient(this.threadPool, clusterAlias);
                ResolveIndexAction.Request remoteRequest = new ResolveIndexAction.Request(originalIndices.indices(), originalIndices.indicesOptions());
                remoteClusterClient.admin().indices().resolveIndex(remoteRequest, ActionListenerHelper.wrap(response -> {
                    remoteResponses.put(clusterAlias, response);
                    terminalHandler.run();
                }, failure -> terminalHandler.run()));
            }
        } else {
            listener.onResponse((Object)new ResolveIndexAction.Response(indices, aliases, dataStreams));
        }
    }

    static void resolveIndices(String[] names, IndicesOptions indicesOptions, Metadata metadata, IndexAbstractionResolver resolver, List<ResolveIndexAction.ResolvedIndex> indices, List<ResolveIndexAction.ResolvedAlias> aliases, List<ResolveIndexAction.ResolvedDataStream> dataStreams, boolean includeDataStreams) {
        List<String> resolvedIndexAbstractions = resolver.resolveIndexAbstractions(names, indicesOptions, metadata, includeDataStreams);
        SortedMap lookup = metadata.getIndicesLookup();
        for (String s : resolvedIndexAbstractions) {
            TransportResolveIndexAction.enrichIndexAbstraction(s, lookup, indices, aliases, dataStreams);
        }
        indices.sort(Comparator.comparing(ResolveIndexAction.ResolvedIndexAbstraction::getName));
        aliases.sort(Comparator.comparing(ResolveIndexAction.ResolvedIndexAbstraction::getName));
        dataStreams.sort(Comparator.comparing(ResolveIndexAction.ResolvedIndexAbstraction::getName));
    }

    private static void mergeResults(Map<String, ResolveIndexAction.Response> remoteResponses, List<ResolveIndexAction.ResolvedIndex> indices, List<ResolveIndexAction.ResolvedAlias> aliases, List<ResolveIndexAction.ResolvedDataStream> dataStreams) {
        for (Map.Entry<String, ResolveIndexAction.Response> responseEntry : remoteResponses.entrySet()) {
            String clusterAlias = responseEntry.getKey();
            ResolveIndexAction.Response response = responseEntry.getValue();
            for (ResolveIndexAction.ResolvedIndex index : response.getIndices()) {
                indices.add(index.copy(RemoteClusterUtils.buildRemoteIndexName((String)clusterAlias, (String)index.getName())));
            }
            for (ResolveIndexAction.ResolvedAlias alias : response.getAliases()) {
                aliases.add(alias.copy(RemoteClusterUtils.buildRemoteIndexName((String)clusterAlias, (String)alias.getName())));
            }
            for (ResolveIndexAction.ResolvedDataStream dataStream : response.getDataStreams()) {
                dataStreams.add(dataStream.copy(RemoteClusterUtils.buildRemoteIndexName((String)clusterAlias, (String)dataStream.getName())));
            }
        }
    }

    private static void enrichIndexAbstraction(String indexAbstraction, SortedMap<String, IndexAbstraction> lookup, List<ResolveIndexAction.ResolvedIndex> indices, List<ResolveIndexAction.ResolvedAlias> aliases, List<ResolveIndexAction.ResolvedDataStream> dataStreams) {
        IndexAbstraction ia = (IndexAbstraction)lookup.get(indexAbstraction);
        if (ia != null) {
            switch (ia.getType()) {
                case CONCRETE_INDEX: {
                    boolean isFrozen;
                    IndexAbstraction.Index index = (IndexAbstraction.Index)ia;
                    Object[] aliasNames = (String[])StreamSupport.stream(Spliterators.spliteratorUnknownSize(index.getWriteIndex().getAliases().keySet().iterator(), 0), false).toArray(String[]::new);
                    Arrays.sort(aliasNames);
                    ArrayList<String> attributes = new ArrayList<String>();
                    attributes.add(index.getWriteIndex().getState() == IndexMetadata.State.OPEN ? "open" : "closed");
                    if (ia.isHidden()) {
                        attributes.add("hidden");
                    }
                    if (isFrozen = Boolean.parseBoolean(ia.getWriteIndex().getSettings().get("index.frozen"))) {
                        attributes.add("frozen");
                    }
                    attributes.sort(String::compareTo);
                    indices.add(new ResolveIndexAction.ResolvedIndex(index.getName(), (String[])aliasNames, attributes.toArray(Strings.EMPTY_ARRAY), index.getParentDataStream() == null ? null : index.getParentDataStream().getName()));
                    break;
                }
                case ALIAS: {
                    IndexAbstraction.Alias alias = (IndexAbstraction.Alias)ia;
                    Object[] indexNames = (String[])alias.getIndices().stream().map(i -> i.getIndex().getName()).toArray(String[]::new);
                    Arrays.sort(indexNames);
                    aliases.add(new ResolveIndexAction.ResolvedAlias(alias.getName(), (String[])indexNames));
                    break;
                }
                case DATA_STREAM: {
                    IndexAbstraction.DataStream dataStream = (IndexAbstraction.DataStream)ia;
                    Object[] backingIndices = (String[])dataStream.getIndices().stream().map(i -> i.getIndex().getName()).toArray(String[]::new);
                    Arrays.sort(backingIndices);
                    dataStreams.add(new ResolveIndexAction.ResolvedDataStream(dataStream.getName(), (String[])backingIndices, dataStream.getDataStream().getTimeStampField().getName()));
                    break;
                }
                default: {
                    throw new IllegalStateException("unknown index abstraction type: " + String.valueOf(ia.getType()));
                }
            }
        }
    }

    public static final class ActionProviderImpl
    implements ActionProvider {
        public ActionType<? extends ActionResponse> getInstance() {
            return ResolveIndexAction.INSTANCE;
        }

        public Class<? extends TransportAction<? extends ActionRequest, ? extends ActionResponse>> getTransportAction() {
            return TransportResolveIndexAction.class;
        }
    }
}

