/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.admin.indices.segments;

import io.lucenia.action.support.broadcast.node.TransportBroadcastByNodeAction;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.admin.indices.segments.IndicesSegmentResponse;
import io.skylite.core.action.admin.indices.segments.PitSegmentsAction;
import io.skylite.core.action.admin.indices.segments.PitSegmentsRequest;
import io.skylite.core.action.admin.indices.segments.ShardSegments;
import io.skylite.core.action.search.ListPitInfo;
import io.skylite.core.action.search.PitService;
import io.skylite.core.action.search.SearchContextId;
import io.skylite.core.action.search.SearchContextIdForNode;
import io.skylite.core.action.spi.ActionProvider;
import io.skylite.core.action.support.DefaultShardOperationFailedException;
import io.skylite.core.action.support.TransportAction;
import io.skylite.core.cluster.block.ClusterBlockException;
import io.skylite.core.cluster.block.ClusterBlockLevel;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.routing.PlainShardsIterator;
import io.skylite.core.cluster.routing.RecoverySource;
import io.skylite.core.cluster.routing.ShardRouting;
import io.skylite.core.cluster.routing.ShardRoutingState;
import io.skylite.core.cluster.routing.ShardsIterator;
import io.skylite.core.cluster.routing.UnassignedInfo;
import io.skylite.core.cluster.routing.allocation.AllocationId;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.common.Strings;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.NamedWriteableRegistry;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.tasks.Task;
import io.skylite.core.transport.TransportService;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.opensearch.indices.IndicesService;
import org.opensearch.search.SearchService;
import org.opensearch.search.internal.PitReaderContext;

public class TransportPitSegmentsAction
extends TransportBroadcastByNodeAction<PitSegmentsRequest, IndicesSegmentResponse, ShardSegments> {
    private final ClusterService clusterService;
    private final IndicesService indicesService;
    private final SearchService searchService;
    private final NamedWriteableRegistry namedWriteableRegistry;
    private final TransportService transportService;
    private final PitService pitService;

    @Inject
    public TransportPitSegmentsAction(ClusterService clusterService, TransportService transportService, IndicesService indicesService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, SearchService searchService, NamedWriteableRegistry namedWriteableRegistry, PitService pitService) {
        super("indices:monitor/point_in_time/segments", clusterService, transportService, actionFilters, indexNameExpressionResolver, PitSegmentsRequest::new, "management");
        this.clusterService = clusterService;
        this.indicesService = indicesService;
        this.searchService = searchService;
        this.namedWriteableRegistry = namedWriteableRegistry;
        this.transportService = transportService;
        this.pitService = pitService;
    }

    @Override
    protected void doExecute(Task task, PitSegmentsRequest request, ActionListener<IndicesSegmentResponse> listener) {
        if (request.getPitIds().size() == 1 && "_all".equals(request.getPitIds().get(0))) {
            this.pitService.getAllPits(ActionListenerHelper.wrap(response -> {
                request.clearAndSetPitIds(response.getPitInfos().stream().map(ListPitInfo::getPitId).collect(Collectors.toList()));
                super.doExecute(task, request, listener);
            }, arg_0 -> listener.onFailure(arg_0)));
        } else {
            super.doExecute(task, request, listener);
        }
    }

    @Override
    protected ShardsIterator shards(ClusterState clusterState, PitSegmentsRequest request, String[] concreteIndices) {
        ArrayList<PitAwareShardRouting> iterators = new ArrayList<PitAwareShardRouting>();
        LinkedHashSet uniquePitIds = new LinkedHashSet(request.getPitIds());
        for (String pitId : uniquePitIds) {
            SearchContextId searchContext = SearchContextId.decode((NamedWriteableRegistry)this.namedWriteableRegistry, (String)pitId);
            for (Map.Entry entry : searchContext.shards().entrySet()) {
                SearchContextIdForNode perNode = (SearchContextIdForNode)entry.getValue();
                if (!Strings.isEmpty((CharSequence)perNode.getClusterAlias())) continue;
                ShardId shardId = (ShardId)entry.getKey();
                iterators.add(new PitAwareShardRouting(this, pitId, shardId, perNode.getNode(), null, true, ShardRoutingState.STARTED, null, null, null, -1L));
            }
        }
        return new PlainShardsIterator(iterators);
    }

    @Override
    protected ClusterBlockException checkGlobalBlock(ClusterState state, PitSegmentsRequest request) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    @Override
    protected ClusterBlockException checkRequestBlock(ClusterState state, PitSegmentsRequest countRequest, String[] concreteIndices) {
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_READ, concreteIndices);
    }

    @Override
    protected ShardSegments readShardResult(StreamInput in) throws IOException {
        return new ShardSegments(in);
    }

    @Override
    protected IndicesSegmentResponse newResponse(PitSegmentsRequest request, int totalShards, int successfulShards, int failedShards, List<ShardSegments> results, List<DefaultShardOperationFailedException> shardFailures, ClusterState clusterState) {
        return new IndicesSegmentResponse(results.toArray(new ShardSegments[0]), totalShards, successfulShards, failedShards, shardFailures);
    }

    @Override
    protected PitSegmentsRequest readRequestFrom(StreamInput in) throws IOException {
        return new PitSegmentsRequest(in);
    }

    @Override
    public List<ShardRouting> getShardRoutingsFromInputStream(StreamInput in) throws IOException {
        return in.readList(x$0 -> new PitAwareShardRouting(this, x$0));
    }

    @Override
    protected ShardSegments shardOperation(PitSegmentsRequest request, ShardRouting shardRouting) {
        assert (shardRouting instanceof PitAwareShardRouting);
        PitAwareShardRouting pitAwareShardRouting = (PitAwareShardRouting)shardRouting;
        SearchContextIdForNode searchContextIdForNode = (SearchContextIdForNode)SearchContextId.decode((NamedWriteableRegistry)this.namedWriteableRegistry, (String)pitAwareShardRouting.getPitId()).shards().get(shardRouting.shardId());
        PitReaderContext pitReaderContext = this.searchService.getPitReaderContext(searchContextIdForNode.getSearchContextId());
        if (pitReaderContext == null) {
            return new ShardSegments(shardRouting, Collections.emptyList());
        }
        return new ShardSegments(pitReaderContext.getShardRouting(), pitReaderContext.getSegments());
    }

    public class PitAwareShardRouting
    extends ShardRouting {
        private final String pitId;

        public PitAwareShardRouting(TransportPitSegmentsAction this$0, StreamInput in) throws IOException {
            super(in);
            this.pitId = in.readString();
        }

        public PitAwareShardRouting(TransportPitSegmentsAction this$0, String pitId, ShardId shardId, String currentNodeId, String relocatingNodeId, boolean primary, ShardRoutingState state, RecoverySource recoverySource, UnassignedInfo unassignedInfo, AllocationId allocationId, long expectedShardSize) {
            super(shardId, currentNodeId, relocatingNodeId, primary, state, recoverySource, unassignedInfo, allocationId, expectedShardSize);
            this.pitId = pitId;
        }

        public String getPitId() {
            return this.pitId;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.pitId);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            super.toXContent(builder, params);
            builder.field("pit_id", this.pitId);
            return builder.endObject();
        }
    }

    public static final class ActionProviderImpl
    implements ActionProvider {
        public ActionType<? extends ActionResponse> getInstance() {
            return PitSegmentsAction.INSTANCE;
        }

        public Class<? extends TransportAction<? extends ActionRequest, ? extends ActionResponse>> getTransportAction() {
            return TransportPitSegmentsAction.class;
        }
    }
}

