/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.admin.indices.settings.put;

import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.IndicesRequest;
import io.skylite.core.action.admin.indices.settings.put.UpdateSettingsAction;
import io.skylite.core.action.admin.indices.settings.put.UpdateSettingsClusterStateUpdateRequest;
import io.skylite.core.action.admin.indices.settings.put.UpdateSettingsRequest;
import io.skylite.core.action.clustermanager.AcknowledgedResponse;
import io.skylite.core.action.spi.ActionProvider;
import io.skylite.core.action.support.TransportAction;
import io.skylite.core.action.support.clustermanager.TransportClusterManagerNodeAction;
import io.skylite.core.cluster.block.ClusterBlockException;
import io.skylite.core.cluster.block.ClusterBlockLevel;
import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.cluster.state.ClusterStateUpdateResponse;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.index.Index;
import io.skylite.core.index.IndexModuleSettings;
import io.skylite.core.index.store.IndexStoreSettings;
import io.skylite.core.indices.SystemIndexDescriptor;
import io.skylite.core.indices.SystemIndices;
import io.skylite.core.settings.Settings;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportService;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.cluster.metadata.MetadataUpdateSettingsService;

public class TransportUpdateSettingsAction
extends TransportClusterManagerNodeAction<UpdateSettingsRequest, AcknowledgedResponse> {
    private static final Logger logger = LogManager.getLogger(TransportUpdateSettingsAction.class);
    private static final Set<String> ALLOWLIST_REMOTE_SNAPSHOT_SETTINGS = Set.of("index.max_result_window", "index.max_inner_result_window", "index.max_rescore_window", "index.max_docvalue_fields_search", "index.max_script_fields", "index.max_terms_count", "index.max_regex_length", "index.highlight.max_analyzed_offset");
    private static final String[] ALLOWLIST_REMOTE_SNAPSHOT_SETTINGS_PREFIXES = new String[]{"index.search.slowlog"};
    private final MetadataUpdateSettingsService updateSettingsService;
    private final SystemIndices systemIndices;

    @Inject
    public TransportUpdateSettingsAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, MetadataUpdateSettingsService updateSettingsService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, SystemIndices systemIndices) {
        super("indices:admin/settings/update", transportService, clusterService, threadPool, actionFilters, UpdateSettingsRequest::new, indexNameExpressionResolver);
        this.updateSettingsService = updateSettingsService;
        this.systemIndices = systemIndices;
    }

    protected String executor() {
        return "same";
    }

    /*
     * Unable to fully structure code
     */
    protected ClusterBlockException checkBlock(UpdateSettingsRequest request, ClusterState state) {
        block6: {
            globalBlock = state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
            if (globalBlock != null) {
                return globalBlock;
            }
            if (request.settings().size() == 1 && IndexMetadata.INDEX_BLOCKS_METADATA_SETTING.exists(request.settings()) || IndexMetadata.INDEX_READ_ONLY_SETTING.exists(request.settings()) || IndexMetadata.INDEX_BLOCKS_READ_ONLY_ALLOW_DELETE_SETTING.exists(request.settings())) {
                return null;
            }
            requestIndices = this.indexNameExpressionResolver.concreteIndices(state, (IndicesRequest)request);
            allowSearchableSnapshotSettingsUpdate = true;
            for (Index index : requestIndices) {
                if (!state.blocks().indexBlocked(ClusterBlockLevel.METADATA_WRITE, index.getName())) continue;
                allowSearchableSnapshotSettingsUpdate = allowSearchableSnapshotSettingsUpdate != false && IndexModuleSettings.Type.REMOTE_SNAPSHOT.match(state.getMetadata().getIndexSafe(index).getSettings().get(IndexStoreSettings.INDEX_STORE_TYPE_SETTING.getKey())) != false;
            }
            if (!allowSearchableSnapshotSettingsUpdate) break block6;
            for (String setting : request.settings().keySet()) {
                if (!allowSearchableSnapshotSettingsUpdate) ** GOTO lbl-1000
                if (TransportUpdateSettingsAction.ALLOWLIST_REMOTE_SNAPSHOT_SETTINGS.contains(setting)) ** GOTO lbl-1000
                if (Stream.of(TransportUpdateSettingsAction.ALLOWLIST_REMOTE_SNAPSHOT_SETTINGS_PREFIXES).anyMatch((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, startsWith(java.lang.String ), (Ljava/lang/String;)Z)((String)setting))) lbl-1000:
                // 2 sources

                {
                    v0 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v0 = false;
                }
                allowSearchableSnapshotSettingsUpdate = v0;
            }
        }
        return allowSearchableSnapshotSettingsUpdate != false ? null : state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_WRITE, this.indexNameExpressionResolver.concreteIndexNames(state, (IndicesRequest)request));
    }

    protected AcknowledgedResponse read(StreamInput in) throws IOException {
        return new AcknowledgedResponse(in);
    }

    protected void clusterManagerOperation(UpdateSettingsRequest request, ClusterState state, final ActionListener<AcknowledgedResponse> listener) {
        Settings requestSettings;
        final Index[] concreteIndices = this.indexNameExpressionResolver.concreteIndices(state, (IndicesRequest)request);
        Map<String, List<String>> systemIndexViolations = this.checkForSystemIndexViolations(concreteIndices, requestSettings = request.settings());
        if (!systemIndexViolations.isEmpty()) {
            String message = "Cannot override settings on system indices: " + systemIndexViolations.entrySet().stream().map(entry -> "[" + (String)entry.getKey() + "] -> " + String.valueOf(entry.getValue())).collect(Collectors.joining(", "));
            logger.warn(message);
            listener.onFailure((Exception)new IllegalArgumentException(message));
            return;
        }
        UpdateSettingsClusterStateUpdateRequest clusterStateUpdateRequest = (UpdateSettingsClusterStateUpdateRequest)((UpdateSettingsClusterStateUpdateRequest)((UpdateSettingsClusterStateUpdateRequest)new UpdateSettingsClusterStateUpdateRequest().indices(concreteIndices)).settings(requestSettings).setPreserveExisting(request.isPreserveExisting()).ackTimeout(request.timeout())).masterNodeTimeout(request.clusterManagerNodeTimeout());
        this.updateSettingsService.updateSettings(clusterStateUpdateRequest, new ActionListener<ClusterStateUpdateResponse>(){

            public void onResponse(ClusterStateUpdateResponse response) {
                listener.onResponse((Object)new AcknowledgedResponse(response.isAcknowledged()));
            }

            public void onFailure(Exception t) {
                logger.debug(() -> new ParameterizedMessage("failed to update settings on indices [{}]", (Object)concreteIndices), (Throwable)t);
                listener.onFailure(t);
            }
        });
    }

    private Map<String, List<String>> checkForSystemIndexViolations(Index[] concreteIndices, Settings requestSettings) {
        HashMap<String, List<String>> violations = new HashMap<String, List<String>>();
        for (Index index : concreteIndices) {
            SystemIndexDescriptor descriptor = this.systemIndices.findMatchingDescriptor(index.getName());
            if (descriptor == null || !descriptor.isAutomaticallyManaged()) continue;
            Settings descriptorSettings = descriptor.getSettings();
            ArrayList<String> failedKeys = new ArrayList<String>();
            for (String key : requestSettings.keySet()) {
                String actualValue;
                String expectedValue = descriptorSettings.get(key);
                if (expectedValue.equals(actualValue = requestSettings.get(key))) continue;
                failedKeys.add(key);
            }
            if (failedKeys.isEmpty()) continue;
            violations.put(descriptor.getIndexPattern(), failedKeys);
        }
        return violations;
    }

    public static final class ActionProviderImpl
    implements ActionProvider {
        public ActionType<? extends ActionResponse> getInstance() {
            return UpdateSettingsAction.INSTANCE;
        }

        public Class<? extends TransportAction<? extends ActionRequest, ? extends ActionResponse>> getTransportAction() {
            return TransportUpdateSettingsAction.class;
        }
    }
}

