/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.admin.indices.shards;

import io.skylite.common.action.ActionListener;
import io.skylite.common.collect.Tuple;
import io.skylite.common.util.concurrent.CountDown;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.FailedNodeException;
import io.skylite.core.action.IndicesRequest;
import io.skylite.core.action.admin.indices.shards.IndicesShardStoresAction;
import io.skylite.core.action.admin.indices.shards.IndicesShardStoresRequest;
import io.skylite.core.action.admin.indices.shards.IndicesShardStoresResponse;
import io.skylite.core.action.spi.ActionProvider;
import io.skylite.core.action.support.TransportAction;
import io.skylite.core.action.support.clustermanager.TransportClusterManagerNodeReadAction;
import io.skylite.core.cluster.block.ClusterBlockException;
import io.skylite.core.cluster.block.ClusterBlockLevel;
import io.skylite.core.cluster.health.ClusterShardHealth;
import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.cluster.node.DiscoveryNodes;
import io.skylite.core.cluster.routing.IndexRoutingTable;
import io.skylite.core.cluster.routing.IndexShardRoutingTable;
import io.skylite.core.cluster.routing.RoutingNodes;
import io.skylite.core.cluster.routing.RoutingTable;
import io.skylite.core.cluster.routing.ShardRouting;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.CollectionUtil;
import org.opensearch.gateway.AsyncShardFetch;
import org.opensearch.gateway.TransportNodesListGatewayStartedShards;

public class TransportIndicesShardStoresAction
extends TransportClusterManagerNodeReadAction<IndicesShardStoresRequest, IndicesShardStoresResponse> {
    private static final Logger logger = LogManager.getLogger(TransportIndicesShardStoresAction.class);
    private final TransportNodesListGatewayStartedShards listShardStoresInfo;

    @Inject
    public TransportIndicesShardStoresAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, TransportNodesListGatewayStartedShards listShardStoresInfo) {
        super("indices:monitor/shard_stores", transportService, clusterService, threadPool, actionFilters, IndicesShardStoresRequest::new, indexNameExpressionResolver);
        this.listShardStoresInfo = listShardStoresInfo;
    }

    protected String executor() {
        return "same";
    }

    protected IndicesShardStoresResponse read(StreamInput in) throws IOException {
        return new IndicesShardStoresResponse(in);
    }

    protected void clusterManagerOperation(IndicesShardStoresRequest request, ClusterState state, ActionListener<IndicesShardStoresResponse> listener) {
        RoutingTable routingTables = state.routingTable();
        RoutingNodes routingNodes = state.getRoutingNodes();
        String[] concreteIndices = this.indexNameExpressionResolver.concreteIndexNames(state, (IndicesRequest)request);
        HashSet<Tuple<ShardId, String>> shardsToFetch = new HashSet<Tuple<ShardId, String>>();
        logger.trace("using cluster state version [{}] to determine shards", (Object)state.version());
        for (String index : concreteIndices) {
            IndexRoutingTable indexShardRoutingTables = routingTables.index(index);
            if (indexShardRoutingTables == null) continue;
            String customDataPath = (String)IndexMetadata.INDEX_DATA_PATH_SETTING.get(state.metadata().index(index).getSettings());
            for (IndexShardRoutingTable routing : indexShardRoutingTables) {
                int shardId = routing.shardId().id();
                ClusterShardHealth shardHealth = new ClusterShardHealth(shardId, routing);
                if (!request.shardStatuses().contains(shardHealth.getStatus())) continue;
                shardsToFetch.add((Tuple<ShardId, String>)Tuple.tuple((Object)routing.shardId(), (Object)customDataPath));
            }
        }
        new AsyncShardStoresInfoFetches(state.nodes(), routingNodes, shardsToFetch, listener).start();
    }

    protected ClusterBlockException checkBlock(IndicesShardStoresRequest request, ClusterState state) {
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_READ, this.indexNameExpressionResolver.concreteIndexNames(state, (IndicesRequest)request));
    }

    private class AsyncShardStoresInfoFetches {
        private final DiscoveryNodes nodes;
        private final RoutingNodes routingNodes;
        private final Set<Tuple<ShardId, String>> shards;
        private final ActionListener<IndicesShardStoresResponse> listener;
        private CountDown expectedOps;
        private final Queue<InternalAsyncFetch.Response> fetchResponses;

        AsyncShardStoresInfoFetches(DiscoveryNodes nodes, RoutingNodes routingNodes, Set<Tuple<ShardId, String>> shards, ActionListener<IndicesShardStoresResponse> listener) {
            this.nodes = nodes;
            this.routingNodes = routingNodes;
            this.shards = shards;
            this.listener = listener;
            this.fetchResponses = new ConcurrentLinkedQueue<InternalAsyncFetch.Response>();
            this.expectedOps = new CountDown(shards.size());
        }

        void start() {
            if (this.shards.isEmpty()) {
                this.listener.onResponse((Object)new IndicesShardStoresResponse());
            } else {
                for (Tuple<ShardId, String> shard : this.shards) {
                    InternalAsyncFetch fetch = new InternalAsyncFetch(logger, "shard_stores", (ShardId)shard.v1(), (String)shard.v2(), TransportIndicesShardStoresAction.this.listShardStoresInfo);
                    fetch.fetchData(this.nodes, Collections.emptyMap());
                }
            }
        }

        private class InternalAsyncFetch
        extends AsyncShardFetch<TransportNodesListGatewayStartedShards.NodeGatewayStartedShards> {
            InternalAsyncFetch(Logger logger, String type, ShardId shardId, String customDataPath, TransportNodesListGatewayStartedShards action) {
                super(logger, type, shardId, customDataPath, action);
            }

            @Override
            protected synchronized void processAsyncFetch(List<TransportNodesListGatewayStartedShards.NodeGatewayStartedShards> responses, List<FailedNodeException> failures, long fetchingRound) {
                AsyncShardStoresInfoFetches.this.fetchResponses.add(new Response(this, (ShardId)this.shardAttributesMap.keySet().iterator().next(), responses, failures));
                if (AsyncShardStoresInfoFetches.this.expectedOps.countDown()) {
                    this.finish();
                }
            }

            void finish() {
                HashMap indicesStoreStatusesBuilder = new HashMap();
                ArrayList<IndicesShardStoresResponse.Failure> failureBuilder = new ArrayList<IndicesShardStoresResponse.Failure>();
                for (Response fetchResponse : AsyncShardStoresInfoFetches.this.fetchResponses) {
                    Map indexStoreStatuses = (Map)indicesStoreStatusesBuilder.get(fetchResponse.shardId.getIndexName());
                    HashMap<Integer, ArrayList<Object>> indexShardsBuilder = indexStoreStatuses == null ? new HashMap() : new HashMap(indexStoreStatuses);
                    ArrayList<IndicesShardStoresResponse.StoreStatus> storeStatuses = (ArrayList<IndicesShardStoresResponse.StoreStatus>)indexShardsBuilder.get(fetchResponse.shardId.id());
                    if (storeStatuses == null) {
                        storeStatuses = new ArrayList<IndicesShardStoresResponse.StoreStatus>();
                    }
                    for (TransportNodesListGatewayStartedShards.NodeGatewayStartedShards response : fetchResponse.responses) {
                        if (!this.shardExistsInNode(response)) continue;
                        IndicesShardStoresResponse.StoreStatus.AllocationStatus allocationStatus = this.getAllocationStatus(fetchResponse.shardId.getIndexName(), fetchResponse.shardId.id(), response.getNode());
                        storeStatuses.add(new IndicesShardStoresResponse.StoreStatus(response.getNode(), response.getGatewayShardStarted().allocationId(), allocationStatus, response.getGatewayShardStarted().storeException()));
                    }
                    CollectionUtil.timSort(storeStatuses);
                    indexShardsBuilder.put(fetchResponse.shardId.id(), storeStatuses);
                    indicesStoreStatusesBuilder.put(fetchResponse.shardId.getIndexName(), Collections.unmodifiableMap(indexShardsBuilder));
                    for (FailedNodeException failure : fetchResponse.failures) {
                        failureBuilder.add(new IndicesShardStoresResponse.Failure(failure.nodeId(), fetchResponse.shardId.getIndexName(), fetchResponse.shardId.id(), failure.getCause()));
                    }
                }
                AsyncShardStoresInfoFetches.this.listener.onResponse((Object)new IndicesShardStoresResponse(indicesStoreStatusesBuilder, Collections.unmodifiableList(failureBuilder)));
            }

            private IndicesShardStoresResponse.StoreStatus.AllocationStatus getAllocationStatus(String index, int shardID, DiscoveryNode node) {
                for (ShardRouting shardRouting : AsyncShardStoresInfoFetches.this.routingNodes.node(node.getId())) {
                    ShardId shardId = shardRouting.shardId();
                    if (shardId.id() != shardID || !shardId.getIndexName().equals(index)) continue;
                    if (shardRouting.primary()) {
                        return IndicesShardStoresResponse.StoreStatus.AllocationStatus.PRIMARY;
                    }
                    if (shardRouting.assignedToNode()) {
                        return IndicesShardStoresResponse.StoreStatus.AllocationStatus.REPLICA;
                    }
                    return IndicesShardStoresResponse.StoreStatus.AllocationStatus.UNUSED;
                }
                return IndicesShardStoresResponse.StoreStatus.AllocationStatus.UNUSED;
            }

            private boolean shardExistsInNode(TransportNodesListGatewayStartedShards.NodeGatewayStartedShards response) {
                return response.getGatewayShardStarted().storeException() != null || response.getGatewayShardStarted().allocationId() != null;
            }

            @Override
            protected void reroute(String shardId, String reason) {
            }

            public class Response {
                private final ShardId shardId;
                private final List<TransportNodesListGatewayStartedShards.NodeGatewayStartedShards> responses;
                private final List<FailedNodeException> failures;

                Response(InternalAsyncFetch this$2, ShardId shardId, List<TransportNodesListGatewayStartedShards.NodeGatewayStartedShards> responses, List<FailedNodeException> failures) {
                    this.shardId = shardId;
                    this.responses = responses;
                    this.failures = failures;
                }
            }
        }
    }

    public static final class ActionProviderImpl
    implements ActionProvider {
        public ActionType<? extends ActionResponse> getInstance() {
            return IndicesShardStoresAction.INSTANCE;
        }

        public Class<? extends TransportAction<? extends ActionRequest, ? extends ActionResponse>> getTransportAction() {
            return TransportIndicesShardStoresAction.class;
        }
    }
}

