/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.admin.indices.shrink;

import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.admin.indices.create.CreateIndexClusterStateUpdateRequest;
import io.skylite.core.action.admin.indices.create.CreateIndexRequest;
import io.skylite.core.action.admin.indices.shrink.ResizeAction;
import io.skylite.core.action.admin.indices.shrink.ResizeRequest;
import io.skylite.core.action.admin.indices.shrink.ResizeResponse;
import io.skylite.core.action.admin.indices.shrink.ResizeType;
import io.skylite.core.action.admin.indices.stats.IndexShardStats;
import io.skylite.core.action.spi.ActionProvider;
import io.skylite.core.action.support.TransportAction;
import io.skylite.core.action.support.clustermanager.TransportClusterManagerNodeAction;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.block.ClusterBlockException;
import io.skylite.core.cluster.block.ClusterBlockLevel;
import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.cluster.state.CreateIndexClusterStateUpdateResponse;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.unit.ByteSizeValue;
import io.skylite.core.index.IndexNotFoundException;
import io.skylite.core.index.IndexSettings;
import io.skylite.core.index.shard.DocsStats;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.index.store.StoreStats;
import io.skylite.core.node.RemoteStoreNodeService;
import io.skylite.core.settings.ClusterSettings;
import io.skylite.core.settings.Settings;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportService;
import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.function.IntFunction;
import org.opensearch.cluster.metadata.MetadataCreateIndexService;

public class TransportResizeAction
extends TransportClusterManagerNodeAction<ResizeRequest, ResizeResponse> {
    private final MetadataCreateIndexService createIndexService;
    private final Client client;

    @Inject
    public TransportResizeAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, MetadataCreateIndexService createIndexService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Client client) {
        this("indices:admin/resize", transportService, clusterService, threadPool, createIndexService, actionFilters, indexNameExpressionResolver, client);
    }

    protected TransportResizeAction(String actionName, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, MetadataCreateIndexService createIndexService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Client client) {
        super(actionName, transportService, clusterService, threadPool, actionFilters, ResizeRequest::new, indexNameExpressionResolver);
        this.createIndexService = createIndexService;
        this.client = client;
    }

    protected String executor() {
        return "same";
    }

    protected ResizeResponse read(StreamInput in) throws IOException {
        return new ResizeResponse(in);
    }

    protected ClusterBlockException checkBlock(ResizeRequest request, ClusterState state) {
        return state.blocks().indexBlockedException(ClusterBlockLevel.METADATA_WRITE, request.getTargetIndexRequest().index());
    }

    protected void clusterManagerOperation(ResizeRequest resizeRequest, ClusterState state, ActionListener<ResizeResponse> listener) {
        String sourceIndex = this.indexNameExpressionResolver.resolveDateMathExpression(resizeRequest.getSourceIndex());
        String targetIndex = this.indexNameExpressionResolver.resolveDateMathExpression(resizeRequest.getTargetIndexRequest().index());
        IndexMetadata indexMetadata = state.metadata().index(sourceIndex);
        ClusterSettings clusterSettings = this.clusterService.getClusterSettings();
        if (resizeRequest.getResizeType().equals((Object)ResizeType.SHRINK) && state.metadata().isSegmentReplicationEnabled(sourceIndex) && indexMetadata != null && Integer.valueOf(indexMetadata.getSettings().get("index.number_of_replicas")) > 0) {
            this.client.admin().indices().prepareRefresh(new String[]{sourceIndex}).execute(ActionListenerHelper.delegateFailure(listener, (delegatedRefreshListener, refreshResponse) -> this.client.admin().indices().prepareStats(new String[]{sourceIndex}).clear().setDocs(true).setStore(true).setSegments(true).execute(ActionListenerHelper.delegateFailure((ActionListener)listener, (delegatedIndicesStatsListener, indicesStatsResponse) -> {
                CreateIndexClusterStateUpdateRequest updateRequest = TransportResizeAction.prepareCreateIndexRequest(resizeRequest, state, i -> {
                    IndexShardStats shard = (IndexShardStats)indicesStatsResponse.getIndex(sourceIndex).getIndexShards().get(i);
                    return shard == null ? null : shard.getPrimary().getDocs();
                }, indicesStatsResponse.getPrimaries().store, clusterSettings, sourceIndex, targetIndex);
                if (indicesStatsResponse.getIndex((String)sourceIndex).getTotal().getSegments().getReplicationStats().maxBytesBehind != 0L) {
                    throw new IllegalStateException(" For index [" + sourceIndex + "] replica shards haven't caught up with primary, please retry after sometime.");
                }
                this.createIndexService.createIndex(updateRequest, (ActionListener<CreateIndexClusterStateUpdateResponse>)ActionListenerHelper.map((ActionListener)delegatedIndicesStatsListener, response -> new ResizeResponse(response.isAcknowledged(), response.isShardsAcknowledged(), updateRequest.index())));
            }))));
        } else {
            this.client.admin().indices().prepareStats(new String[]{sourceIndex}).clear().setDocs(true).setStore(true).execute(ActionListenerHelper.delegateFailure(listener, (delegatedListener, indicesStatsResponse) -> {
                CreateIndexClusterStateUpdateRequest updateRequest = TransportResizeAction.prepareCreateIndexRequest(resizeRequest, state, i -> {
                    IndexShardStats shard = (IndexShardStats)indicesStatsResponse.getIndex(sourceIndex).getIndexShards().get(i);
                    return shard == null ? null : shard.getPrimary().getDocs();
                }, indicesStatsResponse.getPrimaries().store, clusterSettings, sourceIndex, targetIndex);
                this.createIndexService.createIndex(updateRequest, (ActionListener<CreateIndexClusterStateUpdateResponse>)ActionListenerHelper.map((ActionListener)delegatedListener, response -> new ResizeResponse(response.isAcknowledged(), response.isShardsAcknowledged(), updateRequest.index())));
            }));
        }
    }

    static CreateIndexClusterStateUpdateRequest prepareCreateIndexRequest(ResizeRequest resizeRequest, ClusterState state, IntFunction<DocsStats> perShardDocStats, StoreStats primaryShardsStoreStats, ClusterSettings clusterSettings, String sourceIndexName, String targetIndexName) {
        int numShards;
        CreateIndexRequest targetIndex = resizeRequest.getTargetIndexRequest();
        IndexMetadata metadata = state.metadata().index(sourceIndexName);
        if (metadata == null) {
            throw new IndexNotFoundException(sourceIndexName);
        }
        TransportResizeAction.validateRemoteMigrationModeSettings(resizeRequest.getResizeType(), metadata, clusterSettings);
        Settings.Builder targetIndexSettingsBuilder = Settings.builder().put(targetIndex.settings()).normalizePrefix("index.");
        targetIndexSettingsBuilder.remove("index.history.uuid");
        Settings targetIndexSettings = targetIndexSettingsBuilder.build();
        if (((Boolean)IndexMetadata.INDEX_READ_ONLY_SETTING.get(metadata.getSettings())).booleanValue() && !IndexMetadata.INDEX_READ_ONLY_SETTING.exists(targetIndexSettings)) {
            throw new IllegalArgumentException("target index [" + targetIndexName + "] will be blocked by [index.blocks.read_only=true] which is copied from the source index [" + sourceIndexName + "], this will disable metadata writes and cause the shards to be unassigned");
        }
        if (IndexMetadata.INDEX_NUMBER_OF_SHARDS_SETTING.exists(targetIndexSettings)) {
            numShards = (Integer)IndexMetadata.INDEX_NUMBER_OF_SHARDS_SETTING.get(targetIndexSettings);
        } else {
            assert (resizeRequest.getResizeType() != ResizeType.SPLIT) : "split must specify the number of shards explicitly";
            if (resizeRequest.getResizeType() == ResizeType.SHRINK) {
                numShards = TransportResizeAction.calculateTargetIndexShardsNum(resizeRequest.getMaxShardSize(), primaryShardsStoreStats, metadata);
            } else {
                assert (resizeRequest.getResizeType() == ResizeType.CLONE);
                numShards = metadata.getNumberOfShards();
            }
        }
        for (int i = 0; i < numShards; ++i) {
            if (resizeRequest.getResizeType() == ResizeType.SHRINK) {
                Set shardIds = IndexMetadata.selectShrinkShards((int)i, (IndexMetadata)metadata, (int)numShards);
                long count = 0L;
                for (ShardId id : shardIds) {
                    DocsStats docsStats = perShardDocStats.apply(id.id());
                    if (docsStats != null) {
                        count += docsStats.getCount();
                    }
                    if (count <= 0x7FFFFF7FL) continue;
                    throw new IllegalStateException("Can't merge index with more than [2147483519] docs - too many documents in shards " + String.valueOf(shardIds));
                }
                continue;
            }
            if (resizeRequest.getResizeType() == ResizeType.SPLIT) {
                Objects.requireNonNull(IndexMetadata.selectSplitShard((int)i, (IndexMetadata)metadata, (int)numShards));
                continue;
            }
            Objects.requireNonNull(IndexMetadata.selectCloneShard((int)i, (IndexMetadata)metadata, (int)numShards));
        }
        if (IndexMetadata.INDEX_NUMBER_OF_ROUTING_SHARDS_SETTING.exists(targetIndexSettings)) {
            boolean splitFromSingleShards;
            boolean bl = splitFromSingleShards = resizeRequest.getResizeType() == ResizeType.SPLIT && metadata.getNumberOfShards() == 1;
            if (!splitFromSingleShards) {
                throw new IllegalArgumentException("cannot provide index.number_of_routing_shards on resize");
            }
        }
        if (((Boolean)IndexSettings.INDEX_SOFT_DELETES_SETTING.get(metadata.getSettings())).booleanValue() && IndexSettings.INDEX_SOFT_DELETES_SETTING.exists(targetIndexSettings) && !((Boolean)IndexSettings.INDEX_SOFT_DELETES_SETTING.get(targetIndexSettings)).booleanValue()) {
            throw new IllegalArgumentException("Can't disable [index.soft_deletes.enabled] setting on resize");
        }
        String cause = resizeRequest.getResizeType().name().toLowerCase(Locale.ROOT) + "_index";
        targetIndex.cause(cause);
        Settings.Builder settingsBuilder = Settings.builder().put(targetIndexSettings);
        settingsBuilder.put("index.number_of_shards", numShards);
        targetIndex.settings(settingsBuilder);
        return ((CreateIndexClusterStateUpdateRequest)((CreateIndexClusterStateUpdateRequest)new CreateIndexClusterStateUpdateRequest(cause, targetIndex.index(), targetIndexName).ackTimeout(targetIndex.timeout())).masterNodeTimeout(targetIndex.clusterManagerNodeTimeout())).settings(targetIndex.settings()).aliases(targetIndex.aliases()).waitForActiveShards(targetIndex.waitForActiveShards()).recoverFrom(metadata.getIndex()).resizeType(resizeRequest.getResizeType()).copySettings(resizeRequest.getCopySettings() == null ? false : resizeRequest.getCopySettings());
    }

    protected static int calculateTargetIndexShardsNum(ByteSizeValue maxShardSize, StoreStats sourceIndexShardStoreStats, IndexMetadata sourceIndexMetaData) {
        if (maxShardSize == null || sourceIndexShardStoreStats == null || maxShardSize.getBytes() == 0L || sourceIndexShardStoreStats.getSizeInBytes() == 0L) {
            return 1;
        }
        int sourceIndexShardsNum = sourceIndexMetaData.getNumberOfShards();
        int minValue = (int)Math.ceil((double)sourceIndexShardStoreStats.getSizeInBytes() / (double)maxShardSize.getBytes());
        if (minValue >= sourceIndexShardsNum) {
            return sourceIndexShardsNum;
        }
        for (int i = minValue; i < sourceIndexShardsNum; ++i) {
            if (sourceIndexShardsNum % i != 0) continue;
            return i;
        }
        return sourceIndexShardsNum;
    }

    protected String getClusterManagerActionName(DiscoveryNode node) {
        return super.getClusterManagerActionName(node);
    }

    private static void validateRemoteMigrationModeSettings(ResizeType type, IndexMetadata sourceIndexMetadata, ClusterSettings clusterSettings) {
        RemoteStoreNodeService.CompatibilityMode compatibilityMode = (RemoteStoreNodeService.CompatibilityMode)clusterSettings.get(RemoteStoreNodeService.REMOTE_STORE_COMPATIBILITY_MODE_SETTING);
        if (compatibilityMode == RemoteStoreNodeService.CompatibilityMode.MIXED) {
            boolean invalidConfiguration;
            boolean isRemoteStoreEnabled = sourceIndexMetadata.getSettings().getAsBoolean("index.remote_store.enabled", Boolean.valueOf(false));
            RemoteStoreNodeService.Direction migrationDirection = (RemoteStoreNodeService.Direction)clusterSettings.get(RemoteStoreNodeService.MIGRATION_DIRECTION_SETTING);
            boolean bl = invalidConfiguration = migrationDirection == RemoteStoreNodeService.Direction.REMOTE_STORE && !isRemoteStoreEnabled || migrationDirection == RemoteStoreNodeService.Direction.DOCREP && isRemoteStoreEnabled;
            if (invalidConfiguration) {
                throw new IllegalStateException("Index " + String.valueOf(type) + " is not allowed as remote migration mode is mixed and index is remote store " + (isRemoteStoreEnabled ? "enabled" : "disabled"));
            }
        }
    }

    public static final class ActionProviderImpl
    implements ActionProvider {
        public ActionType<? extends ActionResponse> getInstance() {
            return ResizeAction.INSTANCE;
        }

        public Class<? extends TransportAction<? extends ActionRequest, ? extends ActionResponse>> getTransportAction() {
            return TransportResizeAction.class;
        }
    }
}

